<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Footer extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id', 'created_at', 'updated_at'];


    public function photo()
    {
        $lang = app()->getLocale();
        $photo = $this->morphOne('App\Models\Photo', 'pictures')->where('lang', $lang);
        if (!$photo) {
            $photo = $this->morphOne('App\Models\Photo', 'pictures')->where('lang', default_lang());
        }

        return $photo;
    }

    public function photo_panel()
    {
        return $this->morphMany('App\Models\Photo', 'pictures');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public static function json_d($item)
    {
        $role_title = null;
        $role_name = null;
        $role_name_arr = [];
        $roles_id = json_decode($item->role);
//        if(count($roles_id)<=0)
//        {
//            $role_title='همه';
//            $role_name='all';
//        }
        $roles = Role::whereIn('name', $roles_id)->get();
        foreach ($roles as $key => $role) {
            $role_title .= $key > 0 ? ',' : '';
            $role_title .= $role->title;
            $role_name .= $key > 0 ? ',' : '';
            $role_name .= $role->name;
            array_push($role_name_arr, $role->name);
        }
        return [$role_title, $role_name, $role_name_arr];
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            foreach ($item->photo_panel as $photo) {
                $path = $photo->path;
                if (is_file($path)) {
                    File::delete($path);
                }
                $photo->delete();
            }

            foreach ($item->langs as $lang) {
                if ($lang->type == 'file') {
                    if (is_file($lang->text)) {
                        File::delete($lang->text);
                    }
                }
                $lang->delete();
            }
        });

    }
}
