<?php

namespace App\Models;;

use Illuminate\Database\Eloquent\Model;

class Meta extends Model
{
    protected $table='meta';
    protected $fillable = [
        'id', 'name_page','description','keyword','title_page','priority','status'
    ];
    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang',app()->getLocale())->where('col_name','status')->where('text','active');
    }
    public function lang_url()
    {
        return $this->morphOne('App\Models\Lang', 'langs')
            ->where('lang',app()->getLocale())->where('col_name','name_page')->where('text',request()->fullUrl())
            ->orWhere('lang',app()->getLocale())->where('col_name','name_page')->where('text',request()->fullUrl().'/')
            ->orWhere('lang',app()->getLocale())->where('col_name','name_page')->where('text', explode('?', request()->fullUrl())[0])
            ->orWhere('lang',app()->getLocale())->where('col_name','name_page')->where('text', explode('?', request()->fullUrl())[0].'/');
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            foreach ($item->langs as $lang)
            {
                if($lang->type=='file')
                {
                    if(is_file($lang->text))
                    {
                        File::delete($lang->text);
                    }
                }
                $lang->delete();
            }
        });
    }
}
