<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\File;
use Carbon\Carbon;

class Modale extends Model
{
    use SoftDeletes;

    public $timestamps = true;
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function product()
    {
        return $this->hasOne('App\Models\Product', 'id', 'product_id')->whereHas('lang_active');
    }

    public function children()
    {
        return $this->hasMany('App\Models\Modale', 'parent_id')->with('children');
    }

    public function sizes()
    {
        return $this->hasMany('App\Models\ModelSize', 'model_id');
    }
    public function size_inventory()
    {
        return $this->hasMany('App\Models\ModelSize', 'model_id')->where('inventory','>',0);
    }
    public static function size_inventory_branch($m_id,$id)
    {
        $branch='inventory_branch_'.$id;
        $models=ModelSize::where('model_id',$m_id)->where($branch,'>',0)->get();
        return count($models);
    }

    public static function inventory_set($product,$type,$draft=null)
    {
        if($type=='online'){$type='inventory';}
        elseif($type=='offline'){$type='inventory1';}
        elseif($type=='branch1'){$type='inventory_branch_1';}
        elseif($type=='branch2'){$type='inventory_branch_2';}
        elseif($type=='branch3'){$type='inventory_branch_3';}
        elseif($type=='branch4'){$type='inventory_branch_4';}
        elseif($type=='branch5'){$type='inventory_branch_5';}
        elseif($type=='branch6'){$type='inventory_branch_6';}
        elseif($type=='branch7'){$type='inventory_branch_7';}
        elseif($type=='branch8'){$type='inventory_branch_8';}
        elseif($type=='branch9'){$type='inventory_branch_9';}
        elseif($type=='branch10'){$type='inventory_branch_10';}
        $inventory=0;
        if (count($product->sizes)) {
            foreach ($product->sizes as $size){
                if ($size->inventory>=0) {
                    $inventory+=$size->$type;
                }
            }
        }else{
            if ($product->inventory>=0) {
                $inventory=$product->$type;
            }
        }
        if($draft=='offline')
        {
            if (count($product->sizes)) {
                foreach ($product->sizes as $size){
                    if ($size->inventory>=0) {
                        $inventory+=$size->inventory;
                    }
                }
            }else{
                if ($product->inventory>=0) {
                    $inventory+=$product->inventory;
                }
            }
        }
        return $inventory;
    }
    public static function photo_set($product)
    {
        $url='';
        if($product->photo)
        {
            $url=url($product->photo->path);
        }
        elseif (count($product->gallery))
        {
            $url=url($product->gallery[0]->path);
        }
        elseif($product->product && is_file($product->product->thumbnail))
        {
            $url=url($product->product->thumbnail);
        }
        return $url;
    }

    public static function sale_branch($model,$branch,$from_date,$to_date)
    {
        $baskets=PanelBasket::where('status','active')->where('model_id',$model->id)->where('draft_type',$branch);
        if($from_date!=null)
            $baskets=$baskets->whereDate('updated_at','>=',$from_date);

        if($to_date!=null)
            $baskets=$baskets->whereDate('updated_at','<=',$to_date);

        $basket_num=$baskets->sum('num');
        $basket_price=$baskets->sum('price');

        return [$basket_num,$basket_price];
    }
    public static function size_set($product,$draft)
    {
        if($draft=='online'){$type='inventory';}
        elseif($draft=='offline'){$type='inventory1';}
        elseif($draft=='branch1'){$type='inventory_branch_1';}
        elseif($draft=='branch2'){$type='inventory_branch_2';}
        elseif($draft=='branch3'){$type='inventory_branch_3';}
        elseif($draft=='branch4'){$type='inventory_branch_4';}
        elseif($draft=='branch5'){$type='inventory_branch_5';}
        elseif($draft=='branch6'){$type='inventory_branch_6';}
        elseif($draft=='branch7'){$type='inventory_branch_7';}
        elseif($draft=='branch8'){$type='inventory_branch_8';}
        elseif($draft=='branch9'){$type='inventory_branch_9';}
        elseif($draft=='branch10'){$type='inventory_branch_10';}
        $res=null;
        if(count($product->sizes))
        {
            foreach ($product->sizes as $key=>$size)
            {
                if($draft=='offline')
                {
                    if(($size->inventory+$size->inventory1)>0)
                    {
                        $res.=$res!=null?';':'';
                        $res.=$size->title.'__'.($size->inventory+$size->inventory1).'__'.$size->id;
                    }
                }
                else
                {
                    if($size->$type>0)
                    {
                        $res.=$res!=null?';':'';
                        $res.=$size->title.'__'.$size->$type.'__'.$size->id;
                    }
                }
            }
        }
        else
        {
            $res='no';
        }
        return $res;
    }
    public static function inventories($product)
    {
        $inventory=0;
        if (count($product->sizes)) {
            foreach ($product->sizes as $size){
                if ($size->inventory>=0) {
                    $inventory+=$size->inventory;
                }
            }
        }else{
            if ($product->inventory>=0) {
                $inventory=$product->inventory;
            }
        }
        return $inventory;
    }
    public static function inventories1($product)
    {
        $inventory1=0;
        if (count($product->sizes)) {
            foreach ($product->sizes as $size){
                if ($size->inventory1>=0) {
                    $inventory1+=$size->inventory1;
                }
            }
        }else{
            if ($product->inventory1>=0) {
                $inventory1=$product->inventory1;
            }
        }
        return $inventory1;
    }

    public function parent()
    {
        return $this->hasOne('App\Models\Modale', 'id', 'parent_id');
    }
    public function buy_product()
    {
        return $this->hasMany('App\Models\Basket', 'model_id')->where('status',1);
    }
    public static function buy_product_count($id)
    {
        $count1=Basket::where('model_id',$id)->where('status',1)->sum('num');
        $count2=PanelBasket::where('model_id',$id)->where('status','!=','cancel')->sum('num');

        return $count1+$count2;
    }
    public static function inventory_count_ret($id,$type)
    {
        $count=0;
        $model=Modale::find($id);
        if(count($model->sizes))
        {
            foreach ($model->sizes as $size)
            {
                if($type=='all')
                {
                    $count+=$size->inventory+$size->inventory1+$size->inventory_branch_1+$size->inventory_branch_2 +
                        $size->inventory_branch_3+ $size->inventory_branch_4+$size->inventory_branch_5+
                        $size->inventory_branch_6+$size->inventory_branch_7+$size->inventory_branch_8+
                        $size->inventory_branch_9+$size->inventory_branch_10;
                }
                elseif($type=='online')
                {
                    $count+=$size->inventory;
                }
                elseif($type=='offline')
                {
                    $count+=$size->inventory1;
                }
                elseif($type=='b1')
                {
                    $count+=$size->inventory_branch_1;
                }
                elseif($type=='b2')
                {
                    $count+=$size->inventory_branch_2;
                }
                elseif($type=='b3')
                {
                    $count+=$size->inventory_branch_3;
                }
                elseif($type=='b4')
                {
                    $count+=$size->inventory_branch_4;
                }
                elseif($type=='b5')
                {
                    $count+=$size->inventory_branch_5;
                }
                elseif($type=='b6')
                {
                    $count+=$size->inventory_branch_6;
                }
                elseif($type=='b7')
                {
                    $count+=$size->inventory_branch_7;
                }
                elseif($type=='b8')
                {
                    $count+=$size->inventory_branch_8;
                }
                elseif($type=='b9')
                {
                    $count+=$size->inventory_branch_9;
                }
                elseif($type=='b10')
                {
                    $count+=$size->inventory_branch_10;
                }
            }
        }
        else
        {
            if($type=='all')
            {
                $count+=$model->inventory+$model->inventory1+$model->inventory_branch_1+$model->inventory_branch_2+
                    $model->inventory_branch_3+$model->inventory_branch_4+$model->inventory_branch_5+
                    $model->inventory_branch_6+$model->inventory_branch_7+$model->inventory_branch_8+
                    $model->inventory_branch_9+$model->inventory_branch_10;
            }
            elseif($type=='online')
            {
                $count=$model->inventory;
            }
            elseif($type=='offline')
            {
                $count=$model->inventory1;
            }
            elseif($type=='b1')
            {
                $count=$model->inventory_branch_1;
            }
            elseif($type=='b2')
            {
                $count=$model->inventory_branch_2;
            }
            elseif($type=='b3')
            {
                $count=$model->inventory_branch_3;
            }
            elseif($type=='b4')
            {
                $count=$model->inventory_branch_4;
            }
            elseif($type=='b5')
            {
                $count=$model->inventory_branch_5;
            }
            elseif($type=='b6')
            {
                $count=$model->inventory_branch_6;
            }
            elseif($type=='b7')
            {
                $count=$model->inventory_branch_7;
            }
            elseif($type=='b8')
            {
                $count=$model->inventory_branch_8;
            }
            elseif($type=='b9')
            {
                $count=$model->inventory_branch_9;
            }
            elseif($type=='b10')
            {
                $count=$model->inventory_branch_10;
            }
        }
        return $count;
    }
    public static function buy_product_count_all($id,$type)
    {
        $count=0;
        if($type=='all')
        {
            $count1=Basket::where('model_id',$id)->where('status',1)->sum('num');
            $count2=PanelBasket::where('model_id',$id)->where('status','!=','cancel')->sum('num');
            $count=$count1+$count2;
        }
        elseif($type=='year')
        {
            $count1=Basket::where('model_id',$id)->where('status',1)->whereDate('created_at','>=',Carbon::now()->subYears(1))->sum('num');
            $count2=PanelBasket::where('model_id',$id)->where('status','!=','cancel')->whereDate('created_at','>=',Carbon::now()->subYears(1))->sum('num');
            $count=$count1+$count2;
        }
        elseif($type=='month')
        {
            $count1=Basket::where('model_id',$id)->where('status',1)->whereDate('created_at','>=',Carbon::now()->subMonths(1))->sum('num');
            $count2=PanelBasket::where('model_id',$id)->where('status','!=','cancel')->whereDate('created_at','>=',Carbon::now()->subMonths(1))->sum('num');
            $count=$count1+$count2;
        }
        elseif($type=='week')
        {
            $count1=Basket::where('model_id',$id)->where('status',1)->whereDate('created_at','>=',Carbon::now()->subWeeks(1))->sum('num');
            $count2=PanelBasket::where('model_id',$id)->where('status','!=','cancel')->whereDate('created_at','>=',Carbon::now()->subWeeks(1))->sum('num');
            $count=$count1+$count2;
        }
        elseif($type=='day')
        {
            $count1=Basket::where('model_id',$id)->where('status',1)->where('created_at','>=',Carbon::now()->subHours(24))->sum('num');
            $count2=PanelBasket::where('model_id',$id)->where('status','!=','cancel')->where('created_at','>=',Carbon::now()->subHours(24))->sum('num');
            $count=$count1+$count2;
        }

        return $count;
    }
    public static function buy_product_count_online($id,$type)
    {
        $count=0;
        if($type=='all')
        {
            $count1=Basket::where('model_id',$id)->where('status',1)->sum('num');
            $count2=PanelBasket::where('model_id',$id)->where('online','>',0)->where('status','!=','cancel')->sum('online');
            $count3=PanelBasket::where('model_id',$id)->where('draft_type','online')->where('status','!=','cancel')->sum('num');
            $count=$count1+$count2+$count3;
        }
        elseif($type=='year')
        {
            $count1=Basket::where('model_id',$id)->where('status',1)->whereDate('created_at','>=',Carbon::now()->subYears(1))->sum('num');
            $count2=PanelBasket::where('model_id',$id)->where('online','>',0)->where('status','!=','cancel')->whereDate('created_at','>=',Carbon::now()->subYears(1))->sum('online');
            $count3=PanelBasket::where('model_id',$id)->where('draft_type','online')->where('status','!=','cancel')->whereDate('created_at','>=',Carbon::now()->subYears(1))->sum('num');
            $count=$count1+$count2+$count3;
        }
        elseif($type=='month')
        {
            $count1=Basket::where('model_id',$id)->where('status',1)->whereDate('created_at','>=',Carbon::now()->subMonths(1))->sum('num');
            $count2=PanelBasket::where('model_id',$id)->where('online','>',0)->where('status','!=','cancel')->whereDate('created_at','>=',Carbon::now()->subMonths(1))->sum('online');
            $count3=PanelBasket::where('model_id',$id)->where('draft_type','online')->where('status','!=','cancel')->whereDate('created_at','>=',Carbon::now()->subMonths(1))->sum('num');
            $count=$count1+$count2+$count3;
        }
        elseif($type=='week')
        {
            $count1=Basket::where('model_id',$id)->where('status',1)->whereDate('created_at','>=',Carbon::now()->subWeeks(1))->sum('num');
            $count2=PanelBasket::where('model_id',$id)->where('online','>',0)->where('status','!=','cancel')->where('created_at','>=',Carbon::now()->subWeeks(1))->sum('online');
            $count3=PanelBasket::where('model_id',$id)->where('draft_type','online')->where('status','!=','cancel')->where('created_at','>=',Carbon::now()->subWeeks(1))->sum('num');
            $count=$count1+$count2+$count3;
        }
        elseif($type=='day')
        {
            $count1=Basket::where('model_id',$id)->where('status',1)->where('created_at','>=',Carbon::now()->subHours(24))->sum('num');
            $count2=PanelBasket::where('model_id',$id)->where('online','>',0)->where('status','!=','cancel')->where('created_at','>=',Carbon::now()->subHours(24))->sum('online');
            $count3=PanelBasket::where('model_id',$id)->where('draft_type','online')->where('status','!=','cancel')->where('created_at','>=',Carbon::now()->subHours(24))->sum('num');
            $count=$count1+$count2+$count3;
        }

        return $count;
    }
    public static function buy_product_count_offline($id,$type)
    {
        $count=0;
        if($type=='all')
        {
            $count2=PanelBasket::where('model_id',$id)->where('offline','>',0)->where('status','!=','cancel')->sum('offline');
            $count=$count2;
        }
        elseif($type=='year')
        {
            $count2=PanelBasket::where('model_id',$id)->where('offline','>',0)->where('status','!=','cancel')->whereDate('created_at','>=',Carbon::now()->subYears(1))->sum('offline');
            $count=$count2;
        }
        elseif($type=='month')
        {
            $count2=PanelBasket::where('model_id',$id)->where('offline','>',0)->where('status','!=','cancel')->whereDate('created_at','>=',Carbon::now()->subMonths(1))->sum('offline');
            $count=$count2;
        }
        elseif($type=='week')
        {
            $count2=PanelBasket::where('model_id',$id)->where('offline','>',0)->where('status','!=','cancel')->where('created_at','>=',Carbon::now()->subWeeks(1))->sum('offline');
            $count=$count2;
        }
        elseif($type=='day')
        {
            $count2=PanelBasket::where('model_id',$id)->where('offline','>',0)->where('status','!=','cancel')->where('created_at','>=',Carbon::now()->subHours(24))->sum('offline');
            $count=$count2;
        }
        return $count;
    }
    public static function buy_product_count_branch($id,$type,$type_1)
    {
        $branch='branch'.$type_1;
        $count=0;
        if($type=='all')
        {
            $count2=PanelBasket::where('model_id',$id)->where('draft_type',$branch)->where('status','!=','cancel')->sum('num');
            $count=$count2;
        }
        elseif($type=='year')
        {
            $count2=PanelBasket::where('model_id',$id)->where('draft_type',$branch)->where('status','!=','cancel')->whereDate('created_at','>=',Carbon::now()->subYears(1))->sum('num');
            $count=$count2;
        }
        elseif($type=='month')
        {
            $count2=PanelBasket::where('model_id',$id)->where('draft_type',$branch)->where('status','!=','cancel')->whereDate('created_at','>=',Carbon::now()->subMonths(1))->sum('num');
            $count=$count2;
        }
        elseif($type=='week')
        {
            $count2=PanelBasket::where('model_id',$id)->where('draft_type',$branch)->where('status','!=','cancel')->where('created_at','>=',Carbon::now()->subWeeks(1))->sum('num');
            $count=$count2;
        }
        elseif($type=='day')
        {
            $count2=PanelBasket::where('model_id',$id)->where('draft_type',$branch)->where('status','!=','cancel')->where('created_at','>=',Carbon::now()->subHours(24))->sum('num');
            $count=$count2;
        }
        return $count;
    }

    public function soldOrders()
    {
        return $this->hasMany('App\Models\Basket', 'model_id')->where('status',1);
    }
    public function buy_factor()
    {
        return $this->hasMany('App\Models\Factor2', 'model_id')->where('status',0);
    }
    public function photo()
    {
        $lang=app()->getLocale();
        $photo= $this->hasOne('App\Models\Image', 'model_id')->where('lang',$lang)->where('type', 'photo')->where('collection','Models');
        if(!$photo->first())
        {
            $photo=$this->hasOne('App\Models\Image', 'model_id')->where('lang','fa')->where('type', 'photo')->where('collection','Models');
        }

        return $photo;
    }
    public function photo_panel()
    {
        return $this->hasMany('App\Models\Image', 'model_id')->where('type', 'photo')->where('collection','Models');
    }
    public function gallery()
    {
        $lang=app()->getLocale();
        $photos=$this->hasMany('App\Models\Image', 'model_id')->where('lang',$lang)->where('type', 'gallery')->where('collection','Models');
        if(!$photos)
        {
            $photos=$this->hasMany('App\Models\Image', 'model_id')->where('lang',default_lang())->where('type', 'gallery')->where('collection','Models');
        }

        return $photos;
    }
    public function gallery_panel()
    {
        return $this->hasMany('App\Models\Image', 'model_id')->where('type', 'gallery')->where('collection','Models');
    }
    public function report()
    {
        return $this->morphOne('App\Models\Activity', 'model_id');
    }
    public static function model_name()
    {
        return 'مدل محصول';
    }
    public static function model_title($model)
    {
        $title=null;
        $model_name=$model->type_val;
        $model_code=$model->code;
        $product_name=null;
        if($model->product)
        {
            $product_name=$model->product->title;
        }
        if($product_name!=null)
        {
            $title.='محصول ';
            $title.=$product_name;
        }
        if($model_name!=null)
        {
            $title.=$title!=null?',':'';
            $title.='مدل ';
            $title.=$model_name.'(کد:'.$model_code.')';
        }
        return $title;
    }
    public static function model_title2($model)
    {
        $title=null;
        $model_name=$model->type_val;
        $model_code=$model->code;
        $product_name=null;
        if($model->product)
        {
            $product_name=$model->product->title;
        }
        if($product_name!=null)
        {
            $title.='<p class="title" dir="rtl">';
            $title.='<span>'.$product_name.'</span>';
        }
        if($model_name!=null)
        {
            $title.=$title!=null?',':'';
            $title.='<span>'.$model_name.'(کد:'.$model_code.')'.'</span>';
            $title.='</p>';
        }



        return $title;
    }
    public static function model_title3($model)
    {
        $title=null;
        $model_name=$model->type_val;
        $model_code=$model->code;
        $product_name=null;
        if($model->product)
        {
            $product_name=$model->product->title;
        }
        if($product_name!=null)
        {
            $title.='<p class="title" dir="rtl">';
            $title.='<span>'.$product_name.'</span>';
        }
        if($model_name!=null)
        {
            $title.='<span>(کد:'.$model_code.')'.'</span>';
            $title.='</p>';
        }



        return $title;
    }
    public static function price_model($model)
    {
        $price=null;
        if((int)$model->price_vip>0 && $model->price_vip < $model->price)
        {
            $price=$model->price_vip;
        }
        else{
            $price=$model->price;
        }

        return $price;
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            foreach ($item->photo_panel as $photo)
            {
                $path = $photo->path;
                if(is_file($path))
                {
                    File::delete($path);
                }
                $photo->delete();
            }
            foreach ($item->gallery_panel as $photo)
            {
                $path = $photo->path;
                if(is_file($path))
                {
                    File::delete($path);
                }
                $photo->delete();
            }

            foreach ($item->langs as $lang)
            {
                if($lang->type=='file')
                {
                    if(is_file($lang->text))
                    {
                        File::delete($lang->text);
                    }
                }
                $lang->delete();
            }
        });

    }
}
