<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\File;

class Product extends Model
{

    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $appends = ['min_model_price', 'max_model_price'];
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function sizes_tbl()
    {
        return $this->hasMany('App\Models\ProductSize', 'product_id');
    }

    public function size_cat()
    {
        return $this->belongsTo('App\Models\SizeCat', 'size_cat_id');
    }

    public function product_size()
    {
        return $this->hasMany('App\Models\ProductSize', 'product_id');
    }

    public function soldOrders()
    {
        return $this->hasMany('App\Models\Basket', 'product_id')->where('status', 1);
    }

    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang', app()->getLocale())->where('col_name', 'show')->where('text', 1);
    }

    public static function size_filter($product, $type, $sizes)
    {
        $res = false;
        foreach ($product->models as $model) {
            if (count($model->sizes)) {
                foreach ($sizes as $size) {
                    if ($type == 'str' && ModelSize::where('model_id', $model->id)->where('title', 'LIKE', '%' . $size . '%')->first()) {
                        $res = true;
                    } elseif ($type == 'num' && ModelSize::where('model_id', $model->id)->where('size_number', 'LIKE', '%' . $size . '%')->first()) {
                        $res = true;
                    }
                }
            }
        }
        return $res;
    }

    public static function inventories($product)
    {
        $inventory = 0;
        foreach ($product->models as $model) {
            if (count($model->sizes)) {
                foreach ($model->sizes as $size) {
                    if ($size->inventory >= 0) {
                        $inventory += $size->inventory;
                    }
                }
            } else {
                if ($model->inventory >= 0) {
                    $inventory += $model->inventory;
                }
            }
        }
        return $inventory;
    }

    public static function inventory_set($product, $type)
    {
        $inventory = 0;
        if (count($product->models)) {
            foreach ($product->models as $model) {
                if ($inventory == 0) {
                    if (count($model->sizes)) {
                        foreach ($model->sizes as $size) {
                            if ($size->inventory >= 0) {
                                $inventory += 1;
                            }
                        }
                    } else {
                        if ($model->inventory >= 0) {
                            $inventory += 1;
                        }
                    }
                }
            }
        }
        return $inventory;
    }

    public function models()
    {
        $status='status_'.app()->getLocale();
//        return $this->hasMany('App\Models\Modale', 'product_id', 'id')->whereHas('lang_active');
        return $this->hasMany('App\Models\Modale', 'product_id')->where($status,1);
    }

    public function models_active()
    {
        $status='status_'.app()->getLocale();
        return $this->hasMany('App\Models\Modale', 'product_id')->where($status,1);
    }

    public function models_inventory()
    {
        $item = $this->hasOne('App\Models\ModelSize', 'product_id')->where('inventory', '>', 0);
        if (!$item->first()) {
            $item = $this->hasOne('App\Models\Modale', 'product_id')->where('inventory', '>', 0);
        }
        return $item;
    }

    public function getMaxModelPriceAttribute()
    {
        return $this->models()->get()->max('price');
    }

    public function getMinModelPriceAttribute()
    {
        return $this->models()->get()->min('price');
    }

    public static function invent($id)
    {
        $models = Modale::where('product_id', $id)->where('status', 1)->get();
        $inventory = 0;
        if (count($models) > 0) {
            foreach ($models as $model) {
                $inventory += $model->inventory;
            }
        }

        return $inventory;
    }

    public static function default_set($id = null)
    {
        $default = Modale::where('product_id', $id)->where('status', 1)->where('default', 1)->first();
        $default_id = 0;
        if ($default) {
            if ($default->inventory <= 0) {
                $models = Modale::where('product_id', $id)->where('status', 1)->get();

                if (count($models) > 0) {
                    foreach ($models as $model) {
                        $default = Modale::where('product_id', $id)->where('status', 1)->where('default', 1)->first();
                        if ($default and $default->inventory <= 0) {
                            if ($model->inventory > 0) {
                                $model->default = 1;
                                $model->update();
                                $default->default = 0;
                                $default->update();
                            }
                        }
                    }
                }
                $default = Modale::where('product_id', $id)->where('status', 1)->where('default', 1)->first();
            }
        } else {
            $models = Modale::where('product_id', $id)->where('status', 1)->get();

            if (count($models) > 0) {
                foreach ($models as $model) {
                    if ($model->inventory > 0) {
                        $model->default = 1;
                        $model->update();
                    }
                }
            }
            $default = Modale::where('product_id', $id)->where('status', 1)->where('default', 1)->first();
        }

        if ($default) {
            $default_id = $default->id;
        }
        return $default_id;
    }

    public function modelss()
    {
        return $this->hasMany('App\Models\Modale', 'product_id', 'id');
    }

    public function default()
    {
        $def = $this->hasOne('App\Models\Modale', 'product_id')->where('default', 1);
        if (!$def->first()) {
            $def = $this->hasOne('App\Models\Modale', 'product_id')->orderBy('id');
        }
        return $def;
    }

    public function inventory_model()
    {
//        ->whereHas('lang_active')
        return $this->hasMany('App\Models\Modale', 'product_id')->whereHas('size_inventory')->orWhere('inventory', '>', 0);
    }

    public function defaults()
    {
        return $this->hasOne('App\Models\Modale', 'product_id', 'id')->where('default', 1);
    }

    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'category_id');
    }

    public function category_active()
    {
        return $this->belongsTo('App\Models\Category', 'category_id')->whereHas('lang_active');
    }

    public static function feature($item)
    {
        $array = [];
        if (count(array_chunk(json_decode($item), 2)) > 0) {
            foreach (array_chunk(json_decode($item), 2) as $val) {
                array_push($array, [$val[0], $val[1]]);
            }
        }

        return $array;
    }

    public function brand()
    {
        return $this->belongsTo('App\Models\Brand', 'brand_id');
    }


    public function photoLarge()
    {
        $lang = app()->getLocale();
        $photo = $this->hasOne('App\Models\Image', 'model_id')->where('lang', $lang)->where('type', 'large')->where('collection', 'Product');
        if (!$photo->first()) {
            $photo = $this->hasOne('App\Models\Image', 'model_id')->where('lang', 'fa')->where('type', 'large')->where('collection', 'Product');
        }

        return $photo;
    }

    public function photoLarge_panel()
    {
        return $this->hasMany('App\Models\Image', 'model_id')->where('type', 'large')->where('collection', 'Product');
    }

    public function photoSmall()
    {
        $lang = app()->getLocale();
        $photo = $this->hasOne('App\Models\Image', 'model_id')->where('lang', $lang)->whereIN('type', ['small', 'photo_small'])->where('collection', 'Product');
        if (!$photo->first()) {
            $photo = $this->hasOne('App\Models\Image', 'model_id')->where('lang', 'fa')->whereIN('type', ['small', 'photo_small'])->where('collection', 'Product');
        }

        return $photo;
    }

    public function photoSmall_panel()
    {
        return $this->hasMany('App\Models\Image', 'model_id')->whereIN('type', ['small', 'photo_small'])->where('collection', 'Product');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            foreach ($item->langs as $lang) {
                if ($lang->type == 'file') {
                    if (is_file($lang->text)) {
                        File::delete($lang->text);
                    }
                }
                $lang->delete();
            }
            foreach ($item->photoLarge_panel as $photo) {
                if (is_file($photo->path)) {
                    File::delete($photo->path);
                }
                $photo->delete();
            }
            foreach ($item->photoSmall_panel as $photo) {
                if (is_file($photo->path)) {
                    File::delete($photo->path);
                }
                $photo->delete();
            }


            if ($item->pic_hover) {
                File::delete($item->pic_hover);
            }
            if ($item->size_cat_pic) {
                File::delete($item->size_cat_pic);
            }

            foreach ($item->sizes_tbl as $sizess) {
                $sizess->delete();
            }
            if ($item->modeles and count($item->modeles)) {
                foreach ($item->modeles as $modele) {
                    if (count($modele->gallery)) {
                        foreach ($modele as $gal) {
                            File::delete($gal->path);
                            $gal->delete();
                        }
                    }
                    $modele->delete();

                    if ($modele->photo) {
                        File::delete($modele->photo);
                    }


                }
            }
            if (count($item->product_size)) {
                foreach ($item->product_size as $product_size) {
                    $product_size->delete();
                }
            }

        });
    }

}
