<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\File;

class ProductRequest extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */

    protected $guarded = ['id', 'created_at', 'updated_at'];


    public function product()
    {
        return $this->hasOne('App\Models\Product', 'id', 'product_id');
    }

    public function price()
    {
        return $this->hasOne('App\Models\Price', 'id', 'price_id');
    }


    public function user()
    {

        return $this->hasOne('App\Models\User', 'id', 'user_id');

    }

    public function modale()
    {

        return $this->hasOne('App\Models\Modale', 'id', 'model_id');

    }
    public function size()
    {

        return $this->hasOne('App\Models\ModelSize', 'id', 'size_id');

    }

}