<?php

namespace App\Models;;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            foreach ($item->langs as $lang)
            {
                if($lang->type=='file')
                {
                    if(is_file($lang->text))
                    {
                        File::delete($lang->text);
                    }
                }
                $lang->delete();
            }
        });
    }
}
