<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Slider extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    public $timestamps = false;
    protected $guarded = ['id', 'created_at', 'updated_at'];
    public function photo()
    {
        $lang=app()->getLocale();

        $photo= $this->morphOne('App\Models\Photo', 'pictures')->where('lang',$lang);
        if(!$photo->first())
        {
            $photo=$this->morphOne('App\Models\Photo', 'pictures')->where('lang','fa');
        }

        return $photo;
    }
    public function photo_panel()
    {
        return $this->morphMany('App\Models\Photo', 'pictures');
    }
    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang',app()->getLocale())->where('col_name','status')->where('text','active');
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            foreach ($item->photo_panel as $photo)
            {
                $path = $photo->path;
                if(is_file($path))
                {
                    File::delete($path);
                }
                $photo->delete();
            }
            foreach ($item->langs as $lang)
            {
                if($lang->type=='file')
                {
                    if(is_file($lang->text))
                    {
                        File::delete($lang->text);
                    }
                }
                $lang->delete();
            }
        });
    }
}
