<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;

use App\Models\PriceUnit;
use App\Models\Setting;
use App\Models\Meta;
use App\Models\Category;
use App\Models\Favorite;
use Illuminate\View\View;
use Illuminate\Support\Facades;
use Illuminate\Support\Facades\Facade;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(Request $request): void
    {
        $this->url = $request->fullUrl();
        Facades\View::composer('layouts.front', function (View $view) {
            $basket_count=0;
            if (Cookie::has('basket')) {
                $basket_count = count(json_decode(Cookie::get('basket')));
            }

            $setting=Setting::firstOrFail();
            $titleSeo = read_lang($setting,'title');
            $keywordsSeo = read_lang($setting,'keywords');
            $descriptionSeo = read_lang($setting,'description');

            $seo = Meta::whereHas('lang_active')->whereHas('lang_url')->first();

            if (!is_null($seo)) {
                $titleSeo = read_lang($seo,'title_page');
                $keywordsSeo = read_lang($seo,'keyword');
                $descriptionSeo = read_lang($seo,'description');
            }
            $categories = Category::where('parent_id', null)->whereHas('lang_active')->with(['children'])->orderBy('sort_id', 'asc')->get();
            $view
                ->with('url' , $this->url)
                ->with('favorite_count' , Favorite::where('user_id',auth()->id())->count())
                ->with('basket_count' , $basket_count)
                ->with('setting' , $setting)
                ->with('titleSeo' , $titleSeo)
                ->with('keywordsSeo' , $keywordsSeo)
                ->with('descriptionSeo' , $descriptionSeo)
                ->with('categories' , $categories)
                ->with('price_types', PriceUnit::where('status','active')->get())
                ->with('dir',LaravelLocalization::getCurrentLocaleDirection());
        });
    }
}
