@if(isset($item))
    <a href="{{route('front.product.show',[$item->product->id,read_lang($item->product,'slug')])}}" class="card_product">
        <div class="position-relative overflow-hidden">
            @if(price_off_product($item,'model') > 0)
                <div class="off primary-bg off-primary-bg position-absolute h6 text-white fw-bold px-2 py-1 ms-2 mt-2">
                    <p>OFF</p>
                    <p>{{price_off_product($item,'model')}}</p>
                </div>
            @endif
            <img alt="{{read_lang($item->product,'title')}}-{{read_lang($item,'type_val')}}"
                 src="@if($item->photo) {{url_big($item->photo->path)}} @else{{$item->product && $item->product->thumbnail ?url_big($item->product->thumbnail): url_big('assets/img/nopic.jpg')}} @endif"
                 class="img-fluid transition img_card_product {{count($item->size_inventory)?'':'opacity-5'}}">

        </div>
        <div class="d-flex align-items-center justify-content-between p-2">
            <div>
                <p class="text-dark fw-bold title_card_product">{{read_lang($item->product,'title')}}-{{read_lang($item,'type_val')}}</p>
                    <div class="d-flex align-items-center gap-2">
                        @if((int)read_lang($item,'price_vip') > 0 && (int)read_lang($item,'price_vip') < (int)read_lang($item,'price'))
                            <span class="text-muted price_span fw-bold h6 mb-0 text-decoration-line-through">{{number_format(price_convert(read_lang($item,'price')))}}</span>
                            <span class="text-danger price_span fw-bold h6 mb-0">{{number_format(price_convert(read_lang($item,'price_vip')))}} {{price_type()}}</span>
                        @else
                            <span class="text-danger price_span fw-bold h6 mb-0">{{number_format(price_convert(read_lang($item,'price')))}} {{price_type()}}</span>
                        @endif
                    </div>
            </div>
        </div>
    </a>
@endif