@extends('layouts.front')

@section('title',' shopping cart')

@section('content')
 <!-- breadcrumb -->

 <section id="breadcrumb" class="container left my-4">
    <div class="d-flex align-items-center gap-2">
        <a href="{{route('front.index')}}" class="transition primary-color fw-bold">Home</a>
        <span>/</span>
        <span>Cart</span>
    </div>
</section>

<!-- cart -->

<section id="cart" class="my-5 container top" style="overflow: visible">
    <div class="row g-4">
        @if(count($baskets))
        <div class="col-lg-8 pe-lg-4">
            <h4 class="font-bold d-table after">Shopping cart</h4>
            <div class="mt-4 text-center">
                <div class="row d-none d-md-flex border-bottom py-3 text-muted fw-bold">
                    <div class="col-5 text-start">Product Details</div>
                    <div class="col-2">Price</div>
                    <div class="col-2">Quantity</div>
                    <div class="col-2">Total Price</div>
                    <div class="col-1"></div>
                </div>
                @foreach($baskets as $basket)
                <div
                    class="row g-4 g-md-0 flex-column flex-md-row align-items-center border-bottom py-3 text-muted fw-bold">
                    <div class="col-md-5">
                        <div
                            class="d-flex flex-column flex-md-row align-items-center justify-content-center justify-content-md-start gap-4">
                            <img alt="cart"
                                src="@if(!is_null($basket['model']->photo)) {{url_big($basket['model']->photo->path)}} @else {{$basket['model']->product->thumbnail ?url_big($basket['model']->product->thumbnail): url('assets/img/nopic.jpg')}} @endif"
                                class="img-fluid w-51 cardImg">
                            <div>
                                <p class="font-bold text-dark h5 mb-2">
                                    <a target="_blank" class="text-black" href="{{route('front.product.show',[$basket['model']->product->id,read_lang($basket['model']->product,'slug')])}}">
                                        {{read_lang($basket['model']->product,'title')}}
                                    </a>
                                </p>
                                <div
                                    class="d-flex align-items-center justify-content-center justify-content-md-start gap-2">
                                    <span>{{read_lang($basket['model'],'type')}}: {{read_lang($basket['model'],'type_val')}}</span>
                                    <p class="text-muted fw-bold">{{$basket['size']->title}}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2 font-bold">
                        @if((int)read_lang($basket['model'],'price_vip') > 0 && (int)read_lang($basket['model'],'price_vip') < (int)read_lang($basket['model'],'price'))
                            <p class="text-danger font-bold h5">{{number_format(price_convert(read_lang($basket['model'],'price_vip')))}} {{price_type()}}</p>
                            <p class="text-muted text-decoration-line-through">{{number_format(price_convert(read_lang($basket['model'],'price')))}} {{price_type()}}</p>
                        @else
                            <p class="text-danger font-bold h4">{{number_format(price_convert(read_lang($basket['model'],'price')))}} {{price_type()}}</p>
                        @endif
                    </div>
                    <div class="col-md-2">
                        <form action="{{route('front.cart.update',[$basket['model']->id,$basket['size']->id])}}" method="post"
                            class="border d-flex fw-bold align-items-center mx-auto justify-content-between rounded-pill py-2 px-2 w-80">
                            @csrf
{{--                            <span class="cursor decrease" onclick="this.form.submit()">-</span>--}}
                            <input class="quantity w-100 text-center border-0" min="1" onchange="this.form.submit()" name="num" value="{{$basket['number']}}">
{{--                            <span class="cursor increase" onclick="this.form.submit()">+</span>--}}
                        </form>
                    </div>
                    <div class="col-md-2 font-bold">
                        @if((int)read_lang($basket['model'],'price_vip') > 0 && (int)read_lang($basket['model'],'price_vip') < (int)read_lang($basket['model'],'price'))
                            <p class="text-danger font-bold h5">{{number_format(price_convert(read_lang($basket['model'],'price_vip')) * $basket['number'])}} {{price_type()}}</p>
                        @else
                            <p class="text-danger font-bold h5">{{number_format(price_convert(read_lang($basket['model'],'price')) * $basket['number'])}} {{price_type()}}</p>
                        @endif
                    </div>
                    <div class="col-md-1 remove-cart">

                        <a href="{{route('front.cart.delete',[$basket['model']->id,$basket['size']->id])}}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor"
                                 class="bi bi-x cursor" viewBox="0 0 16 16">
                                <path
                                        d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z" />
                            </svg>
                        </a>
                    </div>
                </div>
                @endforeach
            </div>
            <div class="mt-2 row g-4 align-items-end">
                <div class="col-lg-6 order-1 order-lg-0">
                    <a href="{{route('front.product.index')}}"
                        class="d-flex align-items-center justify-content-center justify-content-lg-start gap-2 primary-color">
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="currentColor"
                            class="bi bi-arrow-left-short" viewBox="0 0 16 16">
                            <path fill-rule="evenodd"
                                d="M12 8a.5.5 0 0 1-.5.5H5.707l2.147 2.146a.5.5 0 0 1-.708.708l-3-3a.5.5 0 0 1 0-.708l3-3a.5.5 0 1 1 .708.708L5.707 7.5H11.5a.5.5 0 0 1 .5.5z" />
                        </svg>
                        <span class="font-bold h5">Continue Shopping</span>
                    </a>
                </div>
            </div>
        </div>
        <div class="col-lg-4 primary-bg p-4">
            <div class="rounded-3 bg-white p-3 w-100 p-sticky">
                <h4 class="font-bold d-table">Review</h4>
                <div class="border-bottom py-3">
                    <div class="row mb-3">
                        <div class="col-lg-6 text-muted">Subtotal</div>
                        <div class="col-lg-6">{{number_format(price_convert($all_price))}} {{price_type()}}</div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-lg-6 text-muted">Discount</div>
                        <div class="col-lg-6">{{number_format(price_convert($discount_price))}} {{price_type()}}</div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6 text-muted">Shipping Cost</div>
                        <div class="col-lg-6">{{number_format(price_convert(10))}} {{price_type()}}</div>
                    </div>
                </div>
                <div class="border-bottom py-3">
                    <div class="row">
                        <div class="col-lg-6 text-dark">Total</div>
                        <div class="col-lg-6 text-danger font-bold">{{number_format(price_convert($total_price+10))}} {{price_type()}}</div>
                    </div>
                </div>
                @if(auth()->check())
                <a href="{{route('front.cart.end')}}"
                   class="primary-bg text-center font-bold text-white w-100 d-block h5 py-3 mt-4 rounded-pill">Pay</a>
                @else
                    <div class="new-comment-blog py-3">
                        To Submit an Basket
                        <a href="{{route('login')}}" class="login-btn btn-text font-weight-bold">Login</a> Or
                        <a class="btn-text font-weight-bold" href="{{route('register')}}">Register</a>
                    </div>
                @endif
            </div>
            <div class="rounded-3 bg-white p-3 m-4 w-100 d-none">
                <h4 class="font-bold d-table">Payment Details</h4>
                <div class="mt-4">
                    <p class="text-muted fw-bold">Card Type</p>
                    <!-- swiper -->
                    <div class="swiper card mt-2 border-0">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide cursor">
                                <img alt="card" src="{{url('assets/img/visa.jpg')}}" class="w-100">
                            </div>
                            <div class="swiper-slide cursor">
                                <img alt="card" src="{{url('assets/img/Master-card-classic-1.png')}}" class="w-100">
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <p class="text-muted fw-bold">Name on the card</p>
                        <input value="Yakoob Khedri" class="border-0 font-bold">
                    </div>
                    <div class="mt-4">
                        <p class="text-muted fw-bold">Card number</p>
                        <input value="3434 8789 0987 0054" class="border-0 font-bold">
                    </div>
                    <div class="row g-3 g-lg-0 mt-lg-4 mt-2">
                        <div class="col-lg-6">
                            <p class="text-muted fw-bold">Expiration date</p>
                            <input type="date" class="border-0 font-bold w-100">
                        </div>
                        <div class="col-lg-1"></div>
                        <div class="col-lg-3">
                            <p class="text-muted fw-bold">CVV</p>
                            <input type="password" value="222" class="border-0 font-bold w-100">
                        </div>
                    </div>

                    <a href="{{route('front.cart.deliver.address')}}"
                        class="primary-bg text-center font-bold text-white w-100 d-block h5 py-3 mt-4 rounded-pill">Continue</a>

                </div>
            </div>
        </div>
        @else
            <div class="col-lg-8 col-md-10 mx-auto alert alert-danger text-center">
                Cart Empty
            </div>
        @endif
    </div>
</section>
@endsection