@extends('layouts.front')

@section('title',' About')

@section('styles')
    <style>
        #sizing-modal > div {
            transition: all 0.6s;
            -webkit-transition: all 0.6s;
        }

        #sizing-modal .modal-body img {
            width: 100% !important;
            //height: 500px !important;
            object-fit: contain !important;
            transition: all 0.6s;
            -webkit-transition: all 0.6s;
        }

        #sizing-modal .modal-body img.h_auto {
            height: auto !important;
            object-fit: none !important;
        }

        .modal_js_small_click,
        .modal_js_big_click {
            font-size: 14px;
            margin-left: 10px;
        }
    </style>
@endsection
@section('content')
    <style>
        #category div div::before, #styles a::before, #trend a::before, .tab-content .tab-pane:last-child a::before {
            display: none;
        }
    </style>
    <!-- breadcrumb -->

    <section id="breadcrumb" class="container left my-4">
        <div class="d-flex flex-wrap align-items-center gap-2">
            <a href="{{route('front.index')}}" class="transition primary-color fw-bold">Home</a>
            <span>/</span>
            @if($item->category)
                <a href="{{route('front.product.index',[$item->category->id,read_lang($item->category,'slug')])}}"
                   class="transition primary-color fw-bold">{{read_lang($item->category,'name')}}</a>
                <span>/</span>
            @endif
            <span>{{read_lang($item,'title')}}</span>
        </div>
    </section>

    <!-- product details -->

    <section id="Product-details" class="container my-4" style="overflow-x: visible;">
        <div class="row g-4">
            <div class="col-lg-6">
                <div class="d-flex gap-2">
                    <div class="d-flex flex-column gap-1">
                        @php $data_active=false; @endphp
                        @foreach($item->models as $key=>$model)
                            @if($model->photo)
                                <img data-id="0" alt="small-img"
                                     class="{{$data_active?'':'active'}} model_id_{{$model->id}}"
                                     src="{{url_big($model->photo->path)}}">
                                @php $data_active=true; @endphp
                            @endif
                            @if(count($model->gallery)>0)
                                @foreach($model->gallery as $key_1=> $gall)
                                    <img data-id="{{$key_1+1}}" alt="small-img"
                                         class="{{$data_active?'':'active'}} model_id_{{$model->id}}"
                                         src="{{url_big($gall->path)}}">
                                    @php $data_active=true; @endphp
                                @endforeach
                            @endif
                        @endforeach
                    </div>
                    <div class="flex-grow-1 img-magnifier-container">
                        @php $data_img=false; @endphp
                        @foreach($item->models as $key=>$model_s)
                            @if($model_s->photo)
                                <img alt="big-img" href="{{url_big($model_s->photo->path)}}"
                                     data-fancybox="gallery{{$item->id}}" id="{{$data_img?'':'big-img'}}"
                                     class="img-fluid w-100 {{$data_img?'d-none':''}}"
                                     src="{{url_big($model_s->photo->path)}}">
                                @php $data_img=true; @endphp
                            @endif
                            @if(count($model_s->gallery) > 0)
                                @foreach($model_s->gallery as $gall_s)
                                    <img alt="big-img" href="{{url_big($gall_s->path)}}"
                                         data-fancybox="gallery{{$item->id}}" id="{{$data_img?'':'big-img'}}"
                                         class="img-fluid w-100 {{$data_img?'d-none':''}}"
                                         src="{{url_big($gall_s->path)}}">
                                    @php $data_img=true; @endphp
                                @endforeach
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <form action="{{route('front.cart.add',$item->id)}}" method="post">
                    @csrf
                    <div class="border-b-dash pb-5">
                        <p class="fw-bold">{{read_lang($item,'title')}}</p>
                        <div class="d-flex align-items-center gap-2 mt-2">
                            @if($item->category)
                                <span class="text-secondary">{{read_lang($item->category,'name')}}</span>
                            @endif
                        </div>
                        @if($item->default)
                            <div class="d-flex align-items-center gap-2 mt-3" id="price_model">
                                @if((int)read_lang($item->default,'price_vip') > 0 && (int)read_lang($item->default,'price_vip') < (int)read_lang($item->default,'price'))
                                    <p class="text-danger font-bold h4">{{number_format(price_convert(read_lang($item->default,'price_vip')))}} {{price_type()}}</p>
                                    <p class="text-muted text-decoration-line-through">{{number_format(price_convert(read_lang($item->default,'price')))}} {{price_type()}}</p>
                                    <p class="text-white bg-dark px-2">{{price_off_product($item)}}</p>
                                @else
                                    <p class="text-danger font-bold h4">{{number_format(price_convert(read_lang($item->default,'price')))}} {{price_type()}}</p>
                                @endif
                            </div>
                        @endif
                        {{--                        <p class="text-muted mt-4">This item limit 2 purchases.</p>--}}
                    </div>
                    <div class="mt-4">
                        @if(count($item->models))
                            <div class="d-flex align-items-center gap-2">
                                <p class="font-bold">Models</p>
                                <select name="model_id" id="model_select"
                                        data-url="{{route('front.product.ajax.model')}}"
                                        class="border-0 px-2 cursor bg-gray rounded-pill">
                                    @foreach($item->models as $model)
                                        <option value="{{$model->id}}">{{read_lang($model,'type')}} {{read_lang($model,'type_val')}}</option>
                                    @endforeach
                                </select>
                            </div>
                            @if($item->models[0]->sizes)
                                <div class="d-flex align-items-center flex-wrap mt-3 gap-2" id="size_select">
                                    @if(count($item->models[0]->size_inventory))
                                        @foreach($item->models[0]->size_inventory as $key => $size)
                                            <div
                                                    class="d-flex position-relative {{$key==0?'active':''}} size align-items-center justify-content-center rounded-pill border-dash w-80 py-1 cursor">
                                                <input type="radio" name="size_id"
                                                       {{$key==0?'checked':''}} value="{{$size->id}}"
                                                       class="position-absolute top-0 end-0 w-100 h-100">
                                                {{$size->title}}
                                            </div>
                                        @endforeach
                                        <div class="d-flex align-items-center gap-2  mt-3" id="num_type_product">
                                            <p class="font-bold">Num</p>
                                            <input type="number" class="num_type" min="1" value="1" name="num">
                                        </div>
                                    @else
                                        <p class="text-danger mt-2 h5 fw-bold">Not Inventory</p>
                                    @endif
                                </div>
                            @endif
                        @endif

                        {{--                        <p class="text-danger mt-2">Hurry! Almost Sold Out..</p>--}}
                        <a class="d-flex align-items-center gap-2 mt-3" data-bs-toggle="modal"
                           data-bs-target="#sizing-modal">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                 class="bi bi-rulers" viewBox="0 0 16 16">
                                <path
                                        d="M1 0a1 1 0 0 0-1 1v14a1 1 0 0 0 1 1h5v-1H2v-1h4v-1H4v-1h2v-1H2v-1h4V9H4V8h2V7H2V6h4V2h1v4h1V4h1v2h1V2h1v4h1V4h1v2h1V2h1v4h1V1a1 1 0 0 0-1-1H1z"/>
                            </svg>
                            Size Guide
                        </a>


                        <p class="mt-3 text-muted">Not your size? <a href="{{route('front.contact')}}"
                                                                     class="text-primary">Tell me your size</a></p>
                    </div>
                    <input value="{{count($item->models) && count($item->models[0]->size_inventory) ? 'Add To Cart' : 'Not Inventory'}}"
                           id="btn_form" type="submit"
                           {{count($item->models) && count($item->models[0]->size_inventory) ? '' : 'disabled'}}
                           class="{{count($item->models) && count($item->models[0]->size_inventory) ? 'bg-dark' : 'bg-danger'}} text-white text-center font-bold py-3 cursor w-100 mt-4 mb-1">

                    <a href="{{route('front.product.favorite',$item->id)}}"
                       class="btn btn-primary text-center font-bold py-3 cursor w-100 mt-4 mb-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 256 256">
                            <path fill="#ffffff"
                                  d="M178 34c-21 0-39.26 9.47-50 25.34C117.26 43.47 99 34 78 34a60.07 60.07 0 0 0-60 60c0 29.2 18.2 59.59 54.1 90.31a334.68 334.68 0 0 0 53.06 37a6 6 0 0 0 5.68 0a334.68 334.68 0 0 0 53.06-37C219.8 153.59 238 123.2 238 94a60.07 60.07 0 0 0-60-60Zm-50 175.11C111.59 199.64 30 149.72 30 94a48.05 48.05 0 0 1 48-48c20.28 0 37.31 10.83 44.45 28.27a6 6 0 0 0 11.1 0C140.69 56.83 157.72 46 178 46a48.05 48.05 0 0 1 48 48c0 55.72-81.59 105.64-98 115.11Z"/>
                        </svg>
                        Add To Favorite
                    </a>

                </form>
            </div>
            <div class="col-12 bottom">
                <div class="mt-5">
                    <div class="mt-4">
                        <div class="d-flex cursor filter-btn fw-bold align-items-center justify-content-between">
                            <span class="h5 font-bold">Description</span>
                            <span class="h4 plus">+</span>
                            <span class="h4 mines active">-</span>
                        </div>
                        <div class="filter-content mt-3 active">
                            @if(!blank(read_lang($item,'short_text')))
                                <p>
                                    {{read_lang($item,'short_text')}}
                                </p>
                            @endif
                            {!! read_lang($item,'text') !!}
                        </div>
                    </div>
                    @if(count(array_chunk(json_decode($item->feature) , 3)))
                        <div class="mt-3">
                            <div class="d-flex cursor filter-btn fw-bold align-items-center justify-content-between">
                                <span class="h5 font-bold">Feature</span>
                                <span class="h4 plus">+</span>
                                <span class="h4 mines active">-</span>
                            </div>
                            <div class="filter-content mt-3 active">
                                @foreach(array_chunk(json_decode($item->feature) , 3) as $feature)
                                    @if(isset($feature[2]) && $feature[2] == app()->getLocale())
                                        <p><span class="title">{{$feature[0]}} : </span> <span
                                                    class="value">{{$feature[1]}}</span></p>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        <!-- comments -->
        @include('front.product.includes.comment_single')
    </section>

    <!-- Modal -->
    <div class="modal fade" id="sizing-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal_js_big modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Size Guidee</h5>
                    <a href="javascript:void(0);" class="btn btn-primary modal_js_big_click" title="Zoom IN"
                       aria-label="Zoom IN">Zoom IN</a>
                    <a href="javascript:void(0);" class="btn btn-primary modal_js_small_click d-none" title="Zoom Out"
                       aria-label="Zoom Out">Zoom Out</a>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    @if($item->size_cat && count($item->size_cat->sizes) == count($item->product_size))
                        <div class="container-fluid size_product_tbl min-w-750" id="myElement">
                            <div class="row">
                                <div class="{{$item->size_cat->photo || is_file($item->size_cat_pic)?'col-lg-9 col-8':'col-12'}}">
                                    @foreach($item->size_cat->sizes as $sizee)
                                        @if(!blank($sizee->text))
                                            <p class="rightpersiantext"><strong>{{$sizee->sort}}
                                                    :</strong> {{read_lang($sizee,'text')}}</p>
                                        @endif
                                    @endforeach
                                    <table class="table table-default mt-4">
                                        <thead>
                                        <th>
                                            <p class="centerpersiantext">Size</p>
                                        </th>
                                        @foreach($item->size_cat->sizes_invent($item) as $size_name)
                                            <th>
                                                <p class="centerpersiantext">{{$size_name}}</p>
                                            </th>
                                        @endforeach
                                        </thead>
                                        <tbody>
                                        @foreach($item->size_cat->sizes as $sizee)
                                            <tr>
                                                <td>
                                                    <p class="centerpersiantext">{{read_lang($sizee,'title')}}</p>
                                                </td>
                                                @foreach($sizee->sizes_invent($item->product_size->where('size_id',$sizee->id)->first()) as $sizzz)
                                                    <td>
                                                        <p class="centerpersiantext">{{$sizzz}}</p>
                                                    </td>
                                                @endforeach
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                    @if($item->size_cat->text)
                                        <div class="col-12 text-bg-default">
                                            {!! read_lang($item->size_cat,'text') !!}
                                        </div>
                                    @endif
                                </div>
                                @if($item->size_cat->photo || is_file($item->size_cat_pic))
                                    <div class="col-lg-3 col-4">
                                        @if($item->size_cat->photo)
                                            <div class="col-12">
                                                <img src="{{url_big($item->size_cat->photo->path)}}"
                                                     class="img_model_size_tbl" alt="cat_methode">
                                            </div>
                                        @endif
                                        @if($item->size_cat_pic)
                                            <div class="col-12 mt-3">
                                                <img src="{{url_big($item->size_cat_pic)}}" class="img_model_size_tbl"
                                                     alt="product_methode">
                                            </div>
                                        @endif
                                    </div>
                                @endif
                            </div>
                        </div>
                    @else
                        {!! read_lang($item,'sizing','fa') !!}
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- related products -->
    @if(count($items))
        <section id="related-products" class="container my-5 left">
            <h4 class="font-bold mb-4">Related Products</h4>
            <div class="row g-4">
                @foreach($items as $product)
                    @if(count($product->models))
                        <div class="col-lg-3 col-md-4 col-sm-6">
                            @include('front.product.includes.card1',['item'=>$product])
                        </div>
                    @endif
                @endforeach
            </div>
            {{--        <a class="bg-dark text-white fw-bold px-3 py-1 d-table mx-auto mt-5">View More</a>--}}
        </section>
    @endif
@endsection