<?php
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Front\HomeController;
use App\Http\Controllers\Front\BasketController;

//home
Route::get('/', [HomeController::class,'index'])->name('index');
Route::post('/price-type-set', [HomeController::class,'price_type_set'])->name('price.type.set');

//about us
Route::get('/about', [HomeController::class,'about'])->name('about');

//contact us
Route::get('/contact', [HomeController::class,'contact'])->name('contact');
Route::post('contact/post', [HomeController::class,'contact_post'])->name('contact.post');

//blog
Route::get('/blog', [HomeController::class,'blog_index'])->name('blog.index');
Route::get('/blog/single/{slug}/{id}', [HomeController::class,'blog_show'])->name('blog.show');

//product
Route::get('/products/{id?}/{slug?}', [HomeController::class,'product_index'])->name('product.index');
Route::get('/products-ajax/{id?}/{slug?}', [HomeController::class,'product_index_ajax'])->name('product.index.ajax');
Route::get('/product/single/{id}/{slug}', [HomeController::class,'product_show'])->name('product.show');
Route::get('/product/single/comment/{id}/{start}', [HomeController::class,'product_comment_ajax'])->name('product.show.comment.ajax');
Route::get('/product/ajax/model', [HomeController::class,'product_ajax_model'])->name('product.ajax.model');
Route::get('/product/compare', [HomeController::class,'product_compare'])->name('product.compare');
Route::post('/product/comment/{id}', [HomeController::class,'product_comment'])->name('product.comment');
Route::get('/product/favorite/{id}', [HomeController::class,'product_favorite'])->name('product.favorite');

//how order
Route::get('/how-order', [HomeController::class,'how_order'])->name('how.order');

//return policy
Route::get('/return-policy', [HomeController::class,'return'])->name('return');

//profile
Route::get('/profile', [HomeController::class,'profile_index'])->name('profile.index');


//shopping cart
Route::post('/cart/add/{id}', [BasketController::class,'cart_add'])->name('cart.add');
Route::post('/cart/update/{m_id}/{s_id?}', [BasketController::class,'cart_update'])->name('cart.update');
Route::get('/cart/delete/{m_id}/{s_id?}', [BasketController::class,'cart_delete'])->name('cart.delete');
Route::get('/cart/level/1', [BasketController::class,'level_1'])->name('cart.index');
Route::get('/cart/end', [BasketController::class,'cart_end'])->name('cart.end');
Route::get('/cart/level/2', [BasketController::class,'level_2'])->name('cart.deliver.address');


//register
Route::post('/sign-up', [HomeController::class,'register'])->name('register.post');
Route::get('/sign-up-confirm/{id}/{code}', [HomeController::class,'register_confirm'])->name('register.confirm');
//reset password
Route::get('/reset-password', [HomeController::class,'reset_password'])->name('reset.password');
Route::post('/reset-password-post', [HomeController::class,'reset_password_post'])->name('reset.password.post');
Route::get('/reset-password-confirm/{id}/{code}', [HomeController::class,'reset_password_confirm'])->name('reset.password.confirm');
Route::post('/reset-password-new-set/{id}', [HomeController::class,'reset_password_new_set'])->name('reset.password.new.set');
