<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use App\Mail\Mail;
use Carbon\Carbon;

use App\Models\User;
use App\Models\Category;
use App\Models\Product;
use App\Models\Modale;
use App\Models\ModelSize;
use App\Models\Country;
use App\Models\Photo;
use App\Models\Factor;
use App\Models\Basket;

class BasketController extends Controller
{
    public function getBasket()
    {
        $basket_show = [];
        $model_id = [];
        $total_price = 0;
        $all_price = 0;
        $order_code = 0;
        if (!Cookie::has('order_code')) {
            $order_code = order_code();
            Cookie::queue('order_code', $order_code, 60);
        } else {
            $order_code = Cookie::get('order_code');
        }
        if (Cookie::has('basket')) {
            $basket = json_decode(Cookie::get('basket'));
            foreach ($basket as $val) {
                $status = 'status_' . app()->getLocale();
                $model = Modale::where('id', $val->model)->with('product')->where($status, 1)->first();
                $size = null;
                if (!blank($val->size_id)) {
                    $size = ModelSize::find($val->size_id);
                }
                if ($model) {
                    $arr_p = true;
                    if ($size) {
                        if ($size->inventory < $val->number) {
                            $arr_p = false;
                        }
                    } else {
                        if ($model->inventory < $val->number) {
                            $arr_p = false;
                        }
                    }
                    if ($arr_p) {
                        array_push($basket_show, ['model' => $model, 'number' => $val->number, 'order_code' => (int)$order_code, 'size' => $size]);
                    }
                }
            }

            if (count($basket_show) > 0) {
                foreach ($basket_show as $value) {
                    array_push($model_id, $value['model']->id);

                        if (read_lang($value['model'],'price_vip') > 0) {
                            if (auth()->check()) {
                                if (auth()->user()->hasRole('Colleague') && $value['model']->price_coll > 0) {
                                    $total_price += read_lang($value['model'],'price_coll') * (int)$value['number'];
                                    $all_price += read_lang($value['model'],'price_coll') * (int)$value['number'];
                                } else {
                                    $total_price += read_lang($value['model'],'price_vip') * (int)$value['number'];
                                    $all_price += read_lang($value['model'],'price') * (int)$value['number'];
                                }
                            } else {
                                $total_price += read_lang($value['model'],'price_vip') * (int)$value['number'];
                                $all_price += read_lang($value['model'],'price') * (int)$value['number'];
                            }
                        }
                        else {
                            if (auth()->check()) {
                                if (auth()->user()->hasRole('Colleague') && $value['model']->price_coll > 0) {
                                    $total_price += read_lang($value['model'],'price_coll') * (int)$value['number'];
                                    $all_price += read_lang($value['model'],'price_coll') * (int)$value['number'];
                                } else {
                                    $total_price += read_lang($value['model'],'price') * (int)$value['number'];
                                    $all_price += read_lang($value['model'],'price') * (int)$value['number'];
                                }
                            } else {
                                $total_price += read_lang($value['model'],'price') * (int)$value['number'];
                                $all_price += read_lang($value['model'],'price') * (int)$value['number'];
                            }
                        }

                }
            }
        }
        return [$basket_show, $total_price, $all_price, $model_id];
    }
    public function cart_add($id, Request $request)
    {
        //product check
        $product = Product::where('id', $id)->whereHas('lang_active')->first();
        $size = null;
        if (!$product)
            return redirect()->back()->with('err_message', 'Not Found Product');

        //model check
        if (!isset($request->model_id))
            return redirect()->back()->with('err_message', 'Please The Selected Model');

        $status = 'status_' . app()->getLocale();
        $model = Modale::where('id', $request->model_id)->where('product_id', $product->id)->where($status, 1)->first();
        if (!$model)
            return redirect()->back()->with('err_message', 'Not Found Model Product');

        //size check
        if ($model->sizes) {
            if (!isset($request->size_id))
                return redirect()->back()->with('err_message', 'Please The Selected Size');

            $size = ModelSize::where('id', $request->size_id)->where('model_id', $model->id)->first();
            if (!$size)
                return redirect()->back()->with('err_message', 'Not Found Size Product');
            else {
                if ($size->inventory <= 0)
                    return redirect()->back()->with('err_message', 'This Size of The Product is Unavailable');

                //num check
                if (!isset($request->num))
                    return redirect()->back()->with('err_message', 'Specify Your Product Number');

                if ($size->inventory < (int)$request->num)
                    return redirect()->back()->with('err_message', 'The Stock of The Selected Size is Less Than The Quantity You Selected');
            }
        } else {
            if ($model->inventory <= 0)
                return redirect()->back()->with('err_message', 'This Model of The Product is Unavailable');

            //num check
            if (!isset($request->num))
                return redirect()->back()->with('err_message', 'Specify Your Product Number');

            if ($model->inventory < (int)$request->num)
                return redirect()->back()->with('err_message', 'The Stock of The Selected Model is Less Than The Quantity You Selected');
        }

        $basket = [];
        $order_code = 0;
        $basket_num = (int)$request->num;
        try {
            $model_id=$model->id;
            $size_id=$size?$size->id:null;
            if (!Cookie::has('order_code')) {
                $order_code = order_code();
                Cookie::queue('order_code', $order_code, 60);
            } else {
                $order_code = Cookie::get('order_code');
            }
            if (Cookie::has('basket')) {
                $basket = Cookie::get('basket');
                $basket = (array)json_decode($basket);
                $exist = false;
                foreach ($basket as $value) {
                    //check in basket
                    if ($value->model == $model_id && $value->size_id == $size_id)
                        $exist = true;
                }

                if (!$exist) {
                    array_push($basket, ['model' => $model_id, 'number' => $basket_num, 'order_code' => (int)$order_code, 'size_id' => $size_id]);
                    Cookie::queue('basket', json_encode($basket), 60);
                    return redirect()->back()->with('flash_message', 'Success Added Cart');
                } else {
                    return redirect()->back()->with('err_message', 'The Product is Already in Your Cart');
                }
            }

            array_push($basket, ['model' => $model_id, 'number' => $basket_num, 'order_code' => (int)$order_code, 'size_id' => $size_id]);
            Cookie::queue('order_code', $order_code, 60);
            Cookie::queue('basket', json_encode($basket), 60);

            return redirect()->back()->with('flash_message', 'Success Added Cart');
        } catch (Exception $e) {
            return redirect()->back()->with('err_message', 'An Error Occurred, Please Try Again');
        }
    }

    public function level_1()
    {
        if (Auth::check()) {
            if (auth()->user()->mobile_status == 'pending') {
                return redirect()->back()->with('err_message', 'لطفا ثبت نام خود را تکمیل کنید');
            }
        }
        $getBasketArray = $this->getBasket();

        $baskets = $getBasketArray[0];
        $total_price = $getBasketArray[1];
        $all_price = $getBasketArray[2];
        $discount_price = $all_price - $total_price;

        return view('front.cart.level_1',compact('baskets','all_price','total_price','discount_price'));
    }

    public function level_2()
    {
        return view('front.cart.deliver-address');
    }

    public function cart_delete($id, $size_id = null)
    {
        if ($size_id == 0) {
            $size_id = null;
        }
        try {
            if (Cookie::has('basket')) {
                $basket = (array)json_decode(Cookie::get('basket'));
                $remove = false;
                foreach ($basket as $key => $value) {
                    if ($value->model == $id && $value->size_id == $size_id) {
                        if (count($basket) <= 1) {
                            $basket = [];
                        } elseif (gettype($basket) == 'object') {
                            unset($basket->$key);
                        } else {
                            unset($basket[$key]);
                        }
                        $remove = true;
                    }
                }
                if ($remove) {
                    Cookie::queue('basket', json_encode($basket), 60);
                    return redirect()->back()->with('flash_message', 'Success Delete From Cart');
                } else {
                    return redirect()->back()->with('err_message', 'Not Found');
                }
            } else {
                return redirect()->back()->with('err_message', 'Cart Empty');
            }
        } catch (Exception $e) {
            return redirect()->back()->with('err_message', 'An Error Occurred, Please Try Again');
        }
    }

    public function cart_update($id, $size_id = null , Request $request)
    {
        $num=$request->num;
        if ($num <= 0) {
            return redirect()->back()->with('err_message', 'An Error Occurred, Please Try Again');
        }
        if ($size_id == 0) {
            $size_id = null;
        }
        try {
            $basket = [];
            $baskets = (array)json_decode(Cookie::get('basket'));
            $num_true = true;
            $order_code = 0;
            if (!Cookie::has('order_code')) {
                $order_code = order_code();
                Cookie::queue('order_code', $order_code, 60);
            } else {
                $order_code = Cookie::get('order_code');
            }
            $size = null;
            if (!is_null($size_id)) {
                $size = ModelSize::find($size_id);
            }
            foreach ($baskets as $key => $value) {
                $model = Modale::where('id', $value->model)->where('status', 1)->first();
                if (!is_null($model)) {
                    if ((int)$id == (int)$model->id && (int)$value->size_id == (int)$size_id) {
                        if ($model->inventory >= $num && is_null($size) && count($model->sizes) <= 0) {
                            array_push($basket, ['model' => $model->id, 'number' => $num, 'order_code' => (int)$order_code, 'size_id' => $size_id]);
                        } elseif (!is_null($size) && count($model->sizes)) {
                            if ($size->inventory >= $num) {
                                array_push($basket, ['model' => $model->id, 'number' => $num, 'order_code' => (int)$order_code, 'size_id' => $size_id]);
                            } else {
                                array_push($basket, ['model' => $model->id, 'number' => $value->number, 'order_code' => (int)$order_code, 'size_id' => $size_id]);
                                $num_true = false;
                            }
                        } else {
                            array_push($basket, ['model' => $model->id, 'number' => $value->number, 'order_code' => (int)$order_code, 'size_id' => $size_id]);
                            $num_true = false;
                        }
                    } else {
                        array_push($basket, ['model' => $model->id, 'number' => $value->number, 'order_code' => (int)$order_code, 'size_id' => $value->size_id]);
                    }
                }
            }
            if (!$num_true) {
                return redirect()->back()->with('err_message', 'The Stock of The Selected Model is Less Than The Quantity You Selected');
            }
            Cookie::queue('basket', json_encode($basket), 60);
            return redirect()->back()->with('flash_message', 'Success Updated Cart');
        } catch (Exception $e) {
            return redirect()->back()->with('err_message', 'An Error Occurred, Please Try Again');
        }
    }
    public function cart_end()
    {

        $getBasketArray = $this->getBasket();

        $baskets = $getBasketArray[0];
        $total_price = $getBasketArray[1];
        $all_price = $getBasketArray[2];
        $discount_price = $all_price - $total_price;
       try{
           $user=auth()->user();
           $orderCode = real_order_code();
           $old_factor = Factor::where('user_id', $user->id)->where('status', 0)->get();
           if (count($old_factor) > 0) {
               foreach ($old_factor as $value) {
                   factor_return_id_10($value);
               }
           }
           $factor=new Factor();
           $factor->order_code = $orderCode;
           $factor->user_id = $user->id;
           $factor->fname = $user->first_name;
           $factor->lname = $user->last_name;
           $factor->state = $user->state;
           $factor->city = $user->city;
           $factor->address = $user->address;
           $factor->postcode = $user->postcode;
           $factor->mobile = $user->mobile;
           $factor->other = 0;
           $factor->email = $user->email;
           $factor->payment_way = 'gateway';
           $factor->send_type = 'output';
           $factor->reserv = 'pending';
           $factor->total_price = intval($total_price) + intval(10);
           $factor->post_price = 10;
           $factor->pay_mode = 'output';
           $factor->lang = lang();
           $factor->save();

           if ($factor->total_price <= 0) {
               return redirect()->back()->with('err_message', 'An Error Occurred, Please Try Again (total=0)');
           }

           //basket add tbl
           foreach ($baskets as $basket) {
               $model = Modale::find($basket['model']->id);
               $size_id = $basket['size'] ? $basket['size']->id : null;
               if (is_null($model)) {
                   return redirect()->back()->with('err_message', 'No products were found in your shopping cart. Please delete your shopping cart and register again');
               }
               $size = $basket['size'];
               if (!is_null($size)) {
                   if ($size->inventory < $basket['number']) {
                       return redirect()->back()->with('err_message', 'Inventory ' . read_lang($model->product,'title') . ' _ ' . read_lang($model->product,'type') . ':' . read_lang($model->product,'type_val') . ' It is less than the number you selected');
                   }
               } else if ($model->inventory < $basket['number'] || $model->inventory == 0) {
                   return redirect()->back()->with('err_message', 'Inventory ' . read_lang($model->product,'title') . ' _ ' . read_lang($model->product,'type') . ':' . read_lang($model->product,'type_val') . ' It is less than the number you selected');
               }
//            try {
               $price = 0;

                   if ($model->price_vip > 0) {
                       $price = read_lang($model->product,'price_vip');
                   } else {
                       $price = read_lang($model->product,'price');
                   }
                   if ($user->hasRole('Colleague') && $model->price_coll > 0) {
                       $price = read_lang($model->product,'price_coll');
                   }



               //old basket check
               $old_basket = Basket::where('factor_id', $factor->id)->where('user_id', $user->id)->where('product_id', $model->product_id)->where('model_id', $model->id)->where('size_id', $size_id)->where('status', 0)->first();
               if ($old_basket) {
                   if($old_basket->get_pay_status == 'start_pay')
                   {
                       if ($old_basket->modale) {
                           if ($old_basket->size) {
                               $old_basket->size->inventory+=$old_basket->num;
                               $old_basket->size->update();
                           }else{
                               $old_basket->modale->inventory += $old_basket->num;
                               $old_basket->modale->update();
                           }
                       }

                       $old_basket->get_pay_status = 'return_invent';
                       $old_basket->update();
                   }
                   $old_basket->delete();
               }

               $row = new Basket();
               $row->user_id = $user->id;
               $row->product_id = $model->product_id;
               $row->model_id = $model->id;
               $row->price = $price;
               $row->size_id = $size_id;
               $row->size_title = $size ? $size->title : '';
               $row->num = (int)$basket['number'];
               $row->order_code = $orderCode;
               $row->factor_id = $factor->id;
               $row->save();
           }




           if (Cookie::has('basket')) {
               Cookie::queue(Cookie::forget('basket'));
           }
           if (Cookie::has('order_code')) {
               Cookie::queue(Cookie::forget('order_code'));
           }
            return redirect()->route('front.index')->with('flash_message', 'Success End Cart');
        } catch (Exception $e) {
            return redirect()->back()->with('err_message', 'An Error Occurred, Please Try Again');
        }
    }

}
