<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Mail\Mail;
use Carbon\Carbon;

use App\Models\User;
use App\Models\Slider;
use App\Models\Banner;
use App\Models\About;
use App\Models\Contact;
use App\Models\Info_Contact;
use App\Models\Article;
use App\Models\Category;
use App\Models\Product;
use App\Models\ProductChoking;
use App\Models\Comment;
use App\Models\PriceUnit;
use App\Models\Modale;
use App\Models\ModelSize;
use App\Models\ProductVip;
use App\Models\Country;
use App\Models\Word;
use App\Models\Photo;
use App\Models\Favorite;

class HomeController extends Controller
{
    public function index()
    {
        $sliders = Slider::whereHas('lang_active')->whereHas('photo')->orderBy('sort')->get();
        $product_cats=Category::where('status_home','active')->whereHas('lang_active')->whereHas('photo')->take(6)->get();
        $banners = Banner::whereHas('lang_active')->whereHas('photo')->orderBy('sort')->get();
        $products_new1 = Product::whereHas('lang_active')->whereHas('models_active')->where('new_set', 1)->where('home_page', 1)->orderByDesc('id')->take(10)->get();
        $products_new2 = Product::whereHas('lang_active')->whereHas('models_active')->where('home_page', 1)->orderByDesc('id')->take(5)->get();
        $products_new = $products_new1->merge($products_new2);
        if(count($products_new)<=0)
        {
            $products_new = Product::whereHas('lang_active')->whereHas('models_active')->orderByDesc('id')->take(10)->get();
        }
        $slider_vip = ProductVip::find(1);
        $status='status_'.app()->getLocale();
        $product_slider_vip = Modale::where('vip_home', 'active')->where('vip_page', 'active')->where($status, 1)->whereHas('size_inventory')->whereHas('product')->with(['product','photo'])->orderBy('sort', 'asc')->take(10)->get();
        $trends=Photo::where('pictures_type','App\\Models\\ProductChoking')->where('status_trend','active')->where('lang','en')->orderByDesc('id')->take(15)->get();
        return view('front.index', compact('sliders','product_cats', 'banners','products_new','slider_vip','product_slider_vip','trends'));
    }

    public function price_type_set(Request $request)
    {
        try {
            price_type_set($request->price_type_id);
            return redirect()->back()->with('flash_message', 'Success Change Price Type');
        } catch (\Exception $e) {
            return redirect()->back()->with('err_message', 'An Error Occurred, Please Try Again');
        }
    }

    public function about()
    {
        $item = About::firstOrFail();
        return view('front.about', compact('item'));
    }

    public function contact()
    {
        $item1 = Info_Contact::find(3);
        $socials = Info_Contact::find(4);
        return view('front.contact', compact('item1', 'socials'));
    }

    public function contact_post(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|max:240',
            'email' => 'required|email',
            'descriptions' => 'required',
            'captcha' => 'required',
        ]);
        if ($request->captcha != session('captcha_code')) {
            return redirect()->back()->withInput()->with('err_message', 'Enter The Correct Security Code');
        }
        try {
            $item = Contact::create([
                'name' => $request->name,
                'email' => $request->email,
                'phone' => $request->phone,
                'descriptions' => $request->descriptions,
                'lang' => lang(),
            ]);
            $item->save();
            return redirect()->back()->with('flash_message', 'Success Submit Message');
        } catch (\Exception $e) {
            return redirect()->back()->with('err_message', 'An Error Occurred, Please Try Again');
        }
    }

    ///blog
    public function blog_index()
    {
        $items = Article::whereHas('lang_active')->orderByDesc('id')->paginate(24);
        return view('front.blog.index', compact('items'));
    }

    public function blog_show($slug, $id)
    {
        $item = Article::whereHas('lang_active')->where('id', $id)->firstOrFail();
        if ($slug != read_lang($item, 'slug')) {
            abort(404);
        }
        $lasts = Article::whereHas('lang_active')->orderByDesc('id')->paginate(6);
        return view('front.blog.single', compact('item', 'lasts'));
    }

    ///product
    public function product_index(Request $request,$id=null,$slug=null)
    {
        $cats_filter = $request->cats_filter ? explode(',',$request->cats_filter) : [];
        $sort_filter = $request->sort_filter ? $request->sort_filter : 'new';

        if (blank($id)) {
            $category = null;
            $cats = Category::where('parent_id', null)->whereHas('lang_active')->get();
            $cats_id = [];
            $items_other = [];
        } else {
            $category = Category::where('id',$id)->whereHas('lang_active')->firstOrFail();
            if($slug != read_lang($category,'slug'))
            {
                abort(404);
            }
            $cats = Category::where('parent_id', $category->id)->whereHas('lang_active')->get();
            $cats_id = cat_subsets_ids([$category->id]);
            $items_other = Product::whereHas('lang_active')->whereHas('models_inventory')->whereHas('models_active')->where('other_category', 'LIKE', '%"' . $category->id . '"%');
            if (count($cats_filter)) {
                $cat_id_filter = cat_subsets_ids($cats_filter);
                $items_other = $items_other->whereIN('category_id', $cat_id_filter);
            }
            //sort
            switch ($sort_filter) {
                case 'new':
                    $items_other = $items_other->orderBy('created_at', 'desc');
                    break;
                case 'seen':
                    $items_other = $items_other->orderBy('view', 'desc');
                    break;
            }
            $items_other = $items_other->get();
        }

        $items = Product::whereHas('lang_active')->whereHas('models_inventory')->whereHas('models_active');
        if (count($cats_id)) {
            $items = $items->whereIN('category_id', $cats_id);
        }
        if (count($cats_filter)) {
            $cat_id_filter = cat_subsets_ids($cats_filter);
            $items = $items->whereIN('category_id', $cat_id_filter);
        }
        //sort
        switch ($sort_filter) {
            case 'new':
                $items = $items->orderBy('created_at', 'desc');
                break;
            case 'seen':
                $items = $items->orderBy('view', 'desc');
                break;
        }
        $items = $items->orderByDesc('id')->paginate(24);
        if(count($items_other))
            $items = $items->merge($items_other);

        return view('front.product.index', compact('items','id','slug','cats','category','sort_filter','cats_filter'));
    }
    public function product_index_ajax(Request $request,$id=null,$slug=null)
    {
        $cats_filter = $request->cats_filter ? explode(',',$request->cats_filter) : [];
        $sort_filter = $request->sort_filter ? $request->sort_filter : 'new';

        if ($slug == null && $id != null) {
            abort(404);
        }
        if (blank($id)) {
            $category = null;
            $cats = Category::where('parent_id', null)->whereHas('lang_active')->get();
            $cats_id = [];
            $items_other = [];
        } else {
            $category = Category::where('id',$id)->whereHas('lang_active')->firstOrFail();
            $cats = Category::where('parent_id', $category->id)->whereHas('lang_active')->get();
            $cats_id = cat_subsets_ids([$category->id]);
            $items_other = Product::whereHas('lang_active')->whereHas('models_inventory')->whereHas('models_active')->where('other_category', 'LIKE', '%"' . $category->id . '"%');
            if (count($cats_filter)) {
                $cat_id_filter = cat_subsets_ids($cats_filter);
                $items_other = $items_other->whereIN('category_id', $cat_id_filter);
            }
            //sort
            switch ($sort_filter) {
                case 'new':
                    $items_other = $items_other->orderBy('created_at', 'desc');
                    break;
                case 'seen':
                    $items_other = $items_other->orderBy('view', 'desc');
                    break;
            }
            $items_other = $items_other->get();
        }
        $items = Product::whereHas('lang_active')->whereHas('models_active');
        if (count($cats_id)) {
            $items = $items->whereIN('category_id', $cats_id);
        }
        if (count($cats_filter)) {
            $cat_id_filter = cat_subsets_ids($cats_filter);
            $items = $items->whereIN('category_id', $cat_id_filter);
        }
        //sort
        switch ($sort_filter) {
            case 'new':
                $items = $items->orderBy('created_at', 'desc');
                break;
            case 'seen':
                $items = $items->orderBy('view', 'desc');
                break;
        }
        $items = $items->orderByDesc('id')->paginate(24);
        if(count($items_other))
            $items = $items->merge($items_other);

        return view('front.product.includes.index', compact('items','id','slug','cats','category','sort_filter','cats_filter'))->render();
    }


    public function product_show($id,$slug)
    {
        $item=Product::where('id',$id)->whereHas('lang_active')->whereHas('models_active')->firstOrFail();
        if($slug != read_lang($item,'slug'))
        {
            abort(404);
        }
        // product detail
        $items = Product::whereHas('lang_active')->where('category_id', $item->category_id)->where('id', '!=', $item->id)->whereHas('models_inventory')->whereHas('models_active')->orderByDesc('id')->take(10)->get();
        //product set
        $codes_set = explode(',', $item->codes_set);
        $items_set = Product::whereHas('lang_active')->where('id', '!=', $item->id)->whereIN('code', $codes_set)->whereHas('models_inventory')->whereHas('models_active')->orderByDesc('id')->take(10)->get();
        $items = $items_set->merge($items);

        //comment product
        $comments = Comment::where('status', 1)->where('lang',lang())->where('product_id', $item->id)->where('reply_id', 0)->orderByDesc('created_at')->take(5)->get();
        $comments_all = Comment::where('status', 1)->where('lang',lang())->where('product_id', $item->id)->where('reply_id', 0)->orderByDesc('created_at')->get();
        $product_chokings = ProductChoking::where('status', 'active')->where('lang',lang())->where('product_id', $item->id)->whereHas('photos')->orderByDesc('id')->get();

        $big_choking = Comment::where('status', 1)->where('lang',lang())->where('product_id', $item->id)->where('size_checked', 'big')->count();
        $normal_choking = Comment::where('status', 1)->where('lang',lang())->where('product_id', $item->id)->where('size_checked', 'normal')->count();
        $small_choking = Comment::where('status', 1)->where('lang',lang())->where('product_id', $item->id)->where('size_checked', 'small')->count();
        $all_choking = Comment::where('status', 1)->where('lang',lang())->where('product_id', $item->id)->count();

        return view('front.product.single',compact('item','items','comments','product_chokings','big_choking','normal_choking','small_choking','all_choking','comments_all'));
    }

    public function product_comment_ajax($id,$start)
    {
        //comment product
        $comments = Comment::where('status', 1)->where('lang',lang())->where('product_id', $id)->where('reply_id', 0)->orderByDesc('created_at')->skip($start)->take(5)->get();
        $comments_all = Comment::where('status', 1)->where('lang',lang())->where('product_id', $id)->where('reply_id', 0)->orderByDesc('created_at')->skip($start)->take(6)->get();

        return response()->json([
            'btn_more' => count($comments_all) > 5 ? 'yes' : 'no',
            'url' => route('front.product.show.comment.ajax',[$id,$start + 5]),
            'html' => view('front.product.includes.comment_ajax', compact( 'comments'))->render(),
        ], 200);
    }
    public function product_favorite($id)
    {
        try{
            if(Auth::check())
            {
                $invent=Favorite::where('user_id',Auth::user()->id)->where('product_id',$id)->first();
                if($invent)
                {
                    return redirect()->back()->with('err_message','It is Available in Your Wish List');
                }
                $item=new Favorite();
                $item->user_id=Auth::user()->id;
                $item->product_id=$id;
                $item->model_id=0;
                $item->save();
                return redirect()->back()->with('flash_message','Success Add Favorite');
            }
            else {
                return redirect()->back()->with('err_message','Please Login');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('err_message','An Error Occurred, Please Try Again');
        }
    }
    public function product_comment($id, Request $request)
    {
        $item = Product::findOrFail($id);
        if (!Auth::check()) {
            return redirect()->back()->withInput()->with('err_message', 'ابتدا وارد شوید');
        }
        if (auth()->user()->can('comment_create')) {
            $this->validate($request, [
                'name' => 'required',
                'email' => 'nullable|email',
                'text' => 'required',
                'captcha' => 'required',
            ]);
        } else {
            $this->validate($request, [
                'text' => 'required',
                'captcha' => 'required',
            ]);
        }
        if ($request->captcha != session('captcha_code')) {
            return redirect()->back()->withInput()->with('err_message', 'Enter The Correct Security Code');
        }
        try {
            $words = explode(' ', $request->text);
            $active = true;
            $word = Word::whereIN('word', $words)->Where(function ($query) use ($words) {
                for ($i = 0; $i < count($words); $i++) {
                    $query->orwhere('word', 'like', '%' . $words[$i] . '%');
                }
            })->get();
            if (count($word)) {
                $active = false;
            }
            $today = Carbon::now();
            $today_comment = Comment::where('user_id', auth()->id())->where('product_id', $id)->whereDate('created_at', $today)->get();
            if (count($today_comment) >= 2) {
                return redirect()->back()->with('err_message', 'You Can Leave a Maximum of 2 Messages Per Day For Each Product');
            }
//

            if (!Comment::where('user_id', auth()->id())->where('product_id', $id)->where('text', $request->text)->first()) {
                $comment = new Comment();
                $comment->user_id = auth()->user()->can('comment_create') ? 0 : Auth::id();
                $comment->title = auth()->user()->can('comment_create') ? 'comment_create' : null;
                $comment->name = auth()->user()->can('comment_create') ? $request->name : Auth::user()->first_name . ' ' . Auth::user()->last_name;
                $comment->email = auth()->user()->can('comment_create') ? $request->email : Auth::user()->email;
                $comment->product_id = $id;
                $comment->text = $request->text;
                $comment->size_checked = $request->size_checked;
                $comment->lang = lang();
                if ($active) {
                    $comment->status = 1;
                }
                $comment->save();
                if (auth()->check() && auth()->user()->hasRole('User') && $request->hasFile('photos')) {
                    $item = new ProductChoking();
                    $item->comment_id = $comment->id;
                    $item->user_id = Auth::id();
                    $item->title = ProductChoking::title_set($request->model_id);
                    $item->product_id = $id;
                    $item->model_id = $request->model_id;
                    $item->lang = lang();
                    $item->save();

                    if ($request->hasFile('photos')) {
                        foreach ($request->photos as $value) {
                            $photo = new Photo();
                            $photo->path = file_store($value, 'assets/uploads/products/choking/' . date('Y/m/d') . '/'.lang().'/photos/', 'photo-');;
                            $photo->lang = 'en';
                            $item->photos()->save($photo);
                        }
                        optimizer($photo->path);
                    }
                }

            }
            return redirect()->back()->with('flash_message', 'Success Send Comment');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'An Error Occurred, Please Try Again');
        }
    }
    public function product_ajax_model(Request $request)
    {
        $model=Modale::find($request->model_id);
        if(!$model)
        {
            return ['status'=>'danger','msg'=>'Not Found Model'];
        }
        $sizes=ModelSize::where('model_id',$model->id)->get();

        return [
            'status'=>'success',
            'model'=>$model,
            'inventory'=>count($model->size_inventory),
            'view_model'=>view('front.product.includes.size',compact('sizes','model'))->render(),
            'view_price'=>view('front.product.includes.price',compact('model'))->render()
        ];
    }

    public function product_compare()
    {
        return view('front.product.compare');
    }

    //خقیثق
    public function how_order()
    {
        return view('front.how-order');
    }

    public function return()
    {
        return view('front.return');
    }


    ///cart
    public function cart_index()
    {
        return view('front.cart.index');
    }

    public function cart_deliver_address()
    {
        return view('front.cart.deliver-address');
    }

    ///profile
    public function profile_index()
    {
        return view('front.profile.index');
    }

    ///auth
    public function register(Request $request)
    {
        $this->validate($request, [
            'first_name' => 'required|max:120',
            'last_name' => 'required|max:120',
            'country' => 'required',
            'email' => 'required|email|unique:users',
            'password' => 'required|min:8|confirmed',
        ]);
        try {
            $country=Country::findOrFail($request->country);

            $user=User::create([
               'first_name'=>$request->first_name,
               'last_name'=>$request->last_name,
               'state'=>$country->id,
               'city'=>$country->phonecode,
               'email'=>$request->email,
               'password'=>$request->password,
                'lang'=>lang(),
            ]);
            $user->assignRole('User');
            $user->verify_email=md5(time()).$user->id;
            $user->save();

            $url=route('front.register.confirm',[$user->id,$user->verify_email]);

            $text='<p style="text-align: left">';
            $text.='<strong>';
            $text.=$user->first_name;
            $text.=' ';
            $text.=$user->last_name;
            $text.='</strong>';
            $text.=' Welcome To Online Shop BigSize';
            $text.='</p>';
            $text.='<p style="text-align: left">';
            $text.='<a href="'.$url.'" dir="ltr">';
            $text.='Click to Confirm Registration';
            $text.='</a>';
            $text.='</p>';
            $text.='<p>';
            $details = [
                'subject' => 'Verify Register',
                'title' => 'Verify Register',
                'body' => $text
            ];
            \Mail::to($user->email)->send(new Mail($details));


            return redirect()->route('login')->with('flash_message', 'Success Register, Send Link To Email For Confirmation');
        } catch (\Exception $e) {
            return redirect()->route('front.index')->with('err_message', 'An Error Occurred, Please Try Again');
        }
    }

    public function register_confirm($id,$code)
    {
        $user=User::where('id',$id)->where('verify_email',$code)->firstOrFail();

        try {
            $user->registration='complete';
            $user->account_status='active';
            $user->mobile_status='active';
            $user->verify_email=null;
            $user->update();

            return redirect()->route('login')->with('flash_message', 'Success Confirmed Account');
        } catch (\Exception $e) {
            return redirect()->route('front.index')->with('err_message', 'An Error Occurred, Please Try Again');
        }
    }

    public function reset_password()
    {
        return view('auth.passwords.reset');
    }
    public function reset_password_post(Request $request)
    {
        $user=User::where('email',$request->email)->first();
        try {
            if(!$user)
            {
                return redirect()->route('front.index')->with('err_message', 'Not Found User');
            }
            $user->verify_email=md5(time()).$user->id;
            $user->update();

            $url=route('front.reset.password.confirm',[$user->id,$user->verify_email]);

            $text='<p style="text-align: left">';
            $text.='<strong>';
            $text.=$user->first_name;
            $text.=' ';
            $text.=$user->last_name;
            $text.='</strong>';
            $text.=' Your Request Change Password ';
            $text.='</p>';
            $text.='<p style="text-align: left">';
            $text.='<a href="'.$url.'" dir="ltr">';
            $text.='Click to Set New Password';
            $text.='</a>';
            $text.='</p>';
            $text.='<p>';
            $details = [
                'subject' => 'Change Password',
                'title' => 'Change Password',
                'body' => $text
            ];
            \Mail::to($user->email)->send(new Mail($details));

            return redirect()->route('login')->with('flash_message', 'Success Send Request Change Password For Email');
        } catch (\Exception $e) {
            return redirect()->back()->with('err_message', 'An Error Occurred, Please Try Again');
        }
    }
    public function reset_password_confirm($id,$code)
    {
        $user=User::where('id',$id)->where('verify_email',$code)->firstOrFail();

        return view('auth.passwords.new',compact('user'));
    }
    public function reset_password_new_set($id,Request $request)
    {
        $this->validate($request, [
            'password' => 'required|min:8|confirmed',
        ]);
        $user=User::where('id',$id)->firstOrFail();
        try {
            $user->password=$request->password;
            $user->verify_email=null;
            $user->update();

            return redirect()->route('login')->with('flash_message', 'Success Change Password');
        } catch (\Exception $e) {
            return redirect()->back()->with('err_message', 'An Error Occurred, Please Try Again');
        }
    }

}
