<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class ArticleComment extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id', 'created_at', 'updated_at'];
    public function parent()
    {
        return $this->hasOne('App\Models\ArticleComment', 'reply_id');
    }
    public function children()
    {
        return $this->hasMany('App\Models\ArticleComment', 'reply_id')->with('children');
    }
    public function article()
    {
        return $this->belongsTo('App\Models\Article', 'article_id');
    }


    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures');
    }

}
