<?php


namespace App\Models;;


use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\File;


class Basket extends Model

{
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */

    protected $guarded = ['id', 'created_at', 'updated_at'];


    public function product()
    {

        return $this->hasOne('App\Models\Product', 'id', 'product_id');

    }


    public function price()
    {

        return $this->hasOne('App\Models\Price', 'id', 'price_id');

    }


    public function user()
    {

        return $this->hasOne('App\Models\User', 'id', 'user_id');

    }
    public function factor()
    {

        return $this->hasOne('App\Models\Factor', 'id','factor_id');

    }
//    public function modell()
//    {
//
//        return $this->hasOne('App\Models\Price', 'id','model_id');
//
//    }

    public function modale()
    {

        return $this->hasOne('App\Models\Modale', 'id', 'model_id');

    }
    public function size()
    {

        return $this->hasOne('App\Models\ModelSize', 'id', 'size_id');

    }

    public static function setDiscount($count)
    {
        switch ($count) {
            case 0:
                return 8000;
                break;
            case 1:
                return 8000;
                break;
            case 2:
                return 8000;
                break;
            case 3:
                return 0;
                break;
            case 4:
                return 0;
                break;
            case 5:
                return 0;
                break;
            default:
                return 0;
                break;
        }
    }
}

