<?php

namespace App\Models;;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Category extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['sort_id', 'parent_id', 'name', 'slug', 'active'];

    public function parent()
    {
        return $this->belongsTo('App\Models\Category', 'parent_id');
    }

    public function children()
    {
        return $this->hasMany('App\Models\Category', 'parent_id')->with('children')->orderBy('sort_id', 'asc');
    }
    public function children_act()
    {
        if(app()->getLocale() == 'fa')
        {
            $childs= $this->hasMany('App\Models\Category', 'parent_id')->Where('active',1)->with('children')->orderBy('sort_id', 'asc');
        }
        else
        {
            $childs= $this->hasMany('App\Models\Category', 'parent_id')->whereHas('langs',function ($lang){
                $lang->where('lang',app()->getLocale())->where('col_name','active')->where('text',1);
            })->with('children')->orderBy('sort_id', 'asc');
        }

        return $childs;
    }

    public function brands()
    {
        return $this->hasMany('App\Models\Brand', 'category_id', 'id')->orderBy('sort', 'asc');
    }

    public function products()
    {
        return $this->hasMany('App\Models\Product', 'category_id')->orderBy('created_at' , 'DESC');
    }

    public static function count_p($id)
    {
        $p_idd=[];
        $p_id=Product::where('category_id',$id)->get();
        foreach ($p_id as $p)
        {
            array_push($p_idd,$p->id);
        }
        $m_count=Modale::whereIN('product_id',$p_idd)->count();

        return $m_count;
    }

    public function photo()
    {
        $lang=app()->getLocale();
        $photo= $this->morphOne('App\Models\Photo', 'pictures')->where('pictures_type','App\Models\Category')->where('lang',$lang);
        if(!$photo->first())
        {
            $photo=$this->morphOne('App\Models\Photo', 'pictures')->where('pictures_type','App\Models\Category')->where('lang','fa');
        }
        return $photo;
    }
    public function photo_panel()
    {
        return $this->morphMany('App\Models\Photo', 'pictures');
    }
    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang',app()->getLocale())->where('col_name','active')->where('text',1);
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if(is_file($item->icon))
            {
                File::delete($item->icon);
            }
            foreach ($item->photo_panel as $photo)
            {
                $path = $photo->path;
                if(is_file($path))
                {
                    File::delete($path);
                }
                $photo->delete();
            }
            foreach ($item->langs as $lang)
            {
                if($lang->type=='file')
                {
                    if(is_file($lang->text))
                    {
                        File::delete($lang->text);
                    }
                }
                $lang->delete();
            }

        });
    }
}
