<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Factor extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */

    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function orders()
    {
        return $this->hasMany('App\Models\Basket', 'factor_id','id');
    }
    public function user()
    {
        return $this->hasOne('App\Models\User', 'id','user_id');
    }
    public function states()
    {
        return $this->hasOne('App\Models\ProvinceCity', 'id','state');
    }
    public function payk_factor()
    {
        return $this->hasOne('App\Models\PaykFactor', 'factor_id')->where('factor_type','online');
    }
    public function citys()
    {
        return $this->hasOne('App\Models\ProvinceCity', 'id','city');
    }
    public function area()
    {
        return $this->hasOne('App\Models\TehranArea', 'id','area_id');
    }
    public function gateway()
    {
        return $this->hasMany('App\Models\Verify', 'factor_id','id')->where('status',1);
    }
    public function gift()
    {
        return $this->belongsTo('App\Models\GiftBox', 'gift_box_id');
    }

    public static function sendType($type)
    {
        switch ($type){
            case 1:
                return "پیک تهران";
                break;
            case 2:
                return "پست پیشتاز";
                break;
            case 3:
                return "پست سفارشی";
                break;
            default:
                return "ارسال رایگان";
                break;
        }
    }
    public static function payment_way($factor)
    {
        switch ($factor->payment_way){
            case 'wallet':
                return "کیف پول";
                break;
            case 'gateway':
                return self::pay_mode($factor);
                break;
            default:
                return "نا مشخص";
                break;
        }
    }
    public static function pay_mode($factor)
    {
        switch ($factor->pay_mode){
            case 'parsian':
                return "درگاه پارسیان";
                break;
            case 'zarinpal':
                return "زرین پال";
                break;
            case 'online':
                return "به پرداخت";
                break;
            case 'cart':
                return "کارت به کارت";
                break;
            case 'wallet':
                return "کیف پول";
                break;
            default:
                return "نا مشخص";
                break;
        }
    }

    public static function pay_status($factor)
    {
        switch ($factor->pay_status){
            case 1:
                return 'پرداخت شده';
                break;
            case 0:
                return 'پرداخت نشده';
                break;
            default:
                return "نا مشخص";
                break;
        }
    }
    public static function pay_status_color($factor)
    {
        switch ($factor->pay_status){
            case 1:
                return 'floralwhite';
                break;
            case 0:
                return 'red';
                break;
            default:
                return "black";
                break;
        }
    }
    public static function status($status)
    {
        switch ($status){
            case 0:
                return 'ناموفق';
                break;
            case 1:
                return 'درانتظار تایید';
                break;
            case 2:
                return 'در حال انجام';
                break;
            case 3:
                return 'ارسال شده';
                break;
            case 4:
                return 'تحویل داده شده';
                break;
            case 5:
                return 'رزرو شده';
                break;
            case 10:
                return 'ناموفق';
                break;
            case -1:
                return 'لغو شده';
                break;
            default:
                return "نامشخص";
                break;
        }
    }
}
