<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductCategory extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['sort_id', 'parent_id', 'name', 'slug'];

    public function parent()
    {
        return $this->hasOne('App\Models\Category', 'parent_id');
    }

    public function children()
    {
        return $this->hasMany('App\Models\Category', 'parent_id')->with('children');
    }

    public function products()
    {
        return $this->hasMany('App\Models\Product', 'category_id');
    }
    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($category) {
            foreach ($category->children as $children)
            {
                $children->delete();
            }
            foreach ($category->products as $products)
            {
                $products->delete();
            }
            foreach ($category->langs as $lang)
            {
                if($lang->type=='file')
                {
                    if(is_file($lang->text))
                    {
                        File::delete($lang->text);
                    }
                }
                $lang->delete();
            }
        });
    }
}
