<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\File;
use Carbon\Carbon;

class ProductChoking extends Model
{
    use SoftDeletes;

    protected $guarded = ['id', 'created_at', 'updated_at'];


    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }
    public function product()
    {
        return $this->belongsTo('App\Models\Product', 'product_id');
    }
    public function model()
    {
        return $this->belongsTo('App\Models\Modale', 'model_id');
    }
    public function size()
    {
        return $this->belongsTo('App\Models\ModelSize', 'size_id');
    }
    public static function title_set($model_id,$size_id=null)
    {
        $size=ModelSize::find($size_id);
        $model=Modale::find($model_id);
        $title=null;
        $size_name=$size?$size->title:null;
        $model_name=null;
        $product_name=null;
        if($model){
            $model_name=$model->type_val;

            if($model->product)
            {
                $product_name=$model->product->title;
            }
        }
        if($product_name!=null)
        {
            $title.=' ';
            $title.=$product_name;
        }
        if($model_name!=null)
        {
            $title.=$title!=null?',':'';
            $title.=' ';
            $title.=$model_name;
        }
        if($size_name!=null)
        {
            $title.=$title!=null?',':'';
            $title.=' ';
            $title.=$size_name;
        }
        return $title;
    }

    public function photos()
    {
        return $this->morphMany('App\Models\Photo', 'pictures');
    }


    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if(count($item->photos))
            {
                foreach ($item->photos as $photo)
                {
                    if(is_file($photo->path))
                    {
                        File::delete($photo->path);
                    }
                    $photo->delete();
                }
            }
        });
    }
}
