<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;
use Illuminate\Database\Eloquent\SoftDeletes;

class Size extends Model
{
    use SoftDeletes;

    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function cat()
    {
        return $this->belongsTo('App\Models\SizeCat', 'cat_id');
    }
    public static function sizes_invent($item)
    {
        $size_name=[];
        if(!blank($item->size_m))
        {
            array_push($size_name,read_lang($item,'size_m'));
        }
        if(!blank($item->size_l))
        {
            array_push($size_name,read_lang($item,'size_l'));
        }
        if(!blank($item->size_xl))
        {
            array_push($size_name,read_lang($item,'size_xl'));
        }
        if(!blank($item->size_2xl))
        {
            array_push($size_name,read_lang($item,'size_2xl'));
        }
        if(!blank($item->size_3xl))
        {
            array_push($size_name,read_lang($item,'size_3xl'));
        }
        if(!blank($item->size_4xl))
        {
            array_push($size_name,read_lang($item,'size_4xl'));
        }
        if(!blank($item->size_5xl))
        {
            array_push($size_name,read_lang($item,'size_5xl'));
        }
        if(!blank($item->size_6xl))
        {
            array_push($size_name,read_lang($item,'size_6xl'));
        }
        return $size_name;
    }
    public static function size_type($item)
    {
        $res='';
        $kama=false;
        if($item->size_m)
        {
            $res.=$kama==true?' , ':'';
            $res.='M';
            $kama=true;
        }
        if($item->size_l)
        {
            $res.=$kama==true?' , ':'';
            $res.='L';
            $kama=true;
        }
        if($item->size_xl)
        {
            $res.=$kama==true?' , ':'';
            $res.='XL';
            $kama=true;
        }
        if($item->size_2xl)
        {
            $res.=$kama==true?' , ':'';
            $res.='2XL';
            $kama=true;
        }
        if($item->size_3xl)
        {
            $res.=$kama==true?' , ':'';
            $res.='3XL';
            $kama=true;
        }
        if($item->size_4xl)
        {
            $res.=$kama==true?' , ':'';
            $res.='4XL';
            $kama=true;
        }
        if($item->size_5xl)
        {
            $res.=$kama==true?' , ':'';
            $res.='5XL';
            $kama=true;
        }
        if($item->size_6xl)
        {
            $res.=$kama==true?' , ':'';
            $res.='6XL';
            $kama=true;
        }
        return $res;
    }

    public static function size_val($s_id,$p_id,$size,$lang=null)
    {
        $res=null;
        $lang=$lang??app()->getLocale();
        $val=ProductSize::where('product_id',$p_id)->where('size_id',$s_id)->first();
        if($val)
        {
            $res=read_lang($val,$size,$lang);
        }
        return $res;
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            foreach ($item->langs as $lang)
            {
                if($lang->type=='file')
                {
                    if(is_file($lang->text))
                    {
                        File::delete($lang->text);
                    }
                }
                $lang->delete();
            }
        });
    }
}
