<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;
use Illuminate\Database\Eloquent\SoftDeletes;

class SizeCat extends Model
{
    use SoftDeletes;

    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function sizes()
    {
        return $this->hasMany('App\Models\Size', 'cat_id')->orderBy('sort', 'asc');
    }

    public static function sizes_invent($item)
    {
        $size_name = [];
        foreach ($item->product_size as $size) {
            if (!blank($size->size_m)) {
                array_push($size_name, 'M');
            }
            if (!blank($size->size_l)) {
                array_push($size_name, 'L');
            }
            if (!blank($size->size_xl)) {
                array_push($size_name, 'XL');
            }
            if (!blank($size->size_2xl)) {
                array_push($size_name, '2XL');
            }
            if (!blank($size->size_3xl)) {
                array_push($size_name, '3XL');
            }
            if (!blank($size->size_4xl)) {
                array_push($size_name, '4XL');
            }
            if (!blank($size->size_5xl)) {
                array_push($size_name, '5XL');
            }
            if (!blank($size->size_6xl)) {
                array_push($size_name, '6XL');
            }
        }
        $size_name = array_unique($size_name);
        return $size_name;
    }

    public function photo()
    {
        $lang=app()->getLocale();
        $photo= $this->morphOne('App\Models\Photo', 'pictures')->where('lang',$lang);
        if(!$photo)
        {
            $photo=$this->morphOne('App\Models\Photo', 'pictures')->where('lang',default_lang());
        }

        return $photo;
    }
    public function photo_panel()
    {
        return $this->morphMany('App\Models\Photo', 'pictures');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            foreach ($item->photo_panel as $photo)
            {
                $path = $photo->path;
                if(is_file($path))
                {
                    File::delete($path);
                }
                $photo->delete();
            }
            foreach ($item->langs as $lang) {
                if ($lang->type == 'file') {
                    if (is_file($lang->text)) {
                        File::delete($lang->text);
                    }
                }
                $lang->delete();
            }
        });
    }
}
