<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Cache;
use Spatie\Permission\Traits\HasRoles;
use App\Models\Wallet;
use DB;


class User extends Authenticatable
{
    use HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id', 'created_at', 'updated_at'];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function setPasswordAttribute($password)
    {
        $this->attributes['password'] = bcrypt($password);
    }
    public function address_id($user)
    {
        if(count($user->addresses))
        {
            $arr='';
            foreach ($user->addresses as $key=> $add)
            {
                $arr.=$key>0?',':'';
                $arr.=$add->id;
            }
        }
        return $arr??0;
    }

    public static function slot_id_passed()
    {
        return auth()->user()->slot_user_id;
    }
    public static function createWallet($user=null)
    {
        $user=$user ?? auth()->user();
        if ($user->wallet) {
            return $user->wallet;
        }else{
            $wallet=new Wallet();
            $wallet->money=0;
            $wallet->user_id=$user->id;
            $wallet->save();
            return $wallet;
        }
    }

    public function sale_product($user_id,$from_date,$to_date)
    {
        $count=0;
        $price=0;
        $p_count=0;
        $p_price=0;
        //factor
        $factor=Factor::where('user_id',$user_id)->whereIN('status',[1,2,3,4]);
        if($from_date)
        {
            $factor=$factor->whereDate('created_at','>=',$from_date);
        }
        if($to_date)
        {
            $factor=$factor->whereDate('created_at','<=',$to_date);
        }
        $price=$factor->sum('total_price');
        $factor=$factor->select('id')->get()->toArray();
        $count=Basket::whereIN('factor_id',$factor)->where('status',1)->sum('num');
        //panel factor
        $p_factor=PanelFactor::where('user_id',$user_id)->whereIN('status',['active','send']);
        if($from_date)
        {
            $p_factor=$p_factor->whereDate('created_at','>=',$from_date);
        }
        if($to_date)
        {
            $p_factor=$p_factor->whereDate('created_at','<=',$to_date);
        }
        $p_price=$p_factor->sum('all_price');
        $p_factor=$p_factor->select('id')->get()->toArray();
        $p_count=PanelBasket::whereIN('factor_id',$p_factor)->where('status','active')->sum('num');

        return [$count,$price,$p_count,$p_price];
    }
    public function page_vip($user_id)
    {
        $page_name=null;
        $page_status='pending';
        $social=[];

        $vip_page=VipPage::where('user_id',$user_id)->first();
        if($vip_page)
        {
            $page_name=$vip_page->title;
            $page_status=$vip_page->status;
            array_push($social,'https://www.instagram.com/'.$vip_page->instagram);
            if($vip_page->telegram){
                array_push($social,'https://t.me/'.$vip_page->telegram);
            }
            if($vip_page->social && count(explode(',',$vip_page->social)))
            {
                foreach (explode(',',$vip_page->social) as $social_set)
                {
                    array_push($social,$social_set);
                }
            }
        }

        return [$page_name,$page_status,$social];
    }
    public function chAracter()
    {
        return $this->hasOne('App\Models\UserCharacter', 'user_id');
    }

    public function walet_set_all()
    {
        return $this->hasMany('App\Models\WalletSet', 'user_id');
    }
    public function walet_set()
    {
        return $this->hasMany('App\Models\WalletSet', 'user_id')->where('status','pending');
    }
    public function orders()
    {
        return $this->hasMany('App\Models\Order', 'user_id');
    }
    public function addresses()
    {
        return $this->hasMany('App\Models\Address', 'user_id')->orderByDesc('id')->take(9);
    }

    public function isOnline()
    {
        return Cache::has('user-is-online-' . $this->id);
    }
    public static function role_title($name)
    {
        $role=DB::table('roles')->where('name',$name)->first();
        return $role->title;
    }
    public function province()
    {
        return $this->belongsTo('App\Models\ProvinceCity', 'state','id');
    }
    public function country()
    {
        return $this->belongsTo('App\Models\Country', 'state');
    }
    public function states()
    {
        return $this->belongsTo('App\Models\ProvinceCity', 'state','id');
    }
    public function citys()
    {
        return $this->hasOne('App\Models\ProvinceCity' , 'id' , 'city');
    }
    public function wallet()
    {
        return $this->hasOne('App\Models\Wallet' , 'user_id' , 'id');
    }
    public function photo()
    {

        return $this->morphOne('App\Models\Photo', 'pictures');

    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {

            $item->photo()->get()

                ->each(function ($photo) {

                    $path = $photo->path;

                    File::delete($path);

                    $photo->delete();

                });

        });
        static::deleting(function ($user) {
            $user->character()->get()->each(function ($character) {
                $character->delete();
            });
        });
    }
}
