@extends('layouts.front')
@section('title','Register')

@section('styles')
    <link rel='stylesheet' type='text/css' href='{{url('assets/css/select2.css')}}'>
@endsection
@section('content')
    <form method="post" action="{{route('front.register.post')}}" class="container my-5 top form-login">
        @csrf
        <h2 class="text-center fw-bold mb-4">Register</h2>
        <div class="my-4">
            <label class="form-label fw-bold h5">* FirstName:</label>
            <input type="text" class="form-control" name="first_name" value="{{old('first_name')}}" required>
        </div>
        <div class="my-4">
            <label class="form-label fw-bold h5">* LastName:</label>
            <input type="text" class="form-control" name="last_name" value="{{old('last_name')}}" required>
        </div>
        <div class="my-4">
            <label class="form-label fw-bold h5">* Country:</label>
            <select name="country" class="form-control select2">
                @foreach($countries as $country)
                    <option value="{{$country->id}}" {{old('country') == $country->id?'selected':''}}>(+{{$country->phonecode}}){{$country->nicename}}</option>
                @endforeach
            </select>
        </div>
        <div class="my-4">
            <label class="form-label fw-bold h5">* Email:</label>
            <input type="email" class="form-control" name="email" autocomplete="off" value="{{old('email')}}" required>
        </div>
        <div class="my-4">
            <label class="form-label fw-bold h5">* Password:</label>
            <input type="password" class="form-control" name="password" autocomplete="off" required>
        </div>
        <div class="my-4">
            <label class="form-label fw-bold h5">* Password Retry:</label>
            <input type="password" class="form-control" name="password_confirmation" autocomplete="off" required>
        </div>
        <input type="submit" value="CONTINUE" class="text-white fw-bold text-center primary-bg border-0 w-100 py-2">
        <p class="text-center h6 mb-2">
        <p class="text-start h6 mt-1 mb-2">
            Are You Account? <a href="{{route('login')}}" class="text-primary">Login</a>
        </p>
        </p>
    </form>
@endsection

@section('scripts')
    <script src="{{url('assets/js/select2.js')}}"></script>
    <script>
        $('.select2').select2()
    </script>
@endsection
