@extends('layouts.front')

@section('title',' Home')

@section('content')
    <!-- banner -->
   
    <section id="banner" class="position-relative top">
        <!-- Swiper -->
        <div>
            <div class="swiper banner">
                <div class="swiper-wrapper">
                    @if(count($sliders))
                        @foreach($sliders as $slider)
                            <div class="swiper-slide">
                                <a href="{{check_link(read_lang($slider,'link'))}}"
                                   @if($slider->new_page=='yes') target="_blank"
                                   @endif class="d-block">
                                    <img alt="{{read_lang($slider,'title')}}" src="{{url_big($slider->photo->path)}}"
                                         class="img-fluid w-100">
                                </a>
                            </div>
                        @endforeach
                    @else
                        <div class="swiper-slide">
                            <a class="d-block">
                                <img alt="banner"
                                     src="{{url('assets/img/1687758864e62c45403d4b3564cd7299256b147ea8.png')}}"
                                     class="img-fluid">
                            </a>
                        </div>
                    @endif
                </div>
            </div>
            <div class="swiper-button-next">
            </div>
            <div class="swiper-button-prev">
            </div>
        </div>
    </section>

    <!-- under banner -->

    <section id="under-banner" class="d-none"
             class="container d-flex flex-column flex-lg-row gap-4 align-items-center justify-content-between py-4 left">
        <div class="d-flex align-items-center justify-content-between flex-grow-1 w-100">
            <div class="text-center px-lg-4">
                <h1 class="font-bold">10% OFF</h1>
                <h6 class="fw-bold text-secondary">ORDERS OF $49+</h6>
            </div>
            <div class="dash"></div>
            <div class="text-center px-lg-4">
                <h1 class="font-bold">15% OFF</h1>
                <h6 class="fw-bold text-secondary">ORDERS OF $89+</h6>
            </div>
            <div class="dash"></div>
            <div class="text-center px-lg-4">
                <h1 class="font-bold">20% OFF</h1>
                <h6 class="fw-bold text-secondary">ORDERS OF $169+</h6>
            </div>
            <div class="dash d-lg-block d-none"></div>
        </div>
        <a class="primary-bg rounded-pill text-white">
            CODE: <span class="font-bold">BIGSIZE</span>
        </a>
    </section>

    <!-- category -->
    @if(count($product_cats))
        <section id="category" class="pt-5 top">
            <h4 class="mx-auto font-bold d-table after">Shop by Category</h4>
            <div class="row g-3 flex-wrap mt-5">
                @foreach($product_cats as $cat)
                    <a class="d-block text-center col-4">
                        <div class="position-relative category_card overflow-hidden">
                            <img alt="{{read_lang($cat,'name')}}" src="{{url_big($cat->photo->path)}}"
                                 class="img-fluid">
                        </div>
                    </a>
                @endforeach
            </div>
        </section>
    @endif
    <!-- special sale -->
    @if($slider_vip->status=='active' and count($product_slider_vip)>0)
        <section id="special-sale" class="pt-5 position-relative left">
            <div>
                <h4 class="mx-auto font-bold d-table after">{{read_lang($slider_vip,'title')}}</h4>
                <!-- Swiper -->
                <div>
                    <div class="left">
                        <div class="swiper special-sale mt-5">
                            <div class="swiper-wrapper">
                                @foreach($product_slider_vip as $product)
                                    <div class="swiper-slide p-1">
                                        @include('front.product.includes.card3',['item'=>$product])
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="swiper-button-next right-54">
                        </div>
                        <div class="swiper-button-prev left-54">
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!-- styles -->
    @if(count($banners))
        <section id="styles" class="container pt-5 top">
            <h4 class="mx-auto font-bold d-table after">New styles</h4>
            <div class="row align-items-center g-4 mt-5">
                <div class="col-lg-6">
                    <div class="row g-4">
                        @foreach($banners->take(4) as $banner)
                            <a href="{{check_link(read_lang($banner,'link'))}}" target="_blank"
                               class="d-block col-6 position-relative overflow-hidden">
                                <img alt="{{read_lang($slider,'brand')}}" src="{{url_big($banner->photo->path)}}"
                                     class="img-fluid border border-2 border-dark">
                            </a>
                        @endforeach
                    </div>
                </div>
                <div class="col-lg-6">
                    @foreach($banners->skip(4)->take(1) as $banner)
                        <a href="{{check_link(read_lang($banner,'link'))}}" target="_blank"
                           class="d-block position-relative overflow-hidden">
                            <img alt="{{read_lang($banner,'brand')}}"
                                 src="{{url_big($banner->photo->path)}}"
                                 class="img-fluid h-100">
                        </a>
                    @endforeach
                </div>
            </div>
        </section>
    @endif
    <!-- collections -->
    @if(count($products_new))
        <section id="collections" class="pt-5 left position-relative">
            <div class="d-flex container flex-column flex-md-row align-items-center gap-4">
                {{--      <h4 class="fw-bold">See new collections</h4>--}}
                <h4 class="mx-auto font-bold d-table after">See new collections</h4>
                {{--      <a class="d-block primary-bg rounded-pill text-white fw-bold">--}}
                {{--        Shop now--}}
                {{--      </a>--}}
            </div>
            <!-- Swiper -->
            <div>
                <div class="swiper special-sale mt-5">
                    <div class="swiper-wrapper">
                        @foreach($products_new as $product)
                            <div class="swiper-slide p-1">
                                @include('front.product.includes.card1',['item'=>$product])
                            </div>
                        @endforeach
                    </div>
                </div>
                <div class="swiper-button-next">
                </div>
                <div class="swiper-button-prev">
                </div>
            </div>
        </section>
    @endif

    <!-- trend -->

    <section id="trend" class="pt-5 d-none top">
        <h4 class="mx-auto font-bold d-table after">Trend styles</h4>
        <!-- Swiper -->
        <div class="position-relative">
            <div class="swiper special-sale mt-5">
                <div class="swiper-wrapper">
                    @foreach($trends as $trend)
                        <div class="swiper-slide p-1">
                            <a class="d-block position-relative overflow-hidden">
                                <img alt="trend"
                                     src="{{url($trend->path)}}"
                                     class="img-fluid">
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="swiper-button-next right-44">
            </div>
            <div class="swiper-button-prev left-44">
            </div>
        </div>
    </section>

    <!-- banners -->
    @if(count($banners) > 5)
        <section id="banners" class="pt-5">
            @foreach($banners->skip(5) as $banner)
                <a href="{{check_link(read_lang($banner,'link'))}}" class="d-block left mb-2">
                    <img alt="{{read_lang($slider,'brand')}}" src="{{url_big($banner->photo->path)}}"
                         class="img-fluid">
                </a>
            @endforeach
        </section>
    @endif
    <!-- galley -->
    <section id="gallery" class="container pt-5 left">
        <h4 class="mx-auto font-bold d-table after">Trend styles</h4>
        <!-- Swiper -->
        <div class="position-relative">
            <div class="swiper special-sale mt-5">
                <div class="swiper-wrapper">
                    @foreach($trends as $trend)
                        @if($trend->pictures && $trend->pictures->product)
                            <div class="swiper-slide p-1">
                                <a
                                        href="{{route('front.product.show',[$trend->pictures->product->id,read_lang($trend->pictures->product,'slug')])}}">
                                    <div class="overflow-hidden">
                                        <img alt="gallery"
                                             src="{{url($trend->path)}}"
                                             class="img-fluid transition">
                                    </div>
                                </a>
                            </div>
                        @else
                            <div class="swiper-slide p-1">
                                <a data-fancybox="gallery_trend"
                                   href="{{url($trend->path)}}">
                                    <div class="overflow-hidden">
                                        <img alt="gallery"
                                             src="{{url($trend->path)}}"
                                             class="img-fluid transition">
                                    </div>
                                </a>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
            <div class="swiper-button-next right-44">
            </div>
            <div class="swiper-button-prev left-44">
            </div>
        </div>
    </section>
@endsection