@foreach($comments as $comment)
    <div class="row g-4 border-b-dash py-4">
        <div class="col-lg-2 col-md-4 br-10">
            <p class="fw-bold mb-2">{{$comment->name}}</p>
            <p class="fw-bold mb-2">
                {{$comment->created_at->format('d F Y')}}
            </p>
            <p class="fw-bold mb-2">
                {{$comment->created_at->format(' H:i')}}
            </p>
        </div>
        <div class="col-lg-10 col-md-8">
            <p class="text-justify">
                {!! html_entity_decode(nl2br($comment->text)) !!}
            </p>
        </div>
        @if(count($comment->children))
            @foreach($comment->children as $comment_ch)
                <div class="col-md-10 col-11 replay_comment mx-auto">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-lg-2 col-md-4 br-30">
                                <p class="fw-bold mb-2">Reply</p>
                                <p class="fw-bold mb-2">{{$comment_ch->name}}</p>
                                <p class="fw-bold mb-2">
                                    {{$comment_ch->created_at->format('d F Y')}}
                                </p>
                                <p class="fw-bold mb-2">
                                    {{$comment_ch->created_at->format(' H:i')}}
                                </p>
                            </div>
                            <div class="col-lg-10 col-md-8">
                                <p class="text-justify">
                                    {!! html_entity_decode(nl2br($comment_ch->text)) !!}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        @endif
    </div>
@endforeach