<div class="top mt-5">
    {{--            <h4 class="font-bold">Customer Reviews (4)</h4>--}}
    @if($all_choking)
        <div class="row g-4 g-md-0 p-md-2 pb-2 mt-3 secondary-bg">
            <div class="col-xl-3 col-md-6">
                <div>
                    <p>All Comment</p>
                    <div class="d-flex align-items-center gap-2 mt-3">
                        <p class="font-bold h3">{{$all_choking}}</p>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <p class="mb-2">Did the item fit well?</p>
                <div class="d-flex align-items-center gap-2 mb-1">
                    <small class="w-101">small({{$small_choking}})</small>
                    <div class="rounded-pill secondary-bg mt-1 overflow-hidden progress">
                        <div class="primary-bg"
                             style="width: {{$small_choking > 0 ? round($small_choking / $all_choking * 100,1) : 0}}%"></div>
                    </div>
                    <small class="w-51">{{$small_choking > 0 ? round($small_choking / $all_choking * 100,1) : 0}}
                        %</small>
                </div>
                <div class="d-flex align-items-center gap-2 mb-1">
                    <small class="w-101">True Size({{$normal_choking}})</small>
                    <div class="rounded-pill secondary-bg mt-1 overflow-hidden progress">
                        <div class="primary-bg"
                             style="width: {{$normal_choking > 0 ? round($normal_choking / $all_choking * 100,1) : 0}}%"></div>
                    </div>
                    <small class="w-51">{{$normal_choking > 0 ? round($normal_choking / $all_choking * 100,1) : 0}}
                        %</small>
                </div>
                <div class="d-flex align-items-center gap-2 mb-1">
                    <small class="w-101">Large({{$big_choking}})</small>
                    <div class="rounded-pill secondary-bg mt-1 overflow-hidden progress">
                        <div class="primary-bg"
                             style="width: {{$big_choking > 0 ? round($big_choking / $all_choking * 100,1) : 0}}%"></div>
                    </div>
                    <small class="w-51">{{$big_choking > 0 ? round($big_choking / $all_choking * 100,1) : 0}}
                        %</small>
                </div>
            </div>
        </div>
    @endif
    <div class="d-flex align-items-center flex-column flex-lg-row justify-content-between border-bottom pb-4 pb-lg-0 gap-4 gap-lg-0 mt-4">
        <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link {{!old('text')?'active' :''}}" id="pills-comment-show-tab" data-bs-toggle="pill"
                        data-bs-target="#pills-comment-show" type="button" role="tab"
                        aria-controls="pills-comment-show"
                        aria-selected="{{!old('text')?true :false}}">All Reviews ({{count($comments)}})
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="pills-ProductChoking-tab" data-bs-toggle="pill"
                        data-bs-target="#pills-ProductChoking" type="button" role="tab"
                        aria-controls="pills-ProductChoking"
                        aria-selected="false">Hate the Product({{count($product_chokings)}})
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link {{old('text')?'active' :''}}" id="pills-comment-tab" data-bs-toggle="pill"
                        data-bs-target="#pills-comment" type="button" role="tab" aria-controls="pills-comment"
                        aria-selected="{{!old('text')?true :false}}">Add Comment
                </button>
            </li>
        </ul>
    </div>
    <div class="tab-content mt-4" id="pills-tabContent">
        <div class="tab-pane fade {{!old('text')?'show active' :''}}" id="pills-comment-show" role="tabpanel"
             aria-labelledby="pills-comment-show-tab">
            <div id="read_more_div">
                @if(count($comments))
                    @foreach($comments as $comment)
                        <div class="row g-4 border-b-dash py-4">
                            <div class="col-lg-2 col-md-4 br-10">
                                <p class="fw-bold mb-2">{{$comment->name}}</p>
                                <p class="fw-bold mb-2">
                                    {{$comment->created_at->format('d F Y')}}
                                </p>
                                <p class="fw-bold mb-2">
                                    {{$comment->created_at->format(' H:i')}}
                                </p>
                            </div>
                            <div class="col-lg-10 col-md-8">
                                <p class="text-justify">
                                    {!! html_entity_decode(nl2br($comment->text)) !!}
                                </p>
                            </div>
                            @if(count($comment->children))
                                @foreach($comment->children as $comment_ch)
                                    <div class="col-md-10 col-11 replay_comment mx-auto">
                                        <div class="container-fluid">
                                            <div class="row">
                                                <div class="col-lg-2 col-md-4 br-30">
                                                    <p class="fw-bold mb-2">Reply</p>
                                                    <p class="fw-bold mb-2">{{$comment_ch->name}}</p>
                                                    <p class="fw-bold mb-2">
                                                        {{$comment_ch->created_at->format('d F Y')}}
                                                    </p>
                                                    <p class="fw-bold mb-2">
                                                        {{$comment_ch->created_at->format(' H:i')}}
                                                    </p>
                                                </div>
                                                <div class="col-lg-10 col-md-8">
                                                    <p class="text-justify">
                                                        {!! html_entity_decode(nl2br($comment_ch->text)) !!}
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    @endforeach
                @else
                    <div class="col-12">
                        <a href="javascript:void(0)" class="pills-comment2-tab">
                            Be The First to Comment on This Product
                        </a>
                    </div>
                @endif
            </div>
            @if(count($comments_all) > 5)
                <a href="javascript:void(0)" class="btn btn-primary mt-3" id="read_more_click"
                   onclick="read_more('{{route('front.product.show.comment.ajax',[$item->id,5])}}')">
                    Read More
                </a>
            @endif
        </div>
        <div class="tab-pane fade" id="pills-ProductChoking" role="tabpanel"
             aria-labelledby="pills-ProductChoking-tab">
            @if(count($product_chokings))
                <div class="d-flex flex-wrap gap-3">
                    @foreach($product_chokings as $product_choking)
                        @foreach($product_choking->photos as $key=>$photo)
                            <a data-fancybox="gallery"
                               class="position-relative overflow-hidden position-relative {{$key>0?'d-none':''}}"
                               href="{{url($photo->path)}}"
                               data-caption="{{$product_choking->user?$product_choking->user->first_name.' '.$product_choking->user->last_name:''}}({{$product_choking->title}})">
                                @if($key==0)
                                    <span class="count_choking badge bg-danger">{{count($product_choking->photos)}}</span>
                                    <img class="img-fluid choking_img" alt="single"
                                         src="{{url($photo->path)}}" loading="lazy">
                                @endif
                            </a>
                        @endforeach
                    @endforeach
                </div>
            @else
                <div class="col-12">
                    <a href="javascript:void(0)" class="pills-comment2-tab">
                        Be The First To Hate The product
                    </a>
                </div>
            @endif
        </div>
        <div class="tab-pane fade {{old('text')?'show active':''}}" id="pills-comment" role="tabpanel" aria-labelledby="pills-comment-tab">
            @if(Auth::check())
                <form method="post" class="Regular shadow p-3 rounded"
                      action="{{route('front.product.comment',$item->id)}}"
                      enctype="multipart/form-data">
                    @csrf

                    <h5>
                        Comment on The product
                    </h5>
                    <div id="new-comment-blog" class="mb-3">
                        <div class="container-fluid">
                            <div class="row">
                                @can('comment_create')
                                    <div class="col-md-6 pr-0 mt-2">
                                        <label>* Name</label>
                                        <input type="text" name="name" value="{{old('name')}}" class="form-control" placeholder="* Enter Your Name" required>
                                    </div>
                                    <div class="col-md-6 pl-0 mt-2">
                                        <label>Email</label>
                                        <input type="email" name="email" value="{{old('email')}}" class="form-control"
                                               placeholder="Enter Your Mail">
                                    </div>
                                @endcan
                                <div class="col-md-6 pr-0 mt-2">
                                    <label>How Was Your Experience of Choosing The Size According to The Product
                                        Chart?</label>
                                    <select name="size_checked" class="form-control">
                                        <option value="normal" {{old('size_checked')=='normal'?'selected':''}}>True Size</option>
                                        <option value="big" {{old('size_checked')=='big'?'selected':''}}>Large</option>
                                        <option value="small" {{old('size_checked')=='small'?'selected':''}}>Small</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    @if(auth()->user()->hasRole('User'))
                        <div id="new-comment-blog" class="my-3">
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-md-6 pr-0">
                                        <label>Choosing a Product Model (for Hate the Product)</label>
                                        <select name="model_id" class="form-control">
                                            @foreach($item->models as $key=> $models)
                                                <option value="{{$models->id}}" {{old('model_id') == $models->id ? 'selected' : ''}}>
                                                    {{read_lang($models,'type')}} ({{read_lang($models,'type_val')}})
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-6 pr-0">
                                        <label>Photo Hate the Product(Max 3 Photo)</label>
                                        <input type="file" class="form-control" name="photos[]" multiple
                                               accept=".jpg,.png">
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    <div id="new-comment-blog" class="mt-3">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-md-12 pr-0 mt-2">
                            <textarea name="text" class="form-control" rows="3"
                                      placeholder="* What do You Think About This Product? Share With Others..."
                                      required>{{old('text')}}</textarea>
                                </div>
                                <div class="col-md-12 pr-0 mt-2">
                                    <div class="my-4">
                                        <label class="form-label fw-bold h5">Captcha Code:</label>
                                        <img src="{{url(captcha())}}" class="ms-2" alt="captcha">
                                        <input type="text" class="form-control mt-2" name="captcha" required>
                                    </div>
                                </div>
                                <div class="col-md-12 pr-0 mt-2">
                                    <div class="d-flex align-items-center justify-content-end pt-2">
                                        <button id="sendCommentBtn" type="submit" class="btn btn-digi btn-large"><i
                                                    class="fas fa-paper-plane"></i><span>Submit Comment</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            @else
                <div id="new-comment-blog">
                    To Submit an Comment
                    <a href="{{route('login')}}" class="login-btn btn-text font-weight-bold">Login</a> Or
                    <a class="btn-text font-weight-bold" href="{{route('register')}}">Register</a>
                </div>
            @endif
        </div>
    </div>
</div>