<div class="top mt-5">
    
    <?php if($all_choking): ?>
        <div class="row g-4 g-md-0 p-md-2 pb-2 mt-3 secondary-bg">
            <div class="col-xl-3 col-md-6">
                <div>
                    <p>كل تعليق</p>
                    <div class="d-flex align-items-center gap-2 mt-3">
                        <p class="font-bold h3"><?php echo e($all_choking); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <p class="mb-2">هل كان العنصر مناسبًا بشكل جيد؟</p>
                <div class="d-flex align-items-center gap-2 mb-1">
                    <small class="w-101">small(<?php echo e($small_choking); ?>)</small>
                    <div class="rounded-pill secondary-bg mt-1 overflow-hidden progress">
                        <div class="primary-bg"
                             style="width: <?php echo e($small_choking > 0 ? round($small_choking / $all_choking * 100,1) : 0); ?>%"></div>
                    </div>
                    <small class="w-51"><?php echo e($small_choking > 0 ? round($small_choking / $all_choking * 100,1) : 0); ?>

                        %</small>
                </div>
                <div class="d-flex align-items-center gap-2 mb-1">
                    <small class="w-101">True Size(<?php echo e($normal_choking); ?>)</small>
                    <div class="rounded-pill secondary-bg mt-1 overflow-hidden progress">
                        <div class="primary-bg"
                             style="width: <?php echo e($normal_choking > 0 ? round($normal_choking / $all_choking * 100,1) : 0); ?>%"></div>
                    </div>
                    <small class="w-51"><?php echo e($normal_choking > 0 ? round($normal_choking / $all_choking * 100,1) : 0); ?>

                        %</small>
                </div>
                <div class="d-flex align-items-center gap-2 mb-1">
                    <small class="w-101">Large(<?php echo e($big_choking); ?>)</small>
                    <div class="rounded-pill secondary-bg mt-1 overflow-hidden progress">
                        <div class="primary-bg"
                             style="width: <?php echo e($big_choking > 0 ? round($big_choking / $all_choking * 100,1) : 0); ?>%"></div>
                    </div>
                    <small class="w-51"><?php echo e($big_choking > 0 ? round($big_choking / $all_choking * 100,1) : 0); ?>

                        %</small>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <div class="d-flex align-items-center flex-column flex-lg-row justify-content-between border-bottom pb-4 pb-lg-0 gap-4 gap-lg-0 mt-4">
        <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link <?php echo e(!old('text')?'active' :''); ?>" id="pills-comment-show-tab" data-bs-toggle="pill"
                        data-bs-target="#pills-comment-show" type="button" role="tab"
                        aria-controls="pills-comment-show"
                        aria-selected="<?php echo e(!old('text')?true :false); ?>">جميع التقييمات (<?php echo e(count($comments)); ?>)
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="pills-ProductChoking-tab" data-bs-toggle="pill"
                        data-bs-target="#pills-ProductChoking" type="button" role="tab"
                        aria-controls="pills-ProductChoking"
                        aria-selected="false">أكره المنتج (<?php echo e(count($product_chokings)); ?>)
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link <?php echo e(old('text')?'active' :''); ?>" id="pills-comment-tab" data-bs-toggle="pill"
                        data-bs-target="#pills-comment" type="button" role="tab" aria-controls="pills-comment"
                        aria-selected="<?php echo e(!old('text')?true :false); ?>">أضف تعليق
                </button>
            </li>
        </ul>
    </div>
    <div class="tab-content mt-4" id="pills-tabContent">
        <div class="tab-pane fade <?php echo e(!old('text')?'show active' :''); ?>" id="pills-comment-show" role="tabpanel"
             aria-labelledby="pills-comment-show-tab">
            <div id="read_more_div">
                <?php if(count($comments)): ?>
                    <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row g-4 border-b-dash py-4">
                            <div class="col-lg-2 col-md-4 br-10">
                                <p class="fw-bold mb-2"><?php echo e($comment->name); ?></p>
                                <p class="fw-bold mb-2">
                                    <?php echo e($comment->created_at->format('d F Y')); ?>

                                </p>
                                <p class="fw-bold mb-2">
                                    <?php echo e($comment->created_at->format(' H:i')); ?>

                                </p>
                            </div>
                            <div class="col-lg-10 col-md-8">
                                <p class="text-justify">
                                    <?php echo html_entity_decode(nl2br($comment->text)); ?>

                                </p>
                            </div>
                            <?php if(count($comment->children)): ?>
                                <?php $__currentLoopData = $comment->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment_ch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-10 col-11 replay_comment mx-auto">
                                        <div class="container-fluid">
                                            <div class="row">
                                                <div class="col-lg-2 col-md-4 br-30">
                                                    <p class="fw-bold mb-2">Reply</p>
                                                    <p class="fw-bold mb-2"><?php echo e($comment_ch->name); ?></p>
                                                    <p class="fw-bold mb-2">
                                                        <?php echo e($comment_ch->created_at->format('d F Y')); ?>

                                                    </p>
                                                    <p class="fw-bold mb-2">
                                                        <?php echo e($comment_ch->created_at->format(' H:i')); ?>

                                                    </p>
                                                </div>
                                                <div class="col-lg-10 col-md-8">
                                                    <p class="text-justify">
                                                        <?php echo html_entity_decode(nl2br($comment_ch->text)); ?>

                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="col-12">
                        <a href="javascript:void(0)" class="pills-comment2-tab">
                            Be The First to Comment on This Product
                        </a>
                    </div>
                <?php endif; ?>
            </div>
            <?php if(count($comments_all) > 5): ?>
                <a href="javascript:void(0)" class="btn btn-primary mt-3" id="read_more_click"
                   onclick="read_more('<?php echo e(route('front.product.show.comment.ajax',[$item->id,5])); ?>')">
                    Read More
                </a>
            <?php endif; ?>
        </div>
        <div class="tab-pane fade" id="pills-ProductChoking" role="tabpanel"
             aria-labelledby="pills-ProductChoking-tab">
            <?php if(count($product_chokings)): ?>
                <div class="d-flex flex-wrap gap-3">
                    <?php $__currentLoopData = $product_chokings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_choking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $product_choking->photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a data-fancybox="gallery"
                               class="position-relative overflow-hidden position-relative <?php echo e($key>0?'d-none':''); ?>"
                               href="<?php echo e(url($photo->path)); ?>"
                               data-caption="<?php echo e($product_choking->user?$product_choking->user->first_name.' '.$product_choking->user->last_name:''); ?>(<?php echo e($product_choking->title); ?>)">
                                <?php if($key==0): ?>
                                    <span class="count_choking badge bg-danger"><?php echo e(count($product_choking->photos)); ?></span>
                                    <img class="img-fluid choking_img" alt="single"
                                         src="<?php echo e(url($photo->path)); ?>" loading="lazy">
                                <?php endif; ?>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="col-12">
                    <a href="javascript:void(0)" class="pills-comment2-tab">
                    كن أول من يكره المنتج
                    </a>
                </div>
            <?php endif; ?>
        </div>
        <div class="tab-pane fade <?php echo e(old('text')?'show active':''); ?>" id="pills-comment" role="tabpanel" aria-labelledby="pills-comment-tab">
            <?php if(Auth::check()): ?>
                <form method="post" class="Regular shadow p-3 rounded"
                      action="<?php echo e(route('front.product.comment',$item->id)); ?>"
                      enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <h5>
                    التعليق على المنتج
                    </h5>
                    <div id="new-comment-blog" class="mb-3">
                        <div class="container-fluid">
                            <div class="row">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('comment_create')): ?>
                                    <div class="col-md-6 pr-0 mt-2">
                                        <label>* Name</label>
                                        <input type="text" name="name" value="<?php echo e(old('name')); ?>" class="form-control" placeholder="* Enter Your Name" required>
                                    </div>
                                    <div class="col-md-6 pl-0 mt-2">
                                        <label>Email</label>
                                        <input type="email" name="email" value="<?php echo e(old('email')); ?>" class="form-control"
                                               placeholder="Enter Your Mail">
                                    </div>
                                <?php endif; ?>
                                <div class="col-md-6 pr-0 mt-2">
                                    <label>كيف كانت تجربتك في اختيار المقاس وفقًا لمخطط المنتج؟</label>
                                    <select name="size_checked" class="form-control">
                                        <option value="normal" <?php echo e(old('size_checked')=='normal'?'selected':''); ?>>الحجم الحقيقي</option>
                                        <option value="big" <?php echo e(old('size_checked')=='big'?'selected':''); ?>>كبير</option>
                                        <option value="small" <?php echo e(old('size_checked')=='small'?'selected':''); ?>>صغير</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if(auth()->user()->hasRole('User')): ?>
                        <div id="new-comment-blog" class="my-3">
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-md-6 pr-0">
                                        <label>Choosing a Product Model (for Hate the Product)</label>
                                        <select name="model_id" class="form-control">
                                            <?php $__currentLoopData = $item->models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $models): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($models->id); ?>" <?php echo e(old('model_id') == $models->id ? 'selected' : ''); ?>>
                                                    <?php echo e(read_lang($models,'type')); ?> (<?php echo e(read_lang($models,'type_val')); ?>)
                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-6 pr-0">
                                        <label>Photo Hate the Product(Max 3 Photo)</label>
                                        <input type="file" class="form-control" name="photos[]" multiple
                                               accept=".jpg,.png">
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div id="new-comment-blog" class="mt-3">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-md-12 pr-0 mt-2">
                            <textarea name="text" class="form-control" rows="3"
                                      placeholder="* What do You Think About This Product? Share With Others..."
                                      required><?php echo e(old('text')); ?></textarea>
                                </div>
                                <div class="col-md-12 pr-0 mt-2">
                                    <div class="my-4">
                                        <label class="form-label fw-bold h5">كود الكابتشا:</label>
                                        <img src="<?php echo e(url(captcha())); ?>" class="ms-2" alt="captcha">
                                        <input type="text" class="form-control mt-2" name="captcha" required>
                                    </div>
                                </div>
                                <div class="col-md-12 pr-0 mt-2">
                                    <div class="d-flex align-items-center justify-content-end pt-2">
                                        <button id="sendCommentBtn" type="submit" class="btn btn-digi btn-large"><i
                                                    class="fas fa-paper-plane"></i><span>إرسال تعليق</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            <?php else: ?>
                <div id="new-comment-blog">
                لإرسال تعليق
                    <a href="<?php echo e(route('login')); ?>" class="login-btn btn-text font-weight-bold">تسجيل الدخول</a> أو
                    <a class="btn-text font-weight-bold" href="<?php echo e(route('register')); ?>">يسجل</a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div><?php /**PATH /home/big49/public_html/back/source/resources/views/ar/front/product/includes/comment_single.blade.php ENDPATH**/ ?>