<!DOCTYPE html>
<html lang="<?php echo e(lang()); ?>" dir="<?php echo e($dir); ?>">

<head>
    <title><?php echo e($titleSeo); ?></title>
    <meta name="base_url" content="<?php echo e(url('/')); ?>">
    <meta name="description" content="<?php echo e($descriptionSeo); ?>"/>
    <meta name="keywords" content="<?php echo e($keywordsSeo); ?>">
    <link rel="canonical" href="<?php echo e($url); ?>"/>
    <meta property="og:locale" content="<?php echo e(og_locale()); ?>"/>
    <meta property="og:type" content="website"/>
    <meta property="og:title" content="<?php echo e($titleSeo); ?>"/>
    <meta property="og:description" content="<?php echo e($descriptionSeo); ?>"/>
    <meta property="og:url" content="<?php echo e($url); ?>"/>
    <meta property="og:image" content="<?php echo e(panel_icon()); ?>"/>
    <meta property="og:site_name" content="<?php echo e($titleSeo); ?>"/>
    <link rel="Shortcut Icon" type="image/x-icon" href="<?php echo e(panel_icon()); ?>"/>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php if($dir == 'rtl'): ?>
    <link href="<?php echo e(url('assets/css-rtl/bootstrap.rtl.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(url('assets/css-rtl/fancybox.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(url('assets/css-rtl/swiper-bundle.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(url('assets/font_awesome/css-rtl/all.min.css')); ?>" />
    <link rel='stylesheet' type='text/css' media='screen' href='<?php echo e(url('assets/css-rtl/styles.css')); ?>'>
    <?php endif; ?>
    <style>
        .max-h-75px
        {
            max-height: 75px;
        }

        body * {
            font-family: cario, sans-serif !important;
        }
        body {
            overflow-x: hidden;
        }
    </style>
    <?php echo $__env->yieldContent('styles'); ?>
</head>

<body>
    <!-- header -->
    <?php echo $__env->make('layouts.includes_front.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <!-- main -->

    <main>

      <?php echo $__env->yieldContent('content'); ?>

    </main>

    <!-- footer -->
    <?php echo $__env->make('layouts.includes_front.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script src="<?php echo e(url('assets/js/jquery-3.7.1.js')); ?>"></script>
    <script src="<?php echo e(url('assets/js/fancybox.umd.js')); ?>"></script>
    <script src="<?php echo e(url('assets/js/swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(url('assets/js/swiper.min.js')); ?>"></script>
    <script src="<?php echo e(url('assets/js/scrollreveal.min.js')); ?>"></script>
    <script src="<?php echo e(url('assets/js/scripts.js')); ?>"></script>
    <script src="<?php echo e(url('assets/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/sweetalert2.js')); ?>"></script>
    <script>
        <?php if(session()->has('err_message')): ?>

        $(document).ready(function () {
            Swal.fire({
                title: "Unsuccess",
                text: "<?php echo e(session('err_message')); ?>",
                icon: "warning",
                timer: 6000,
                timerProgressBar: true,
            })
        });
        <?php endif; ?>
        <?php if(session()->has('flash_message')): ?>
        $(document).ready(function () {
            Swal.fire({
                title: "Success",
                text: "<?php echo e(session('flash_message')); ?>",
                icon: "success",
                timer: 6000,
                timerProgressBar: true,
            })
        })
        ;<?php endif; ?>
        <?php if(isset($errors) && count($errors) > 0): ?>
        $(document).ready(function () {
            Swal.fire({
                title: "Unsuccess",
                icon: "warning",
                html:
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<p class="text-right mt-2 ml-5" dir="rtl"> <?php echo e($key+1); ?> : ' +
                        '<?php echo e($error); ?>' +
                        '</p>' +
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                '<p class="text-right mt-2 ml-5" dir="rtl">' +
                        '</p>',
                timer: parseInt('<?php echo e(count($errors)); ?>') * 6000,
                timerProgressBar: true,
            })
        });
        <?php endif; ?>
    </script>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html><?php /**PATH /home/big49/public_html/back/source/resources/views/ar/layouts/front.blade.php ENDPATH**/ ?>