<?php $__env->startSection('title',' Products'); ?>
<?php $__env->startSection('styles'); ?>
    <style>
        .loading_big {
            position: fixed;
            right: 0;
            top: 0;
            width: 100%;
            height: 100%;
            text-align: center;
            background: #66666670;
            z-index: 99;
        }

        .lds-ripple {
            display: inline-block;
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: 80px;
            height: 80px;
        }

        .lds-ripple div {
            position: absolute;
            border: 4px solid #fff;
            opacity: 1;
            border-radius: 50%;
            animation: lds-ripple 1s cubic-bezier(0, 0.2, 0.8, 1) infinite;
        }

        .lds-ripple div:nth-child(2) {
            animation-delay: -0.5s;
        }

        @keyframes lds-ripple {
            0% {
                top: 36px;
                left: 36px;
                width: 0;
                height: 0;
                opacity: 0;
            }
            4.9% {
                top: 36px;
                left: 36px;
                width: 0;
                height: 0;
                opacity: 0;
            }
            5% {
                top: 36px;
                left: 36px;
                width: 0;
                height: 0;
                opacity: 1;
            }
            100% {
                top: 0px;
                left: 0px;
                width: 72px;
                height: 72px;
                opacity: 0;
            }
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="loading_big d-none">
        <div class="lds-ripple">
            <div></div>
            <div></div>
        </div>
    </div>
    <!-- breadcrumb -->
    <section id="breadcrumb" class="container left my-4">
        <div class="d-flex align-items-center gap-2">
            <a href="<?php echo e(route('front.index')); ?>" class="transition primary-color fw-bold">بیت</a>
            <span>/</span>
            <span><?php echo e(!blank($category)?read_lang($category,'name'):'Products'); ?></span>
        </div>
    </section>

    <!-- tags -->

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

    <!-- filters -->

    <section id="filters" class="container-fluid my-5 overflow-visible">
        <div class="row">
            <div class="col-lg-3 left border-top pt-4">
                
                <div class="filter">
                    <?php if(count($cats)): ?>
                        <div>
                            <div class="d-flex cursor filter-btn fw-bold align-items-center justify-content-between">
                                <span class="h5 font-bold">فئة</span>
                                <span class="h4 plus">+</span>
                                <span class="h4 mines active">-</span>
                            </div>
                            <div class="filter-content active mt-3">
                                <?php $__currentLoopData = $cats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check mb-3">
                                        <input class="form-check-input" name="cats_filter[]"
                                               onclick="product_filter('cats_filter',<?php echo e($cat->id); ?>)" type="checkbox"
                                               value="<?php echo e($cat->id); ?>"
                                               <?php echo e(in_array($cat->id,$cats_filter)?'checked':''); ?> id="flexCheckChecked<?php echo e($cat->id); ?>">
                                        <label class="form-check-label" for="flexCheckChecked<?php echo e($cat->id); ?>">
                                            <?php echo e(read_lang($cat,'name')); ?>

                                        </label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="mt-2">
                        <div class="d-flex cursor filter-btn fw-bold align-items-center justify-content-between">
                            <span class="h5 font-bold">نوع</span>
                            <span class="h4 plus">+</span>
                            <span class="h4 mines active">-</span>
                        </div>
                        <div class="filter-content active mt-3">
                            <div class="form-check mb-3">
                                <input class="form-check-input" name="sort_filter"
                                       onclick="product_filter('sort_filter','new')" type="radio" value="new"
                                       <?php echo e($sort_filter=='new'?'checked':''); ?> id="flexCheckChecked_new">
                                <label class="form-check-label" for="flexCheckChecked_new">
                                الأحدث
                                </label>
                            </div>
                            <div class="form-check mb-3">
                                <input class="form-check-input" name="sort_filter"
                                       onclick="product_filter('sort_filter','seen')" type="radio" value="seen"
                                       <?php echo e($sort_filter=='seen'?'checked':''); ?> id="flexCheckChecked_seen">
                                <label class="form-check-label" for="flexCheckChecked_seen">
                                أكثر زيارة
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-9 top">
                <div class="container-fluid">
                    <div class="row g-4">
                        <?php if(count($items)): ?>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-xl-3 col-lg-4 col-md-6">
                                        <?php echo $__env->make('front.product.includes.card1',['item'=>$item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <div class="col-12">
                                <div class="pagination-area">
                                    <?php echo e($items->appends(Request::except('page'))->links("pagination::bootstrap-4")); ?>

                                </div>
                            </div>
                        <?php else: ?>
                            <div class="col-12 alert alert-danger text-center">
                            أكثر زيارة
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        var url = '<?php echo e(route('front.product.index.ajax',[$id,$slug])); ?>';
        var request_url = '';

        function product_filter(type, value) {
            $('.loading_big').removeClass('d-none')
            var checked = []
            var sort = $("input[name='sort_filter']:checked").val();

            $("input[name='cats_filter[]']:checked").each(function () {
                checked.push(parseInt($(this).val()));
            });
            request_url = '?sort_filter=' + sort + '&cats_filter=' + checked;
            var url_filter = '<?php echo e(route('front.product.index',[$id,$slug])); ?>' + request_url;
            $.get(url + request_url, function (data) {
                $('#filters').empty()
                $('#filters').append(data)
                window.history.pushState("object or string", "Title", url_filter);
                $('.loading_big').addClass('d-none')
            })
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/big49/public_html/back/source/resources/views/ar/front/product/index.blade.php ENDPATH**/ ?>