<?php



namespace App\Models;



use Illuminate\Database\Eloquent\Model;

use Illuminate\Support\Facades\File;



class Brand extends Model

{



    public  $timestamps = false;

    protected $guarded = ['id', 'created_at', 'updated_at'];



    public function products()

    {

        return $this->hasMany('App\Models\Product','brand_id','id');

    }

    public function photo()

    {

        return $this->morphOne('App\Models\Photo', 'pictures')->orderBy('created_at' , 'DESC');

    }


    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'category_id');
    }


    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if ($item->photo){
                if(is_file($item->photo->path))
                {
                    File::delete($item->photo->path);
                }
                $item->photo->delete();
            }
            foreach ($item->langs as $lang)
            {
                if($lang->type=='file')
                {
                    if(is_file($lang->text))
                    {
                        File::delete($lang->text);
                    }
                }
                $lang->delete();
            }
        });
    }

}

