<?php

namespace App\Models;

use Illuminate\Support\Facades\File;
use Illuminate\Database\Eloquent\Model;

class Comment extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */

    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function product()
    {
        return $this->hasOne('App\Models\Product','id','product_id');
    }
    public function choking()
    {
        return $this->hasOne('App\Models\ProductChoking','comment_id');
    }
    public function choking_photo()
    {
        return $this->hasOne('App\Models\ProductChoking','comment_id')->whereHas('photos')->where('status','active');
    }

    public function children()
    {
        return $this->hasMany('App\Models\Comment', 'reply_id')->with('children');
    }
    public static function size_check($type)
    {
        switch ($type)
        {
            case 'big':
                $res='بزرگتر بود';
                break;
            case 'normal':
                $res='اندازه بود';
                break;
            case 'small':
                $res='کوچکتر بود';
                break;
            default:
                $res='';
                break;
        }

        return $res;
    }
    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures');
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            $item->photo()->get()
                ->each(function ($photo) {
                    $path = $photo->path;
                    File::delete($path);
                    $photo->delete();
                });
        });
    }
}
