<?php

namespace App\Models;;

use Illuminate\Database\Eloquent\Model;

class Info_Contact extends Model
{
    protected $table='infocontact';
    public $timestamps=false;

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            foreach ($item->langs as $lang)
            {
                if($lang->type=='file')
                {
                    if(is_file($lang->text))
                    {
                        File::delete($lang->text);
                    }
                }
                $lang->delete();
            }
        });
    }
}
