<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\File;

class ModelSize extends Model
{

    public $timestamps = false;
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function model()
    {
        return $this->hasOne('App\Models\Modale', 'id', 'model_id');
    }


    public static function model_name()
    {
        return 'مدل سایز';
    }
    public static function sale_branch($size,$branch,$from_date,$to_date)
    {
        $baskets=PanelBasket::where('status','active')->where('size_id',$size->id)->where('draft_type',$branch);

        if($from_date!=null)
            $baskets=$baskets->whereDate('updated_at','>=',$from_date);

        if($to_date!=null)
            $baskets=$baskets->whereDate('updated_at','<=',$to_date);

        $basket_num=$baskets->sum('num');
        $basket_price=$baskets->sum('price');
        return [$basket_num,$basket_price];
    }
    public static function model_title($model)
    {
        $title=null;
        $size_name=$model->title;
        $model_name=null;
        $product_name=null;
        if($model->model){
            $model_name=$model->model->type_val;

            if($model->model->product)
            {
                $product_name=$model->model->product->title;
            }
        }
        if($product_name!=null)
        {
            $title.='محصول ';
            $title.=$product_name;
        }
        if($model_name!=null)
        {
            $title.=$title!=null?',':'';
            $title.='مدل ';
            $title.=$model_name;
        }
        if($size_name!=null)
        {
            $title.=$title!=null?',':'';
            $title.='سایز ';
            $title.=$size_name;
        }
        return $title;
    }
    public static function model_title2($model)
    {
        $title=null;
        $size_name=$model->title;
        $model_name=null;
        $product_name=null;
        if($model->model){
            $model_name=$model->model->type_val;

            if($model->model->product)
            {
                $product_name=$model->model->product->title;
            }
        }
        if($product_name!=null)
        {
            $title.='<p class="title" dir="rtl">';
            $title.='<span>'.$product_name.'</span>';
        }
        if($model_name!=null)
        {
            $title.=$title!=null?', ':'';
            $title.='<span>'.$model_name.'</span>';
        }
        if($size_name!=null)
        {
            $title.=$title!=null?', ':'';
            $title.='<span dir="ltr">'.$size_name.'</span>';
            $title.='</p>';
        }
        return $title;
    }
    public static function price_model($model)
    {
        $price=null;
        if($model->model){
            $model=$model->model;
            if((int)$model->price_vip>0 && $model->price_vip < $model->price)
            {
                $price=$model->price_vip;
            }
            else{
                $price=$model->price;
            }
        }

        return $price;
    }

}
