<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductSize extends Model
{
    use SoftDeletes;

    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function product()
    {
        return $this->belongsTo('App\Models\Product', 'product_id');
    }
    public function size_cat()
    {
        return $this->belongsTo('App\Models\SizeCat', 'size_cat_id');
    }
    public function size()
    {
        return $this->belongsTo('App\Models\Size', 'size_id');
    }
    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            foreach ($item->langs as $lang)
            {
                if($lang->type=='file')
                {
                    if(is_file($lang->text))
                    {
                        File::delete($lang->text);
                    }
                }
                $lang->delete();
            }
        });
    }
}
