@extends('layouts.front')

@section('title',' Blogs')

@section('content')
<!-- breadcrumb -->

<section id="breadcrumb" class="container left my-4">
    <div class="d-flex align-items-center gap-2">
      <a href="{{route('front.index')}}" class="transition primary-color fw-bold">بيت</a>
      <span>/</span>
      <span>مقالات</span>
    </div>
  </section>

    <!-- articles -->

    <section id="articles" class="mt-5 py-5 top">
       <div class="container">
           <div class="text-center">
               <span class="h3">
               المدونات
               </span>
               <h1 class="display-6 my-4 font-bold after d-table mx-auto">
               أحدث المدونات
               </h1>
           </div>
           <div class="row g-4 mt-5 text-center">
               @foreach($items as $item)
               <div class="col-xl-3 col-lg-4 col-md-6 p-2">
                  @include('front.blog.include.card',['item'=>$item])
               </div>
               @endforeach
             <div class="col-12">
               <div class="pagination-area">
                 {{$items->appends(Request::except('page'))->links("pagination::bootstrap-4")}}
               </div>
             </div>
           </div>
       </div>
   </section>
@endsection