@extends('layouts.front')
@section('title',' Products')
@section('styles')
    <style>
        .loading_big {
            position: fixed;
            right: 0;
            top: 0;
            width: 100%;
            height: 100%;
            text-align: center;
            background: #66666670;
            z-index: 99;
        }

        .lds-ripple {
            display: inline-block;
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: 80px;
            height: 80px;
        }

        .lds-ripple div {
            position: absolute;
            border: 4px solid #fff;
            opacity: 1;
            border-radius: 50%;
            animation: lds-ripple 1s cubic-bezier(0, 0.2, 0.8, 1) infinite;
        }

        .lds-ripple div:nth-child(2) {
            animation-delay: -0.5s;
        }

        @keyframes lds-ripple {
            0% {
                top: 36px;
                left: 36px;
                width: 0;
                height: 0;
                opacity: 0;
            }
            4.9% {
                top: 36px;
                left: 36px;
                width: 0;
                height: 0;
                opacity: 0;
            }
            5% {
                top: 36px;
                left: 36px;
                width: 0;
                height: 0;
                opacity: 1;
            }
            100% {
                top: 0px;
                left: 0px;
                width: 72px;
                height: 72px;
                opacity: 0;
            }
        }
    </style>
@endsection

@section('content')
    <div class="loading_big d-none">
        <div class="lds-ripple">
            <div></div>
            <div></div>
        </div>
    </div>
    <!-- breadcrumb -->
    <section id="breadcrumb" class="container left my-4">
        <div class="d-flex align-items-center gap-2">
            <a href="{{route('front.index')}}" class="transition primary-color fw-bold">بیت</a>
            <span>/</span>
            <span>{{!blank($category)?read_lang($category,'name'):'Products'}}</span>
        </div>
    </section>

    <!-- tags -->

    {{--<section id="tags" class="container top my-4 secondary-bg p-3">--}}
    {{--    <h3 class="fw-bold">Women Clothing</h3>--}}
    {{--    <div class="d-flex flex-wrap align-items-center gap-3 mt-4">--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">QuickShip</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">New</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">Top Rated</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">Dresses</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">Blouses</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">T-Shirts</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">Pants</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">Skirts</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">Tops</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">Leggings</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">Bodysuits</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">Jumpsuits</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">Two-piece Outfits</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">Knitwear</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">Sweatshirt</a>--}}
    {{--        <a class="bg-white py-1 px-2 border text-secondary">Denim</a>--}}
    {{--    </div>--}}
    {{--</section>--}}

    <!-- filters -->

    <section id="filters" class="container-fluid my-5 overflow-visible">
        <div class="row">
            <div class="col-lg-3 left border-top pt-4">
                {{--                <form action="{{route('front.product.index',[$id,$slug])}}" method="get" class="filter">--}}
                <div class="filter">
                    @if(count($cats))
                        <div>
                            <div class="d-flex cursor filter-btn fw-bold align-items-center justify-content-between">
                                <span class="h5 font-bold">فئة</span>
                                <span class="h4 plus">+</span>
                                <span class="h4 mines active">-</span>
                            </div>
                            <div class="filter-content active mt-3">
                                @foreach($cats as $cat)
                                    <div class="form-check mb-3">
                                        <input class="form-check-input" name="cats_filter[]"
                                               onclick="product_filter('cats_filter',{{$cat->id}})" type="checkbox"
                                               value="{{$cat->id}}"
                                               {{in_array($cat->id,$cats_filter)?'checked':''}} id="flexCheckChecked{{$cat->id}}">
                                        <label class="form-check-label" for="flexCheckChecked{{$cat->id}}">
                                            {{read_lang($cat,'name')}}
                                        </label>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif
                    <div class="mt-2">
                        <div class="d-flex cursor filter-btn fw-bold align-items-center justify-content-between">
                            <span class="h5 font-bold">نوع</span>
                            <span class="h4 plus">+</span>
                            <span class="h4 mines active">-</span>
                        </div>
                        <div class="filter-content active mt-3">
                            <div class="form-check mb-3">
                                <input class="form-check-input" name="sort_filter"
                                       onclick="product_filter('sort_filter','new')" type="radio" value="new"
                                       {{$sort_filter=='new'?'checked':''}} id="flexCheckChecked_new">
                                <label class="form-check-label" for="flexCheckChecked_new">
                                الأحدث
                                </label>
                            </div>
                            <div class="form-check mb-3">
                                <input class="form-check-input" name="sort_filter"
                                       onclick="product_filter('sort_filter','seen')" type="radio" value="seen"
                                       {{$sort_filter=='seen'?'checked':''}} id="flexCheckChecked_seen">
                                <label class="form-check-label" for="flexCheckChecked_seen">
                                أكثر زيارة
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-9 top">
                <div class="container-fluid">
                    <div class="row g-4">
                        @if(count($items))
                            @foreach($items as $item)
                                    <div class="col-xl-3 col-lg-4 col-md-6">
                                        @include('front.product.includes.card1',['item'=>$item])
                                    </div>
                            @endforeach

                            <div class="col-12">
                                <div class="pagination-area">
                                    {{$items->appends(Request::except('page'))->links("pagination::bootstrap-4")}}
                                </div>
                            </div>
                        @else
                            <div class="col-12 alert alert-danger text-center">
                            أكثر زيارة
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('scripts')
    <script>
        var url = '{{route('front.product.index.ajax',[$id,$slug])}}';
        var request_url = '';

        function product_filter(type, value) {
            $('.loading_big').removeClass('d-none')
            var checked = []
            var sort = $("input[name='sort_filter']:checked").val();

            $("input[name='cats_filter[]']:checked").each(function () {
                checked.push(parseInt($(this).val()));
            });
            request_url = '?sort_filter=' + sort + '&cats_filter=' + checked;
            var url_filter = '{{route('front.product.index',[$id,$slug])}}' + request_url;
            $.get(url + request_url, function (data) {
                $('#filters').empty()
                $('#filters').append(data)
                window.history.pushState("object or string", "Title", url_filter);
                $('.loading_big').addClass('d-none')
            })
        }
    </script>
@endsection