<!DOCTYPE html>
<html lang="{{lang()}}" dir="{{$dir}}">

<head>
    <title>{{$titleSeo}}</title>
    <meta name="base_url" content="{{url('/')}}">
    <meta name="description" content="{{$descriptionSeo}}"/>
    <meta name="keywords" content="{{$keywordsSeo}}">
    <link rel="canonical" href="{{$url}}"/>
    <meta property="og:locale" content="{{og_locale()}}"/>
    <meta property="og:type" content="website"/>
    <meta property="og:title" content="{{$titleSeo}}"/>
    <meta property="og:description" content="{{$descriptionSeo}}"/>
    <meta property="og:url" content="{{$url}}"/>
    <meta property="og:image" content="{{panel_icon()}}"/>
    <meta property="og:site_name" content="{{$titleSeo}}"/>
    <link rel="Shortcut Icon" type="image/x-icon" href="{{panel_icon()}}"/>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    @if($dir == 'rtl')
    <link href="{{url('assets/css-rtl/bootstrap.rtl.min.css')}}" rel="stylesheet">
    <link rel="stylesheet" href="{{url('assets/css-rtl/fancybox.css')}}" />
    <link rel="stylesheet" href="{{url('assets/css-rtl/swiper-bundle.min.css')}}" />
    <link rel="stylesheet" href="{{url('assets/font_awesome/css-rtl/all.min.css')}}" />
    <link rel='stylesheet' type='text/css' media='screen' href='{{url('assets/css-rtl/styles.css')}}'>
    @endif
    <style>
        .max-h-75px
        {
            max-height: 75px;
        }

        body * {
            font-family: cario, sans-serif !important;
        }
        body {
            overflow-x: hidden;
        }
    </style>
    @yield ('styles')
</head>

<body>
    <!-- header -->
    @include('layouts.includes_front.header')
    
    <!-- main -->

    <main>

      @yield('content')

    </main>

    <!-- footer -->
    @include('layouts.includes_front.footer')

    <script src="{{url('assets/js/jquery-3.7.1.js')}}"></script>
    <script src="{{url('assets/js/fancybox.umd.js')}}"></script>
    <script src="{{url('assets/js/swiper-bundle.min.js')}}"></script>
    <script src="{{url('assets/js/swiper.min.js')}}"></script>
    <script src="{{url('assets/js/scrollreveal.min.js')}}"></script>
    <script src="{{url('assets/js/scripts.js')}}"></script>
    <script src="{{url('assets/js/bootstrap.bundle.min.js')}}"></script>
    <script src="{{asset('assets/js/sweetalert2.js')}}"></script>
    <script>
        @if(session()->has('err_message'))

        $(document).ready(function () {
            Swal.fire({
                title: "Unsuccess",
                text: "{{ session('err_message') }}",
                icon: "warning",
                timer: 6000,
                timerProgressBar: true,
            })
        });
        @endif
        @if(session()->has('flash_message'))
        $(document).ready(function () {
            Swal.fire({
                title: "Success",
                text: "{{ session('flash_message') }}",
                icon: "success",
                timer: 6000,
                timerProgressBar: true,
            })
        })
        ;@endif
        @if (isset($errors) && count($errors) > 0)
        $(document).ready(function () {
            Swal.fire({
                title: "Unsuccess",
                icon: "warning",
                html:
                        @foreach ($errors->all() as $key => $error)
                                '<p class="text-right mt-2 ml-5" dir="rtl"> {{$key+1}} : ' +
                        '{{ $error }}' +
                        '</p>' +
                        @endforeach
                                '<p class="text-right mt-2 ml-5" dir="rtl">' +
                        '</p>',
                timer: parseInt('{{count($errors)}}') * 6000,
                timerProgressBar: true,
            })
        });
        @endif
    </script>
    @yield ('scripts')
</body>

</html>