@extends('layouts.front')

@section('title',  read_lang($item,'title'))

@section('content')
 <!-- breadcrumb -->

 <section id="breadcrumb" class="container left my-4">
    <div class="d-flex align-items-center gap-2">
      <a href="{{route('front.index')}}" class="transition primary-color fw-bold">Home</a>
      <span>/</span>
      <a href="{{route('front.blog.index')}}" class="transition primary-color fw-bold">Articles</a>
      <span>/</span>
      <span> {{read_lang($item,'title')}}</span>
    </div>
  </section>

  <!-- single service -->

  <section id="single-service" class="container over-v my-5 top">
   <div class="row g-4">
       <div class="col-lg-8">
           @if($item->photo && isFile(url_big($item->photo->path)))
           <div>
               <img alt="{{read_lang($item,'title')}}" src="{{url_big($item->photo->path)}}"
                   class="img-fluid">
           </div>
           @endif
           <h1 class="font-bold my-3">
               {{read_lang($item,'title')}}
           </h1>
            {!! read_lang($item,'text') !!}
       </div>
       <div class="col-lg-4">
           <div class="sticky_blog">
               <h2 class="font-bold">Recent Articles.</h2>
               <hr/>
               <div class="mt-4">
                   <section id="banner" class="position-relative top">
                       <!-- Swiper -->
                       <div>
                           <div class="swiper banner">
                               <div class="swiper-wrapper">
                                       @foreach($lasts as $last)
                                           <div class="swiper-slide">
                                               @include('front.blog.include.card',['item'=>$last])
                                           </div>
                                       @endforeach
                               </div>
                           </div>
                           <div class="swiper-button-next">
                           </div>
                           <div class="swiper-button-prev">
                           </div>
                       </div>
                   </section>
{{--                   <div class="mb-4">--}}
{{--                       <a class="d-block h4 cursor text-decoration-none transition fw-bold text-dark">The Evolving--}}
{{--                           Landscape of Oil and Gas Financing: Trends and Innovations</a>--}}
{{--                       <span class="primary-color fw-bold h5">February 23, 2023</span>--}}
{{--                   </div>--}}
               </div>
               <h3 class="font-bold mt-5 text-center text-lg-start">
                   Follow Us On
               </h3>
               <div
                   class="d-flex align-items-center justify-content-center justify-content-lg-start gap-2 mt-3 socials">
                   <a href="https://www.facebook.com/sharer/sharer.php?u={{route('front.blog.show',[read_lang($item,'slug'),$item->id])}}"
                       class="d-block primary-bg transition rounded-circle p-2 d-flex align-items-center justify-content-center">
                         <i class="fa-brands fa-facebook-f social_link text-white"></i>
                   </a>
                   <a href="https://twitter.com/share?text={{read_lang($item,'title')}}&url={{route('front.blog.show',[read_lang($item,'slug'),$item->id])}}"
                       class="d-block primary-bg transition rounded-circle p-2 d-flex align-items-center justify-content-center">
                     <i class="fa-brands fa-twitter social_link text-white"></i>
                   </a>
                   <a href="whatsapp://send?text={{route('front.blog.show',[read_lang($item,'slug'),$item->id])}}"
                       class="d-block primary-bg transition rounded-circle p-2 d-flex align-items-center justify-content-center">
                     <i class="fa-brands fa-whatsapp social_link text-white"></i>
                   </a>
                   <a href="https://telegram.me/share/url?url={{route('front.blog.show',[read_lang($item,'slug'),$item->id])}}&text={{read_lang($item,'title')}}"
                       class="d-block primary-bg transition rounded-circle p-2 d-flex align-items-center justify-content-center">
                     <i class="fa-brands fa-telegram social_link text-white"></i>
                   </a>
               </div>
           </div>
       </div>
   </div>
</section>
@endsection