@extends('layouts.front')

@section('title',' Profile')

@section('content')
    
<!-- account -->
@include('front.profile.includes.account.add-legal-modal')
@include('front.profile.includes.account.edit-name-modal')
@include('front.profile.includes.account.edit-phone-modal')
@include('front.profile.includes.account.edit-email-modal')
@include('front.profile.includes.account.edit-password-modal')
@include('front.profile.includes.account.return-money-modal')
@include('front.profile.includes.account.edit-birthday-modal')
@include('front.profile.includes.account.edit-job-modal')

<!-- address -->
@include('front.profile.includes.address.add-modal')
@include('front.profile.includes.address.edit-modal')
@include('front.profile.includes.address.delete-modal')

<!-- comment -->
@include('front.profile.includes.comment.delete-modal')
@include('front.profile.includes.comment.edit-modal')

<!-- notification -->
@include('front.profile.includes.notification.delete-modal')

<!-- my-list -->
@include('front.profile.includes.my-list.create-modal')
@include('front.profile.includes.my-list.share-modal')

        <!-- breadcrumb -->

        <section id="breadcrumb" class="container left my-4">
            <div class="d-flex align-items-center gap-2">
                <a href="{{route('front.index')}}" class="transition primary-color fw-bold">Home</a>
                <span>/</span>
                <span>Profile</span>
            </div>
        </section>

        <!-- profile -->

        <section id="profile" class="top container my-5">
            <div class="row g-4">
                <div class="col-xl-3">
                    <div class="border rounded-3">
                        <div class="p-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="position-relative">
                                        <div class="position-absolute linedot">
                                            <div class="profileLine bg-gray"></div>
                                            <div class="profileDot bg-gray"></div>
                                        </div>
                                        <img alt="profile" class="rounded-circle w-51" src="assets/img/fd4840b2.svg">
                                    </div>
                                    <div>
                                        <p class="font-bold h5">Yakoob Khedri</p>
                                        <span class="text-muted">09149492490</span>
                                    </div>
                                </div>
                                <a href="#accountDetails" class="d-block" id="AccountDetails" data-id="7">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor"
                                        class="bi bi-pencil-square text-primary cursor" viewBox="0 0 16 16">
                                        <path
                                            d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                                        <path fill-rule="evenodd"
                                            d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z" />
                                    </svg>
                                </a>
                            </div>
                            <div class="d-flex justify-content-between mt-4">
                                <div class="d-flex align-items-center gap-3 ms-5">
                                    <div>
                                        <p class="font-bold h6">Wallet</p>
                                        <a class="d-flex align-items-center gap-2 mt-2 text-primary cursor fw-bold">
                                            <span>Activation</span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd"
                                                    d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z" />
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                                <p class="fw-bold">
                                    2,000
                                    <span>$</span>
                                </p>
                            </div>
                        </div>
                        <!-- menu -->
                        <ul class="list-unstyled profileMenu mt-3">
                            <li data-id="1" class="px-3 active">
                                <a href="#summary" class="d-flex align-items-center border-top py-3 gap-3 cursor text-dark fw-bold">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                        class="bi bi-house" viewBox="0 0 16 16">
                                        <path
                                            d="M8.707 1.5a1 1 0 0 0-1.414 0L.646 8.146a.5.5 0 0 0 .708.708L2 8.207V13.5A1.5 1.5 0 0 0 3.5 15h9a1.5 1.5 0 0 0 1.5-1.5V8.207l.646.647a.5.5 0 0 0 .708-.708L13 5.793V2.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5v1.293L8.707 1.5ZM13 7.207V13.5a.5.5 0 0 1-.5.5h-9a.5.5 0 0 1-.5-.5V7.207l5-5 5 5Z" />
                                    </svg>
                                    Actions Summary
                                </a>
                            </li>
                            <li data-id="2" class="px-3">
                                <a href="#order" class="d-flex align-items-center border-top py-3 gap-3 cursor text-dark fw-bold">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                        class="bi bi-bag" viewBox="0 0 16 16">
                                        <path
                                            d="M8 1a2.5 2.5 0 0 1 2.5 2.5V4h-5v-.5A2.5 2.5 0 0 1 8 1zm3.5 3v-.5a3.5 3.5 0 1 0-7 0V4H1v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4h-3.5zM2 5h12v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V5z" />
                                    </svg>
                                    Orders
                                </a>
                            </li>
                            <li data-id="3" class="px-3">
                                <a href="#list" class="d-flex align-items-center border-top py-3 gap-3 cursor text-dark fw-bold">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                        class="bi bi-heart" viewBox="0 0 16 16">
                                        <path
                                            d="m8 2.748-.717-.737C5.6.281 2.514.878 1.4 3.053c-.523 1.023-.641 2.5.314 4.385.92 1.815 2.834 3.989 6.286 6.357 3.452-2.368 5.365-4.542 6.286-6.357.955-1.886.838-3.362.314-4.385C13.486.878 10.4.28 8.717 2.01L8 2.748zM8 15C-7.333 4.868 3.279-3.04 7.824 1.143c.06.055.119.112.176.171a3.12 3.12 0 0 1 .176-.17C12.72-3.042 23.333 4.867 8 15z" />
                                    </svg>
                                    My Lists
                                </a>
                            </li>
                            <li data-id="4" class="px-3">
                                <a href="#comment" class="d-flex align-items-center border-top py-3 gap-3 cursor text-dark fw-bold">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                        class="bi bi-chat" viewBox="0 0 16 16">
                                        <path
                                            d="M2.678 11.894a1 1 0 0 1 .287.801 10.97 10.97 0 0 1-.398 2c1.395-.323 2.247-.697 2.634-.893a1 1 0 0 1 .71-.074A8.06 8.06 0 0 0 8 14c3.996 0 7-2.807 7-6 0-3.192-3.004-6-7-6S1 4.808 1 8c0 1.468.617 2.83 1.678 3.894zm-.493 3.905a21.682 21.682 0 0 1-.713.129c-.2.032-.352-.176-.273-.362a9.68 9.68 0 0 0 .244-.637l.003-.01c.248-.72.45-1.548.524-2.319C.743 11.37 0 9.76 0 8c0-3.866 3.582-7 8-7s8 3.134 8 7-3.582 7-8 7a9.06 9.06 0 0 1-2.347-.306c-.52.263-1.639.742-3.468 1.105z" />
                                    </svg>
                                    Comments
                                </a>
                            </li>
                            <li data-id="5" class="px-3">
                                <a href="#address" class="d-flex align-items-center border-top py-3 gap-3 cursor text-dark fw-bold">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                        class="bi bi-pin-map" viewBox="0 0 16 16">
                                        <path fill-rule="evenodd"
                                            d="M3.1 11.2a.5.5 0 0 1 .4-.2H6a.5.5 0 0 1 0 1H3.75L1.5 15h13l-2.25-3H10a.5.5 0 0 1 0-1h2.5a.5.5 0 0 1 .4.2l3 4a.5.5 0 0 1-.4.8H.5a.5.5 0 0 1-.4-.8l3-4z" />
                                        <path fill-rule="evenodd"
                                            d="M8 1a3 3 0 1 0 0 6 3 3 0 0 0 0-6zM4 4a4 4 0 1 1 4.5 3.969V13.5a.5.5 0 0 1-1 0V7.97A4 4 0 0 1 4 3.999z" />
                                    </svg>
                                    Addresses
                                </a>
                            </li>
                            <li data-id="6" class="px-3">
                                <a href="#notification" class="d-flex align-items-center border-top py-3 gap-3 cursor text-dark fw-bold">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                        class="bi bi-bell" viewBox="0 0 16 16">
                                        <path
                                            d="M8 16a2 2 0 0 0 2-2H6a2 2 0 0 0 2 2zM8 1.918l-.797.161A4.002 4.002 0 0 0 4 6c0 .628-.134 2.197-.459 3.742-.16.767-.376 1.566-.663 2.258h10.244c-.287-.692-.502-1.49-.663-2.258C12.134 8.197 12 6.628 12 6a4.002 4.002 0 0 0-3.203-3.92L8 1.917zM14.22 12c.223.447.481.801.78 1H1c.299-.199.557-.553.78-1C2.68 10.2 3 6.88 3 6c0-2.42 1.72-4.44 4.005-4.901a1 1 0 1 1 1.99 0A5.002 5.002 0 0 1 13 6c0 .88.32 4.2 1.22 6z" />
                                    </svg>
                                    Notifications
                                </a>
                            </li>
                            <li data-id="7" class="px-3">
                                <a href="#accountDetails" class="d-flex align-items-center border-top py-3 gap-3 cursor text-dark fw-bold">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                        class="bi bi-person" viewBox="0 0 16 16">
                                        <path
                                            d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6Zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4Zm-1-.004c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10Z" />
                                    </svg>
                                    Account Details
                                </a>
                            </li>
                            <li class="px-3">
                                <a class="d-flex align-items-center border-top py-3 gap-3 cursor text-dark fw-bold">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                        class="bi bi-box-arrow-left" viewBox="0 0 16 16">
                                        <path fill-rule="evenodd"
                                            d="M6 12.5a.5.5 0 0 0 .5.5h8a.5.5 0 0 0 .5-.5v-9a.5.5 0 0 0-.5-.5h-8a.5.5 0 0 0-.5.5v2a.5.5 0 0 1-1 0v-2A1.5 1.5 0 0 1 6.5 2h8A1.5 1.5 0 0 1 16 3.5v9a1.5 1.5 0 0 1-1.5 1.5h-8A1.5 1.5 0 0 1 5 12.5v-2a.5.5 0 0 1 1 0v2z" />
                                        <path fill-rule="evenodd"
                                            d="M.146 8.354a.5.5 0 0 1 0-.708l3-3a.5.5 0 1 1 .708.708L1.707 7.5H10.5a.5.5 0 0 1 0 1H1.707l2.147 2.146a.5.5 0 0 1-.708.708l-3-3z" />
                                    </svg>
                                    Logout
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-9 profileMenuContent">
                    <!-- summary -->
                    <div data-id="1" id="summary">
                        <div class="border rounded-3 flex-wrap gap-2 d-flex align-items-center justify-content-between p-3">
                            <div class="text-warning d-flex align-items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                    class="bi bi-info-circle-fill flex-shrink-0" viewBox="0 0 16 16">
                                    <path
                                        d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16zm.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2z" />
                                </svg>
                                <small class="fw-bold">By verifying your identity, you can increase the security of your
                                    account and use the possibility of "credit purchase".</small>
                            </div>
                            <a class="d-flex align-items-center gap-1 fw-bold">
                                Identity Verifying
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                    class="bi bi-chevron-right" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd"
                                        d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z" />
                                </svg>
                            </a>
                        </div>
                        <div class="border rounded-3 py-4 px-3 mt-3">
                            <div class="d-flex align-items-center justify-content-between ">
                                <div class="d-flex align-items-center gap-2">
                                    <h5 class="font-bold after">My Orders</h5>
                                </div>
                                <a class="d-flex align-items-center gap-1 fw-bold">
                                    View All
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                        class="bi bi-chevron-right" viewBox="0 0 16 16">
                                        <path fill-rule="evenodd"
                                            d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z" />
                                    </svg>
                                </a>
                            </div>
                            <div class="d-flex myorders gap-2 align-items-center justify-content-between mt-5">
                                <a class="d-flex align-items-center gap-3 text-dark fw-bold">
                                    <img alt="order" src="assets/img/status-processing.svg">
                                    <div>
                                        <p class="h4"><span>0</span> Order</p>
                                        <p class="text-muted">Current</p>
                                    </div>
                                </a>
                                <a class="d-flex align-items-center gap-3 text-dark fw-bold">
                                    <img alt="order" src="assets/img/status-delivered.svg">
                                    <div>
                                        <p class="h4"><span>1</span> Order</p>
                                        <p class="text-muted">Delivered</p>
                                    </div>
                                </a>
                                <a class="d-flex align-items-center gap-3 text-dark fw-bold me-5">
                                    <img alt="order" src="assets/img/status-returned.svg">
                                    <div>
                                        <p class="h4"><span>0</span> Order</p>
                                        <p class="text-muted">Returned</p>
                                    </div>
                                </a>
                            </div>
                        </div>
                        <div class="border rounded-3 py-4 px-3 mt-3">
                            <div class="d-flex align-items-center justify-content-between ">
                                <div class="d-flex align-items-center gap-2">
                                    <h5 class="font-bold after">My Lists</h5>
                                </div>
                                <a class="d-flex align-items-center gap-1 fw-bold">
                                    View All
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                        class="bi bi-chevron-right" viewBox="0 0 16 16">
                                        <path fill-rule="evenodd"
                                            d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z" />
                                    </svg>
                                </a>
                            </div>
                            <div class="row g-4 mt-5">
                                <div class="col-xl-3 col-lg-4 col-md-6">
                                    <div>
                                        <div class="overflow-hidden position-relative img-box">
                                            <img class="position-absolute img-fluid bottom-0"
                                                src="assets/img/16536223422bed59fb6e900c29c9e5086a5839371b.png">
                                            <img alt="product"
                                                src="assets/img/168326325973dd6fcc6e1af93f2a7be03cdc9d3030_thumbnail_600x.jpg"
                                                class="img-fluid transition">
                                        </div>
                                        <div class="p-2">
                                            <a href="single-product.html"
                                                class="h6 primary-color transition fw-bold text-truncate">SHEIN LUNE
                                                Floral Print
                                                Tee</a>
                                            <div
                                                class="d-flex align-items-center gap-1 alert alert-success award fw-bold mt-1 p-1">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="currentColor" class="bi bi-patch-check-fill"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M10.067.87a2.89 2.89 0 0 0-4.134 0l-.622.638-.89-.011a2.89 2.89 0 0 0-2.924 2.924l.01.89-.636.622a2.89 2.89 0 0 0 0 4.134l.637.622-.011.89a2.89 2.89 0 0 0 2.924 2.924l.89-.01.622.636a2.89 2.89 0 0 0 4.134 0l.622-.637.89.011a2.89 2.89 0 0 0 2.924-2.924l-.01-.89.636-.622a2.89 2.89 0 0 0 0-4.134l-.637-.622.011-.89a2.89 2.89 0 0 0-2.924-2.924l-.89.01-.622-.636zm.287 5.984-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7 8.793l2.646-2.647a.5.5 0 0 1 .708.708z" />
                                                </svg>
                                                <p class="text-truncate">1 in store</p>
                                            </div>
                                            <div class="d-flex align-items-center justify-content-between mt-1">
                                                <span class="font-bold h5">$5.49</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-3 col-lg-4 col-md-6">
                                    <div>
                                        <div class="overflow-hidden position-relative img-box">
                                            <img class="position-absolute img-fluid bottom-0"
                                                src="assets/img/16536223422bed59fb6e900c29c9e5086a5839371b.png">
                                            <img alt="product"
                                                src="assets/img/168326325973dd6fcc6e1af93f2a7be03cdc9d3030_thumbnail_600x.jpg"
                                                class="img-fluid transition">
                                        </div>
                                        <div class="p-2">
                                            <a href="single-product.html"
                                                class="h6 primary-color transition fw-bold text-truncate">SHEIN LUNE
                                                Floral Print
                                                Tee</a>
                                            <div
                                                class="d-flex align-items-center gap-1 alert alert-success award fw-bold mt-1 p-1">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="currentColor" class="bi bi-patch-check-fill"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M10.067.87a2.89 2.89 0 0 0-4.134 0l-.622.638-.89-.011a2.89 2.89 0 0 0-2.924 2.924l.01.89-.636.622a2.89 2.89 0 0 0 0 4.134l.637.622-.011.89a2.89 2.89 0 0 0 2.924 2.924l.89-.01.622.636a2.89 2.89 0 0 0 4.134 0l.622-.637.89.011a2.89 2.89 0 0 0 2.924-2.924l-.01-.89.636-.622a2.89 2.89 0 0 0 0-4.134l-.637-.622.011-.89a2.89 2.89 0 0 0-2.924-2.924l-.89.01-.622-.636zm.287 5.984-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7 8.793l2.646-2.647a.5.5 0 0 1 .708.708z" />
                                                </svg>
                                                <p class="text-truncate">1 in store</p>
                                            </div>
                                            <div class="d-flex align-items-center justify-content-between mt-1">
                                                <span class="font-bold h5">$5.49</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- order -->
                    <div data-id="2" id="order">
                        <div class="border rounded-3 py-4 px-3">
                            <div class="d-flex align-items-center justify-content-between ">
                                <div class="d-flex align-items-center gap-2">
                                    <h5 class="font-bold after">Order History</h5>
                                </div>
                                <div class="d-flex align-items-center gap-1 fw-bold cursor">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor"
                                        class="bi bi-search" viewBox="0 0 16 16">
                                        <path
                                            d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z" />
                                    </svg>
                                </div>
                            </div>
                            <div class="d-flex flex-wrap align-items-center gap-5 mt-5 border-bottom pb-3">
                                <div data-id="1" class="d-flex align-items-center gap-1 cursor orderTab active">
                                    <p class="text-secondary fw-bold">Current</p>
                                    <span class="d-block ms-1 bg-gray rounded-3 text-white fw-bold px-2">2</span>
                                </div>
                                <div data-id="2" class="d-flex align-items-center gap-1 cursor orderTab">
                                    <p class="text-secondary fw-bold">Delivered</p>
                                    <span class="d-block ms-1 bg-gray rounded-3 text-white fw-bold px-2">0</span>
                                </div>
                                <div data-id="3" class="d-flex align-items-center gap-1 cursor orderTab">
                                    <p class="text-secondary fw-bold">Returned</p>
                                    <span class="d-block ms-1 bg-gray rounded-3 text-white fw-bold px-2">2</span>
                                </div>
                                <div data-id="4" class="d-flex align-items-center gap-1 cursor orderTab">
                                    <p class="text-secondary fw-bold">Canceled</p>
                                    <span class="d-block ms-1 bg-gray rounded-3 text-white fw-bold px-2">0</span>
                                </div>
                            </div>
                            <div class="orderContent">
                                <div data-id="1">
                                    <div class="border d-block rounded-3 p-3 my-3">
                                        <a class="d-flex align-items-center justify-content-between">
                                            <div class="d-flex align-items-center gap-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                    fill="currentColor" class="bi bi-check-circle-fill text-success"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z" />
                                                </svg>
                                                <span class="text-dark fw-bold">Current</span>
                                            </div>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                fill="currentColor" class="bi bi-chevron-right text-dark"
                                                viewBox="0 0 16 16">
                                                <path fill-rule="evenodd"
                                                    d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z" />
                                            </svg>
                                        </a>
                                        <div class="d-flex flex-wrap fw-bold align-items-center gap-md-5 gap-2 mt-4">
                                            <span class="text-dark">23 Apr 2023</span>
                                            <p class="text-muted">Code: <span class="text-dark">2374336</span></p>
                                            <p class="text-muted">Amount: <span class="text-dark">24 $</span></p>
                                        </div>
                                        <img alt="current" src="assets/img/woman-clothing-happy.png"
                                            class="img-fluid w-200 my-3">
                                        <a class="d-block border-top pt-3 text-center text-md-end">View the invoice</a>
                                    </div>
                                    <div class="border d-block rounded-3 p-3 my-3">
                                        <a class="d-flex align-items-center justify-content-between">
                                            <div class="d-flex align-items-center gap-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                    fill="currentColor" class="bi bi-check-circle-fill text-success"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z" />
                                                </svg>
                                                <span class="text-dark fw-bold">Current</span>
                                            </div>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                fill="currentColor" class="bi bi-chevron-right text-dark"
                                                viewBox="0 0 16 16">
                                                <path fill-rule="evenodd"
                                                    d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z" />
                                            </svg>
                                        </a>
                                        <div class="d-flex flex-wrap fw-bold align-items-center gap-md-5 gap-2 mt-4">
                                            <span class="text-dark">23 Apr 2023</span>
                                            <p class="text-muted">Code: <span class="text-dark">2374336</span></p>
                                            <p class="text-muted">Amount: <span class="text-dark">24 $</span></p>
                                        </div>
                                        <img alt="current" src="assets/img/woman-clothing-happy.png"
                                            class="img-fluid w-200 my-3">
                                            <a class="d-block border-top pt-3 text-center text-md-end">View the invoice</a>
                                    </div>
                                </div>
                                <div data-id="2">
                                    <!-- empty -->
                                    <div class="my-5 py-5 text-center fw-bold">
                                        <img alt="empty" src="assets/img/order-empty.svg" class="d-block mx-auto">
                                        <p>You have no order yet</p>
                                    </div>
                                </div>
                                <div data-id="3">
                                    <div class="border d-block rounded-3 p-3 my-3">
                                        <a class="d-flex align-items-center justify-content-between">
                                            <div class="d-flex align-items-center gap-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                    fill="currentColor" class="bi bi-check-circle-fill text-success"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z" />
                                                </svg>
                                                <span class="text-dark fw-bold">Current</span>
                                            </div>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                fill="currentColor" class="bi bi-chevron-right text-dark"
                                                viewBox="0 0 16 16">
                                                <path fill-rule="evenodd"
                                                    d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z" />
                                            </svg>
                                        </a>
                                        <div class="d-flex flex-wrap fw-bold align-items-center gap-md-5 gap-2 mt-4">
                                            <span class="text-dark">23 Apr 2023</span>
                                            <p class="text-muted">Code: <span class="text-dark">2374336</span></p>
                                            <p class="text-muted">Amount: <span class="text-dark">24 $</span></p>
                                        </div>
                                        <img alt="current" src="assets/img/woman-clothing-happy.png"
                                            class="img-fluid w-200 my-3">
                                            <a class="d-block border-top pt-3 text-center text-md-end">View the invoice</a>
                                    </div>
                                    <div class="border d-block rounded-3 p-3 my-3">
                                        <a class="d-flex align-items-center justify-content-between">
                                            <div class="d-flex align-items-center gap-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                    fill="currentColor" class="bi bi-check-circle-fill text-success"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z" />
                                                </svg>
                                                <span class="text-dark fw-bold">Current</span>
                                            </div>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                fill="currentColor" class="bi bi-chevron-right text-dark"
                                                viewBox="0 0 16 16">
                                                <path fill-rule="evenodd"
                                                    d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z" />
                                            </svg>
                                        </a>
                                        <div class="d-flex flex-wrap fw-bold align-items-center gap-md-5 gap-2 mt-4">
                                            <span class="text-dark">23 Apr 2023</span>
                                            <p class="text-muted">Code: <span class="text-dark">2374336</span></p>
                                            <p class="text-muted">Amount: <span class="text-dark">24 $</span></p>
                                        </div>
                                        <img alt="current" src="assets/img/woman-clothing-happy.png"
                                            class="img-fluid w-200 my-3">
                                            <a class="d-block border-top pt-3 text-center text-md-end">View the invoice</a>
                                    </div>
                                </div>
                                <div data-id="4">
                                    <!-- empty -->
                                    <div class="my-5 py-5 text-center fw-bold">
                                        <img alt="empty" src="assets/img/order-empty.svg" class="d-block mx-auto">
                                        <p>You have no order yet</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- list -->
                    <div data-id="3" id="list">
                        <div class="border rounded-3 py-4 px-3">
                            <div class="d-flex align-items-center justify-content-between ">
                                <div class="d-flex align-items-center gap-2">
                                    <h5 class="font-bold after">Lists</h5>
                                </div>
                            </div>
                            <div class="d-flex flex-wrap align-items-center gap-5 mt-5 border-bottom pb-3">
                                <div data-id="1" class="d-flex align-items-center gap-1 cursor listTab active">
                                    <p class="text-secondary fw-bold">Favorite List</p>
                                </div>
                                <div data-id="2" class="d-flex align-items-center gap-1 cursor listTab">
                                    <p class="text-secondary fw-bold">Public List</p>
                                </div>
                                <div data-id="3" class="d-flex align-items-center gap-1 cursor listTab">
                                    <p class="text-secondary fw-bold">Notifications</p>
                                </div>
                            </div>
                            <div class="listTabContent">
                                <!-- Favorite List -->
                                <div data-id="1">
                                    <div class="border row g-4 rounded-3 p-3 mx-1 my-3">
                                        <div class="col-lg-6">
                                            <div class="border">
                                                <div class="overflow-hidden position-relative img-box"
                                                    style="max-height: 410px;">
                                                    <img class="position-absolute img-fluid bottom-0"
                                                        src="assets/img/16536223422bed59fb6e900c29c9e5086a5839371b.png">
                                                    <img alt="product"
                                                        src="assets/img/168326325973dd6fcc6e1af93f2a7be03cdc9d3030_thumbnail_600x.jpg"
                                                        class="img-fluid transition">
                                                </div>
                                                <div class="p-2">
                                                    <a href="single-product.html"
                                                        class="h6 primary-color transition fw-bold text-truncate">SHEIN
                                                        LUNE Floral Print
                                                        Tee</a>
                                                    <div class="d-flex align-items-center justify-content-between mt-1">
                                                        <span class="font-bold h5">$5.49</span>
                                                        <img alt="sale-icon" src="assets/img/cart.svg"
                                                            class="img-fluid cursor">
                                                    </div>
                                                    <div
                                                        class="remove-list mt-3 bg-danger w-100 cursor text-white text-center py-1">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                            fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                                            <path
                                                                d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z" />
                                                        </svg>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="border">
                                                <div class="overflow-hidden position-relative img-box"
                                                    style="max-height: 410px;">
                                                    <img class="position-absolute img-fluid bottom-0"
                                                        src="assets/img/16536223422bed59fb6e900c29c9e5086a5839371b.png">
                                                    <img alt="product"
                                                        src="assets/img/168326325973dd6fcc6e1af93f2a7be03cdc9d3030_thumbnail_600x.jpg"
                                                        class="img-fluid transition">
                                                </div>
                                                <div class="p-2">
                                                    <a href="single-product.html"
                                                        class="h6 primary-color transition fw-bold text-truncate">SHEIN
                                                        LUNE Floral Print
                                                        Tee</a>
                                                    <div class="d-flex align-items-center justify-content-between mt-1">
                                                        <span class="font-bold h5">$5.49</span>
                                                        <img alt="sale-icon" src="assets/img/cart.svg"
                                                            class="img-fluid cursor">
                                                    </div>
                                                    <div
                                                        class="remove-list mt-3 bg-danger w-100 cursor text-white text-center py-1">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                            fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                                            <path
                                                                d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z" />
                                                        </svg>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="border">
                                                <div class="overflow-hidden position-relative img-box"
                                                    style="max-height: 410px;">
                                                    <img class="position-absolute img-fluid bottom-0"
                                                        src="assets/img/16536223422bed59fb6e900c29c9e5086a5839371b.png">
                                                    <img alt="product"
                                                        src="assets/img/168326325973dd6fcc6e1af93f2a7be03cdc9d3030_thumbnail_600x.jpg"
                                                        class="img-fluid transition">
                                                </div>
                                                <div class="p-2">
                                                    <a href="single-product.html"
                                                        class="h6 primary-color transition fw-bold text-truncate">SHEIN
                                                        LUNE Floral Print
                                                        Tee</a>
                                                    <div class="d-flex align-items-center justify-content-between mt-1">
                                                        <span class="font-bold h5">$5.49</span>
                                                        <img alt="sale-icon" src="assets/img/cart.svg"
                                                            class="img-fluid cursor">
                                                    </div>
                                                    <div
                                                        class="remove-list mt-3 bg-danger w-100 cursor text-white text-center py-1">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                            fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                                            <path
                                                                d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z" />
                                                        </svg>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Public List -->
                                <div data-id="2">
                                    <div
                                        class="d-flex flex-wrap gap-2 align-items-center justify-content-between mt-4 border-bottom pb-4">
                                        <p class="fw-bold text-center text-md-start">Here you can make different lists of your favorite products
                                            and recommend them to others.</p>
                                        <a data-bs-toggle="modal" data-bs-target="#creatListModal"
                                            class="btn btn-danger mx-auto text-white fw-bold">
                                            + Create List
                                        </a>
                                    </div>
                                    <div class="row g-4 mt-3">
                                        <div class="col-lg-6">
                                            <div class="border rounded-3 p-3">
                                                <p class="fw-bold mb-3">Clothes</p>
                                                <p class="text-muted">Clothes</p>
                                                <div
                                                    class="d-flex align-items-center justify-content-center gap-1 px-3 py-1 mt-3 secondary-bg rounded-3">
                                                    <img class="w-51" alt="list" src="assets/img/wish-list.svg">
                                                    <p>This list is empty!</p>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between mt-3">
                                                    <a data-bs-toggle="modal" data-bs-target="#ShareModal" class="btn btn-outline-danger">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                            fill="currentColor" class="bi me-3 bi-share-fill"
                                                            viewBox="0 0 16 16">
                                                            <path
                                                                d="M11 2.5a2.5 2.5 0 1 1 .603 1.628l-6.718 3.12a2.499 2.499 0 0 1 0 1.504l6.718 3.12a2.5 2.5 0 1 1-.488.876l-6.718-3.12a2.5 2.5 0 1 1 0-3.256l6.718-3.12A2.5 2.5 0 0 1 11 2.5z" />
                                                        </svg>
                                                        Share
                                                    </a>
                                                    <a class="d-flex align-items-center gap-1">
                                                        View And Edit
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                            fill="currentColor" class="bi bi-chevron-right"
                                                            viewBox="0 0 16 16">
                                                            <path fill-rule="evenodd"
                                                                d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z" />
                                                        </svg>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="border rounded-3 p-3">
                                                <p class="fw-bold mb-3">Clothes</p>
                                                <p class="text-muted">Clothes</p>
                                                <div
                                                    class="d-flex align-items-center justify-content-center gap-1 px-3 py-1 mt-3 secondary-bg rounded-3">
                                                    <img class="w-51" alt="list" src="assets/img/wish-list.svg">
                                                    <p>This list is empty!</p>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between mt-3">
                                                    <a data-bs-toggle="modal" data-bs-target="#ShareModal" class="btn btn-outline-danger">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                            fill="currentColor" class="bi me-3 bi-share-fill"
                                                            viewBox="0 0 16 16">
                                                            <path
                                                                d="M11 2.5a2.5 2.5 0 1 1 .603 1.628l-6.718 3.12a2.499 2.499 0 0 1 0 1.504l6.718 3.12a2.5 2.5 0 1 1-.488.876l-6.718-3.12a2.5 2.5 0 1 1 0-3.256l6.718-3.12A2.5 2.5 0 0 1 11 2.5z" />
                                                        </svg>
                                                        Share
                                                    </a>
                                                    <a class="d-flex align-items-center gap-1">
                                                        View And Edit
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                            fill="currentColor" class="bi bi-chevron-right"
                                                            viewBox="0 0 16 16">
                                                            <path fill-rule="evenodd"
                                                                d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z" />
                                                        </svg>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- notifications -->
                                <div data-id="3">
                                    <div>
                                        <div class="text-center my-5 py-5">
                                            <img alt="notifications" class="d-block mx-auto"
                                                src="assets/img/announcements-list-empty.svg">
                                            <p class="fw-bold">Your notification list is empty.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- comments -->
                    <div data-id="4" id="comment">
                        <div class="border rounded-3 py-4 px-3">
                            <div class="d-flex align-items-center justify-content-between ">
                                <div class="d-flex align-items-center gap-2">
                                    <h5 class="font-bold after">Comments</h5>
                                </div>
                            </div>
                            <div class="d-flex flex-wrap align-items-center gap-5 mt-5 border-bottom pb-3">
                                <div data-id="1" class="d-flex align-items-center gap-1 cursor commentTab active">
                                    <p class="text-secondary fw-bold">Waiting for comments</p>
                                </div>
                                <div data-id="2" class="d-flex align-items-center gap-1 cursor commentTab">
                                    <p class="text-secondary fw-bold">My Comments</p>
                                </div>
                            </div>
                            <div class="commentContent">
                                <!-- Waiting for comments -->
                                <div data-id="1">
                                    <div class="border d-block rounded-3 p-3 my-3">
                                        <div
                                            class="d-flex align-items-center justify-content-between border-bottom pb-3">
                                            <div class="d-flex align-items-center gap-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                    fill="currentColor" class="bi bi-megaphone text-success"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M13 2.5a1.5 1.5 0 0 1 3 0v11a1.5 1.5 0 0 1-3 0v-.214c-2.162-1.241-4.49-1.843-6.912-2.083l.405 2.712A1 1 0 0 1 5.51 15.1h-.548a1 1 0 0 1-.916-.599l-1.85-3.49a68.14 68.14 0 0 0-.202-.003A2.014 2.014 0 0 1 0 9V7a2.02 2.02 0 0 1 1.992-2.013 74.663 74.663 0 0 0 2.483-.075c3.043-.154 6.148-.849 8.525-2.199V2.5zm1 0v11a.5.5 0 0 0 1 0v-11a.5.5 0 0 0-1 0zm-1 1.35c-2.344 1.205-5.209 1.842-8 2.033v4.233c.18.01.359.022.537.036 2.568.189 5.093.744 7.463 1.993V3.85zm-9 6.215v-4.13a95.09 95.09 0 0 1-1.992.052A1.02 1.02 0 0 0 1 7v2c0 .55.448 1.002 1.006 1.009A60.49 60.49 0 0 1 4 10.065zm-.657.975 1.609 3.037.01.024h.548l-.002-.014-.443-2.966a68.019 68.019 0 0 0-1.722-.082z" />
                                                </svg>
                                                <span class="text-dark fw-bold">Great</span>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <p class="btn btn-warning fs-7 fw-bold text-white rounded-pill">Awaiting
                                                    confirmation</p>
                                                <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown"
                                                    role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                        fill="currentColor"
                                                        class="bi bi-three-dots-vertical cursor text-dark"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                                    </svg>
                                                </a>
                                                <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                                    <li>
                                                        <a data-bs-toggle="modal" data-bs-target="#editCommentModal" class="dropdown-item d-flex align-items-center gap-2"
                                                            >
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                                height="18" fill="currentColor"
                                                                class="bi bi-pencil-square text-dark cursor"
                                                                viewBox="0 0 16 16">
                                                                <path
                                                                    d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                                                </path>
                                                                <path fill-rule="evenodd"
                                                                    d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z">
                                                                </path>
                                                            </svg>
                                                            Edit Comment
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a data-bs-toggle="modal" data-bs-target="#deleteCommentModal" class="dropdown-item d-flex align-items-center gap-2"
                                                            >
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                                height="18" fill="currentColor"
                                                                class="bi bi-trash text-danger" viewBox="0 0 16 16">
                                                                <path
                                                                    d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6Z" />
                                                                <path
                                                                    d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1ZM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118ZM2.5 3h11V2h-11v1Z" />
                                                            </svg>
                                                            Remove Comment
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="d-flex fw-bold align-items-center text-success gap-1 mt-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-hand-thumbs-up" viewBox="0 0 16 16">
                                                <path
                                                    d="M8.864.046C7.908-.193 7.02.53 6.956 1.466c-.072 1.051-.23 2.016-.428 2.59-.125.36-.479 1.013-1.04 1.639-.557.623-1.282 1.178-2.131 1.41C2.685 7.288 2 7.87 2 8.72v4.001c0 .845.682 1.464 1.448 1.545 1.07.114 1.564.415 2.068.723l.048.03c.272.165.578.348.97.484.397.136.861.217 1.466.217h3.5c.937 0 1.599-.477 1.934-1.064a1.86 1.86 0 0 0 .254-.912c0-.152-.023-.312-.077-.464.201-.263.38-.578.488-.901.11-.33.172-.762.004-1.149.069-.13.12-.269.159-.403.077-.27.113-.568.113-.857 0-.288-.036-.585-.113-.856a2.144 2.144 0 0 0-.138-.362 1.9 1.9 0 0 0 .234-1.734c-.206-.592-.682-1.1-1.2-1.272-.847-.282-1.803-.276-2.516-.211a9.84 9.84 0 0 0-.443.05 9.365 9.365 0 0 0-.062-4.509A1.38 1.38 0 0 0 9.125.111L8.864.046zM11.5 14.721H8c-.51 0-.863-.069-1.14-.164-.281-.097-.506-.228-.776-.393l-.04-.024c-.555-.339-1.198-.731-2.49-.868-.333-.036-.554-.29-.554-.55V8.72c0-.254.226-.543.62-.65 1.095-.3 1.977-.996 2.614-1.708.635-.71 1.064-1.475 1.238-1.978.243-.7.407-1.768.482-2.85.025-.362.36-.594.667-.518l.262.066c.16.04.258.143.288.255a8.34 8.34 0 0 1-.145 4.725.5.5 0 0 0 .595.644l.003-.001.014-.003.058-.014a8.908 8.908 0 0 1 1.036-.157c.663-.06 1.457-.054 2.11.164.175.058.45.3.57.65.107.308.087.67-.266 1.022l-.353.353.353.354c.043.043.105.141.154.315.048.167.075.37.075.581 0 .212-.027.414-.075.582-.05.174-.111.272-.154.315l-.353.353.353.354c.047.047.109.177.005.488a2.224 2.224 0 0 1-.505.805l-.353.353.353.354c.006.005.041.05.041.17a.866.866 0 0 1-.121.416c-.165.288-.503.56-1.066.56z" />
                                            </svg>
                                            <p class="fw-bold">I recommend buying this product</p>
                                        </div>
                                        <p class="fw-bold mt-5 border-bottom pb-2">It's Perfect</p>
                                        <img alt="current" src="assets/img/woman-clothing-happy.png"
                                            class="img-fluid w-200 my-3">
                                        <div class="d-flex align-items-center gap-3">
                                            <div class="d-flex align-items-center gap-2 fw-bold">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="currentColor" class="bi bi-houses" viewBox="0 0 16 16">
                                                    <path
                                                        d="M5.793 1a1 1 0 0 1 1.414 0l.647.646a.5.5 0 1 1-.708.708L6.5 1.707 2 6.207V12.5a.5.5 0 0 0 .5.5.5.5 0 0 1 0 1A1.5 1.5 0 0 1 1 12.5V7.207l-.146.147a.5.5 0 0 1-.708-.708L5.793 1Zm3 1a1 1 0 0 1 1.414 0L12 3.793V2.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v3.293l1.854 1.853a.5.5 0 0 1-.708.708L15 8.207V13.5a1.5 1.5 0 0 1-1.5 1.5h-8A1.5 1.5 0 0 1 4 13.5V8.207l-.146.147a.5.5 0 1 1-.708-.708L8.793 2Zm.707.707L5 7.207V13.5a.5.5 0 0 0 .5.5h8a.5.5 0 0 0 .5-.5V7.207l-4.5-4.5Z" />
                                                </svg>
                                                <span class="fs-7">Nilz Company</span>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="w-20 h-20 bg-danger rounded-circle"></div>
                                                <p class="fs-7 fw-bold">red</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border d-block rounded-3 p-3 my-3">
                                        <div
                                            class="d-flex align-items-center justify-content-between border-bottom pb-3">
                                            <div class="d-flex align-items-center gap-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                    fill="currentColor" class="bi bi-megaphone text-success"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M13 2.5a1.5 1.5 0 0 1 3 0v11a1.5 1.5 0 0 1-3 0v-.214c-2.162-1.241-4.49-1.843-6.912-2.083l.405 2.712A1 1 0 0 1 5.51 15.1h-.548a1 1 0 0 1-.916-.599l-1.85-3.49a68.14 68.14 0 0 0-.202-.003A2.014 2.014 0 0 1 0 9V7a2.02 2.02 0 0 1 1.992-2.013 74.663 74.663 0 0 0 2.483-.075c3.043-.154 6.148-.849 8.525-2.199V2.5zm1 0v11a.5.5 0 0 0 1 0v-11a.5.5 0 0 0-1 0zm-1 1.35c-2.344 1.205-5.209 1.842-8 2.033v4.233c.18.01.359.022.537.036 2.568.189 5.093.744 7.463 1.993V3.85zm-9 6.215v-4.13a95.09 95.09 0 0 1-1.992.052A1.02 1.02 0 0 0 1 7v2c0 .55.448 1.002 1.006 1.009A60.49 60.49 0 0 1 4 10.065zm-.657.975 1.609 3.037.01.024h.548l-.002-.014-.443-2.966a68.019 68.019 0 0 0-1.722-.082z" />
                                                </svg>
                                                <span class="text-dark fw-bold">Great</span>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <p class="btn btn-warning fs-7 fw-bold text-white rounded-pill">Awaiting
                                                    confirmation</p>
                                                <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown"
                                                    role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                        fill="currentColor"
                                                        class="bi bi-three-dots-vertical cursor text-dark"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                                    </svg>
                                                </a>
                                                <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                                    <li>
                                                        <a data-bs-toggle="modal" data-bs-target="#editCommentModal" class="dropdown-item d-flex align-items-center gap-2"
                                                            >
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                                height="18" fill="currentColor"
                                                                class="bi bi-pencil-square text-dark cursor"
                                                                viewBox="0 0 16 16">
                                                                <path
                                                                    d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                                                </path>
                                                                <path fill-rule="evenodd"
                                                                    d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z">
                                                                </path>
                                                            </svg>
                                                            Edit Comment
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a data-bs-toggle="modal" data-bs-target="#deleteCommentModal" class="dropdown-item d-flex align-items-center gap-2"
                                                            >
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                                height="18" fill="currentColor"
                                                                class="bi bi-trash text-danger" viewBox="0 0 16 16">
                                                                <path
                                                                    d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6Z" />
                                                                <path
                                                                    d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1ZM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118ZM2.5 3h11V2h-11v1Z" />
                                                            </svg>
                                                            Remove Comment
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="d-flex fw-bold align-items-center text-success gap-1 mt-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-hand-thumbs-up" viewBox="0 0 16 16">
                                                <path
                                                    d="M8.864.046C7.908-.193 7.02.53 6.956 1.466c-.072 1.051-.23 2.016-.428 2.59-.125.36-.479 1.013-1.04 1.639-.557.623-1.282 1.178-2.131 1.41C2.685 7.288 2 7.87 2 8.72v4.001c0 .845.682 1.464 1.448 1.545 1.07.114 1.564.415 2.068.723l.048.03c.272.165.578.348.97.484.397.136.861.217 1.466.217h3.5c.937 0 1.599-.477 1.934-1.064a1.86 1.86 0 0 0 .254-.912c0-.152-.023-.312-.077-.464.201-.263.38-.578.488-.901.11-.33.172-.762.004-1.149.069-.13.12-.269.159-.403.077-.27.113-.568.113-.857 0-.288-.036-.585-.113-.856a2.144 2.144 0 0 0-.138-.362 1.9 1.9 0 0 0 .234-1.734c-.206-.592-.682-1.1-1.2-1.272-.847-.282-1.803-.276-2.516-.211a9.84 9.84 0 0 0-.443.05 9.365 9.365 0 0 0-.062-4.509A1.38 1.38 0 0 0 9.125.111L8.864.046zM11.5 14.721H8c-.51 0-.863-.069-1.14-.164-.281-.097-.506-.228-.776-.393l-.04-.024c-.555-.339-1.198-.731-2.49-.868-.333-.036-.554-.29-.554-.55V8.72c0-.254.226-.543.62-.65 1.095-.3 1.977-.996 2.614-1.708.635-.71 1.064-1.475 1.238-1.978.243-.7.407-1.768.482-2.85.025-.362.36-.594.667-.518l.262.066c.16.04.258.143.288.255a8.34 8.34 0 0 1-.145 4.725.5.5 0 0 0 .595.644l.003-.001.014-.003.058-.014a8.908 8.908 0 0 1 1.036-.157c.663-.06 1.457-.054 2.11.164.175.058.45.3.57.65.107.308.087.67-.266 1.022l-.353.353.353.354c.043.043.105.141.154.315.048.167.075.37.075.581 0 .212-.027.414-.075.582-.05.174-.111.272-.154.315l-.353.353.353.354c.047.047.109.177.005.488a2.224 2.224 0 0 1-.505.805l-.353.353.353.354c.006.005.041.05.041.17a.866.866 0 0 1-.121.416c-.165.288-.503.56-1.066.56z" />
                                            </svg>
                                            <p class="fw-bold">I recommend buying this product</p>
                                        </div>
                                        <p class="fw-bold mt-5 border-bottom pb-2">It's Perfect</p>
                                        <img alt="current" src="assets/img/woman-clothing-happy.png"
                                            class="img-fluid w-200 my-3">
                                        <div class="d-flex align-items-center gap-3">
                                            <div class="d-flex align-items-center gap-2 fw-bold">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="currentColor" class="bi bi-houses" viewBox="0 0 16 16">
                                                    <path
                                                        d="M5.793 1a1 1 0 0 1 1.414 0l.647.646a.5.5 0 1 1-.708.708L6.5 1.707 2 6.207V12.5a.5.5 0 0 0 .5.5.5.5 0 0 1 0 1A1.5 1.5 0 0 1 1 12.5V7.207l-.146.147a.5.5 0 0 1-.708-.708L5.793 1Zm3 1a1 1 0 0 1 1.414 0L12 3.793V2.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v3.293l1.854 1.853a.5.5 0 0 1-.708.708L15 8.207V13.5a1.5 1.5 0 0 1-1.5 1.5h-8A1.5 1.5 0 0 1 4 13.5V8.207l-.146.147a.5.5 0 1 1-.708-.708L8.793 2Zm.707.707L5 7.207V13.5a.5.5 0 0 0 .5.5h8a.5.5 0 0 0 .5-.5V7.207l-4.5-4.5Z" />
                                                </svg>
                                                <span class="fs-7">Nilz Company</span>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="w-20 h-20 bg-danger rounded-circle"></div>
                                                <p class="fs-7 fw-bold">red</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- my comments -->
                                <div data-id="2">
                                    <div class="border d-block rounded-3 p-3 my-3">
                                        <div
                                            class="d-flex align-items-center justify-content-between border-bottom pb-3">
                                            <div class="d-flex align-items-center gap-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                                    fill="currentColor" class="bi bi-megaphone text-success"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M13 2.5a1.5 1.5 0 0 1 3 0v11a1.5 1.5 0 0 1-3 0v-.214c-2.162-1.241-4.49-1.843-6.912-2.083l.405 2.712A1 1 0 0 1 5.51 15.1h-.548a1 1 0 0 1-.916-.599l-1.85-3.49a68.14 68.14 0 0 0-.202-.003A2.014 2.014 0 0 1 0 9V7a2.02 2.02 0 0 1 1.992-2.013 74.663 74.663 0 0 0 2.483-.075c3.043-.154 6.148-.849 8.525-2.199V2.5zm1 0v11a.5.5 0 0 0 1 0v-11a.5.5 0 0 0-1 0zm-1 1.35c-2.344 1.205-5.209 1.842-8 2.033v4.233c.18.01.359.022.537.036 2.568.189 5.093.744 7.463 1.993V3.85zm-9 6.215v-4.13a95.09 95.09 0 0 1-1.992.052A1.02 1.02 0 0 0 1 7v2c0 .55.448 1.002 1.006 1.009A60.49 60.49 0 0 1 4 10.065zm-.657.975 1.609 3.037.01.024h.548l-.002-.014-.443-2.966a68.019 68.019 0 0 0-1.722-.082z" />
                                                </svg>
                                                <span class="text-dark fw-bold">Great</span>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <p class="btn btn-success fs-7 fw-bold text-white rounded-pill">
                                                    confirmed</p>
                                                <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown"
                                                    role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                        fill="currentColor"
                                                        class="bi bi-three-dots-vertical cursor text-dark"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                                    </svg>
                                                </a>
                                                <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                                    <li>
                                                        <a data-bs-toggle="modal" data-bs-target="#editCommentModal" class="dropdown-item d-flex align-items-center gap-2"
                                                            >
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                                height="18" fill="currentColor"
                                                                class="bi bi-pencil-square text-dark cursor"
                                                                viewBox="0 0 16 16">
                                                                <path
                                                                    d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                                                </path>
                                                                <path fill-rule="evenodd"
                                                                    d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z">
                                                                </path>
                                                            </svg>
                                                            Edit Comment
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a data-bs-toggle="modal" data-bs-target="#deleteCommentModal" class="dropdown-item d-flex align-items-center gap-2"
                                                            >
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                                height="18" fill="currentColor"
                                                                class="bi bi-trash text-danger" viewBox="0 0 16 16">
                                                                <path
                                                                    d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6Z" />
                                                                <path
                                                                    d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1ZM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118ZM2.5 3h11V2h-11v1Z" />
                                                            </svg>
                                                            Remove Comment
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="d-flex fw-bold align-items-center text-success gap-1 mt-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-hand-thumbs-up" viewBox="0 0 16 16">
                                                <path
                                                    d="M8.864.046C7.908-.193 7.02.53 6.956 1.466c-.072 1.051-.23 2.016-.428 2.59-.125.36-.479 1.013-1.04 1.639-.557.623-1.282 1.178-2.131 1.41C2.685 7.288 2 7.87 2 8.72v4.001c0 .845.682 1.464 1.448 1.545 1.07.114 1.564.415 2.068.723l.048.03c.272.165.578.348.97.484.397.136.861.217 1.466.217h3.5c.937 0 1.599-.477 1.934-1.064a1.86 1.86 0 0 0 .254-.912c0-.152-.023-.312-.077-.464.201-.263.38-.578.488-.901.11-.33.172-.762.004-1.149.069-.13.12-.269.159-.403.077-.27.113-.568.113-.857 0-.288-.036-.585-.113-.856a2.144 2.144 0 0 0-.138-.362 1.9 1.9 0 0 0 .234-1.734c-.206-.592-.682-1.1-1.2-1.272-.847-.282-1.803-.276-2.516-.211a9.84 9.84 0 0 0-.443.05 9.365 9.365 0 0 0-.062-4.509A1.38 1.38 0 0 0 9.125.111L8.864.046zM11.5 14.721H8c-.51 0-.863-.069-1.14-.164-.281-.097-.506-.228-.776-.393l-.04-.024c-.555-.339-1.198-.731-2.49-.868-.333-.036-.554-.29-.554-.55V8.72c0-.254.226-.543.62-.65 1.095-.3 1.977-.996 2.614-1.708.635-.71 1.064-1.475 1.238-1.978.243-.7.407-1.768.482-2.85.025-.362.36-.594.667-.518l.262.066c.16.04.258.143.288.255a8.34 8.34 0 0 1-.145 4.725.5.5 0 0 0 .595.644l.003-.001.014-.003.058-.014a8.908 8.908 0 0 1 1.036-.157c.663-.06 1.457-.054 2.11.164.175.058.45.3.57.65.107.308.087.67-.266 1.022l-.353.353.353.354c.043.043.105.141.154.315.048.167.075.37.075.581 0 .212-.027.414-.075.582-.05.174-.111.272-.154.315l-.353.353.353.354c.047.047.109.177.005.488a2.224 2.224 0 0 1-.505.805l-.353.353.353.354c.006.005.041.05.041.17a.866.866 0 0 1-.121.416c-.165.288-.503.56-1.066.56z" />
                                            </svg>
                                            <p class="fw-bold">I recommend buying this product</p>
                                        </div>
                                        <p class="fw-bold mt-5 border-bottom pb-2">It's Perfect</p>
                                        <img alt="current" src="assets/img/woman-clothing-happy.png"
                                            class="img-fluid w-200 my-3">
                                        <div class="d-flex align-items-center gap-3">
                                            <div class="d-flex align-items-center gap-2 fw-bold">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="currentColor" class="bi bi-houses" viewBox="0 0 16 16">
                                                    <path
                                                        d="M5.793 1a1 1 0 0 1 1.414 0l.647.646a.5.5 0 1 1-.708.708L6.5 1.707 2 6.207V12.5a.5.5 0 0 0 .5.5.5.5 0 0 1 0 1A1.5 1.5 0 0 1 1 12.5V7.207l-.146.147a.5.5 0 0 1-.708-.708L5.793 1Zm3 1a1 1 0 0 1 1.414 0L12 3.793V2.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v3.293l1.854 1.853a.5.5 0 0 1-.708.708L15 8.207V13.5a1.5 1.5 0 0 1-1.5 1.5h-8A1.5 1.5 0 0 1 4 13.5V8.207l-.146.147a.5.5 0 1 1-.708-.708L8.793 2Zm.707.707L5 7.207V13.5a.5.5 0 0 0 .5.5h8a.5.5 0 0 0 .5-.5V7.207l-4.5-4.5Z" />
                                                </svg>
                                                <span class="fs-7">Nilz Company</span>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="w-20 h-20 bg-danger rounded-circle"></div>
                                                <p class="fs-7 fw-bold">red</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="empty text-center fw-bold">
                                        <div class="my-5 py-5">
                                            <img alt="empty" src="assets/img/order-empty.svg" class="d-block mx-auto">
                                            <p>You have no comments yet</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Addresses -->
                    <div data-id="5" id="address">
                        <div class="border rounded-3 py-4 px-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <h5 class="font-bold after">Addresses</h5>
                                <a class="btn btn-outline-danger fw-bold" data-bs-toggle="modal"
                                    data-bs-target="#addAddressModal">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                        class="bi bi-geo-alt me-1" viewBox="0 0 16 16">
                                        <path
                                            d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A31.493 31.493 0 0 1 8 14.58a31.481 31.481 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94zM8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10z" />
                                        <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4zm0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6z" />
                                    </svg>
                                    Add New Address
                                </a>
                            </div>
                            <div>
                                <!-- address -->
                                <div class="mt-5">
                                    <div class="border rounded-3 p-3 mb-3">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <p class="fw-bold">Urmia,meysam st,No 3</p>
                                            <div>
                                                <a class="nav-link dropdown-toggle pe-0" href="#" id="navbarDropdown"
                                                    role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                        fill="currentColor"
                                                        class="bi bi-three-dots-vertical cursor text-dark"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                                    </svg>
                                                </a>
                                                <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                                    <li data-bs-toggle="modal" data-bs-target="#editAddressModal">
                                                        <a class="dropdown-item d-flex align-items-center gap-2"
                                                          >
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                                height="18" fill="currentColor"
                                                                class="bi bi-pencil-square text-dark cursor"
                                                                viewBox="0 0 16 16">
                                                                <path
                                                                    d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                                                </path>
                                                                <path fill-rule="evenodd"
                                                                    d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z">
                                                                </path>
                                                            </svg>
                                                            Edit Address
                                                        </a>
                                                    </li>
                                                    <li data-bs-toggle="modal" data-bs-target="#deleteAddressModal">
                                                        <a class="dropdown-item d-flex align-items-center gap-2"
                                                            >
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                                height="18" fill="currentColor"
                                                                class="bi bi-trash text-danger" viewBox="0 0 16 16">
                                                                <path
                                                                    d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6Z" />
                                                                <path
                                                                    d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1ZM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118ZM2.5 3h11V2h-11v1Z" />
                                                            </svg>
                                                            Remove Address
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="d-flex flex-column flex-sm-row justify-content-between mt-3">
                                            <div>
                                                <p class="text-muted fw-bold mb-3 h6">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17"
                                                        fill="currentColor" class="bi me-2 bi-geo-alt me-1"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A31.493 31.493 0 0 1 8 14.58a31.481 31.481 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94zM8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10z">
                                                        </path>
                                                        <path
                                                            d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4zm0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6z">
                                                        </path>
                                                    </svg>
                                                    Urmia
                                                </p>
                                                <p class="text-muted fw-bold mb-3 h6">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17"
                                                        fill="currentColor" class="bi me-2 bi-envelope"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4Zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1H2Zm13 2.383-4.708 2.825L15 11.105V5.383Zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741ZM1 11.105l4.708-2.897L1 5.383v5.722Z" />
                                                    </svg>
                                                    571985643
                                                </p>
                                                <p class="text-muted fw-bold mb-3 h6">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17"
                                                        fill="currentColor" class="bi me-2 bi-telephone"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.568 17.568 0 0 0 4.168 6.608 17.569 17.569 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.678.678 0 0 0-.58-.122l-2.19.547a1.745 1.745 0 0 1-1.657-.459L5.482 8.062a1.745 1.745 0 0 1-.46-1.657l.548-2.19a.678.678 0 0 0-.122-.58L3.654 1.328zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z" />
                                                    </svg>
                                                    09149492490
                                                </p>
                                                <p class="text-muted fw-bold mb-3 h6">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17"
                                                        fill="currentColor" class="bi me-2 bi-person"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6Zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4Zm-1-.004c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10Z" />
                                                    </svg>
                                                    Yakoob Khedri
                                                </p>
                                            </div>
                                            <div>
                                                <iframe
                                                    src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d317893.1993960357!2d-0.119554!3d51.503297!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x487604b900d26973%3A0x4291f3172409ea92!2slastminute.com%20London%20Eye!5e0!3m2!1sen!2sus!4v1688062817990!5m2!1sen!2sus"
                                                    height="200" width="220" style="border:0;" allowfullscreen=""
                                                    loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border rounded-3 p-3 mb-3">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <p class="fw-bold">Urmia,meysam st,No 3</p>
                                            <div>
                                                <a class="nav-link dropdown-toggle pe-0" href="#" id="navbarDropdown"
                                                    role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                        fill="currentColor"
                                                        class="bi bi-three-dots-vertical cursor text-dark"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                                    </svg>
                                                </a>
                                                <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                                    <li data-bs-toggle="modal" data-bs-target="#editAddressModal">
                                                        <a class="dropdown-item d-flex align-items-center gap-2"
                                                            >
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                                height="18" fill="currentColor"
                                                                class="bi bi-pencil-square text-dark cursor"
                                                                viewBox="0 0 16 16">
                                                                <path
                                                                    d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                                                </path>
                                                                <path fill-rule="evenodd"
                                                                    d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z">
                                                                </path>
                                                            </svg>
                                                            Edit Address
                                                        </a>
                                                    </li>
                                                    <li data-bs-toggle="modal" data-bs-target="#deleteAddressModal">
                                                        <a class="dropdown-item d-flex align-items-center gap-2"
                                                            >
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                                height="18" fill="currentColor"
                                                                class="bi bi-trash text-danger" viewBox="0 0 16 16">
                                                                <path
                                                                    d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6Z" />
                                                                <path
                                                                    d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1ZM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118ZM2.5 3h11V2h-11v1Z" />
                                                            </svg>
                                                            Remove Address
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="d-flex flex-column flex-sm-row justify-content-between mt-3">
                                            <div>
                                                <p class="text-muted fw-bold mb-3 h6">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17"
                                                        fill="currentColor" class="bi me-2 bi-geo-alt me-1"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A31.493 31.493 0 0 1 8 14.58a31.481 31.481 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94zM8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10z">
                                                        </path>
                                                        <path
                                                            d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4zm0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6z">
                                                        </path>
                                                    </svg>
                                                    Urmia
                                                </p>
                                                <p class="text-muted fw-bold mb-3 h6">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17"
                                                        fill="currentColor" class="bi me-2 bi-envelope"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4Zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1H2Zm13 2.383-4.708 2.825L15 11.105V5.383Zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741ZM1 11.105l4.708-2.897L1 5.383v5.722Z" />
                                                    </svg>
                                                    571985643
                                                </p>
                                                <p class="text-muted fw-bold mb-3 h6">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17"
                                                        fill="currentColor" class="bi me-2 bi-telephone"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.568 17.568 0 0 0 4.168 6.608 17.569 17.569 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.678.678 0 0 0-.58-.122l-2.19.547a1.745 1.745 0 0 1-1.657-.459L5.482 8.062a1.745 1.745 0 0 1-.46-1.657l.548-2.19a.678.678 0 0 0-.122-.58L3.654 1.328zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z" />
                                                    </svg>
                                                    09149492490
                                                </p>
                                                <p class="text-muted fw-bold mb-3 h6">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17"
                                                        fill="currentColor" class="bi me-2 bi-person"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6Zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4Zm-1-.004c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10Z" />
                                                    </svg>
                                                    Yakoob Khedri
                                                </p>
                                            </div>
                                            <div>
                                                <iframe
                                                    src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d317893.1993960357!2d-0.119554!3d51.503297!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x487604b900d26973%3A0x4291f3172409ea92!2slastminute.com%20London%20Eye!5e0!3m2!1sen!2sus!4v1688062817990!5m2!1sen!2sus"
                                                    height="200" width="220" style="border:0;" allowfullscreen=""
                                                    loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- empty -->
                                    <div class="empty text-center fw-bold">
                                        <div class="my-5 py-5">
                                            <img alt="empty" src="assets/img/order-empty.svg" class="d-block mx-auto">
                                            <p>You have no address yet</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- notifications -->
                    <div data-id="6" id="notification">
                        <div class="border rounded-3 py-4 px-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <h5 class="font-bold after">notifications</h5>
                                <a class="text-primary fw-bold" data-bs-toggle="modal"
                                    data-bs-target="#deleteNotifModal">Delete All Notifications</a>
                            </div>
                            <div>
                                <div class="mt-5">
                                    <!-- notification -->
                                    <div>
                                        <div class="d-flex align-items-center gap-3 notifTabs">
                                            <span data-id="1" class="border rounded-pill px-3 py-1 cursor active">All
                                                messages</span>
                                            <span data-id="2"
                                                class="border rounded-pill px-3 py-1 cursor">Notifications</span>
                                        </div>
                                        <div class="notifTabsContent">
                                            <div data-id="1">
                                                <div class="row g-3 my-4 border rounded-3 py-3 mx-2">
                                                    <div class="col-md-8">
                                                        <div class="d-flex align-items-center gap-2">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24"
                                                                height="24" fill="currentColor"
                                                                class="bi bi-megaphone bg-warning text-white p-1 rounded-circle"
                                                                viewBox="0 0 16 16">
                                                                <path
                                                                    d="M13 2.5a1.5 1.5 0 0 1 3 0v11a1.5 1.5 0 0 1-3 0v-.214c-2.162-1.241-4.49-1.843-6.912-2.083l.405 2.712A1 1 0 0 1 5.51 15.1h-.548a1 1 0 0 1-.916-.599l-1.85-3.49a68.14 68.14 0 0 0-.202-.003A2.014 2.014 0 0 1 0 9V7a2.02 2.02 0 0 1 1.992-2.013 74.663 74.663 0 0 0 2.483-.075c3.043-.154 6.148-.849 8.525-2.199V2.5zm1 0v11a.5.5 0 0 0 1 0v-11a.5.5 0 0 0-1 0zm-1 1.35c-2.344 1.205-5.209 1.842-8 2.033v4.233c.18.01.359.022.537.036 2.568.189 5.093.744 7.463 1.993V3.85zm-9 6.215v-4.13a95.09 95.09 0 0 1-1.992.052A1.02 1.02 0 0 0 1 7v2c0 .55.448 1.002 1.006 1.009A60.49 60.49 0 0 1 4 10.065zm-.657.975 1.609 3.037.01.024h.548l-.002-.014-.443-2.966a68.019 68.019 0 0 0-1.722-.082z" />
                                                            </svg>
                                                            <span class="fw-bold">It's time to get points</span>
                                                        </div>
                                                        <p class="text-muted fw-bold mt-2">Your Digiclub points are
                                                            ready to receive. Get them before they expire</p>
                                                        <a class="d-flex align-items-center gap-2 mt-2 fw-bold">
                                                            Get points
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                                height="14" fill="currentColor"
                                                                class="bi bi-chevron-right" viewBox="0 0 16 16">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <span
                                                            class="bg-primary rounded-circle p-1 ms-auto w-3 h-3 d-sm-block d-none"></span>
                                                        <p class="text-secondary fw-bold text-center text-sm-end mt-5">23 july, 2023
                                                        </p>
                                                    </div>
                                                </div>
                                                <div class="row g-3 my-4 border rounded-3 py-3 mx-2">
                                                    <div class="col-md-8">
                                                        <div class="d-flex align-items-center gap-2">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24"
                                                                height="24" fill="currentColor"
                                                                class="bi bi-megaphone bg-warning text-white p-1 rounded-circle"
                                                                viewBox="0 0 16 16">
                                                                <path
                                                                    d="M13 2.5a1.5 1.5 0 0 1 3 0v11a1.5 1.5 0 0 1-3 0v-.214c-2.162-1.241-4.49-1.843-6.912-2.083l.405 2.712A1 1 0 0 1 5.51 15.1h-.548a1 1 0 0 1-.916-.599l-1.85-3.49a68.14 68.14 0 0 0-.202-.003A2.014 2.014 0 0 1 0 9V7a2.02 2.02 0 0 1 1.992-2.013 74.663 74.663 0 0 0 2.483-.075c3.043-.154 6.148-.849 8.525-2.199V2.5zm1 0v11a.5.5 0 0 0 1 0v-11a.5.5 0 0 0-1 0zm-1 1.35c-2.344 1.205-5.209 1.842-8 2.033v4.233c.18.01.359.022.537.036 2.568.189 5.093.744 7.463 1.993V3.85zm-9 6.215v-4.13a95.09 95.09 0 0 1-1.992.052A1.02 1.02 0 0 0 1 7v2c0 .55.448 1.002 1.006 1.009A60.49 60.49 0 0 1 4 10.065zm-.657.975 1.609 3.037.01.024h.548l-.002-.014-.443-2.966a68.019 68.019 0 0 0-1.722-.082z" />
                                                            </svg>
                                                            <span class="fw-bold">It's time to get points</span>
                                                        </div>
                                                        <p class="text-muted fw-bold mt-2">Your Digiclub points are
                                                            ready to receive. Get them before they expire</p>
                                                        <a class="d-flex align-items-center gap-2 mt-2 fw-bold">
                                                            Get points
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                                height="14" fill="currentColor"
                                                                class="bi bi-chevron-right" viewBox="0 0 16 16">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <span
                                                            class="bg-primary rounded-circle p-1 ms-auto w-3 h-3 d-sm-block d-none"></span>
                                                        <p class="text-secondary fw-bold text-center text-sm-end mt-5">23 july, 2023
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div data-id="2">
                                                <div class="row g-3 my-4 border rounded-3 py-3 mx-2">
                                                    <div class="col-md-8">
                                                        <div class="d-flex align-items-center gap-2">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24"
                                                                height="24" fill="currentColor"
                                                                class="bi bi-megaphone bg-warning text-white p-1 rounded-circle"
                                                                viewBox="0 0 16 16">
                                                                <path
                                                                    d="M13 2.5a1.5 1.5 0 0 1 3 0v11a1.5 1.5 0 0 1-3 0v-.214c-2.162-1.241-4.49-1.843-6.912-2.083l.405 2.712A1 1 0 0 1 5.51 15.1h-.548a1 1 0 0 1-.916-.599l-1.85-3.49a68.14 68.14 0 0 0-.202-.003A2.014 2.014 0 0 1 0 9V7a2.02 2.02 0 0 1 1.992-2.013 74.663 74.663 0 0 0 2.483-.075c3.043-.154 6.148-.849 8.525-2.199V2.5zm1 0v11a.5.5 0 0 0 1 0v-11a.5.5 0 0 0-1 0zm-1 1.35c-2.344 1.205-5.209 1.842-8 2.033v4.233c.18.01.359.022.537.036 2.568.189 5.093.744 7.463 1.993V3.85zm-9 6.215v-4.13a95.09 95.09 0 0 1-1.992.052A1.02 1.02 0 0 0 1 7v2c0 .55.448 1.002 1.006 1.009A60.49 60.49 0 0 1 4 10.065zm-.657.975 1.609 3.037.01.024h.548l-.002-.014-.443-2.966a68.019 68.019 0 0 0-1.722-.082z" />
                                                            </svg>
                                                            <span class="fw-bold">It's time to get points</span>
                                                        </div>
                                                        <p class="text-muted fw-bold mt-2">Your Digiclub points are
                                                            ready to receive. Get them before they expire</p>
                                                        <a class="d-flex align-items-center gap-2 mt-2 fw-bold">
                                                            Get points
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                                height="14" fill="currentColor"
                                                                class="bi bi-chevron-right" viewBox="0 0 16 16">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <span
                                                            class="bg-primary rounded-circle p-1 ms-auto w-3 h-3 d-sm-block d-none"></span>
                                                        <p class="text-secondary fw-bold text-center text-sm-end mt-5">23 july, 2023
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- empty -->
                                    <div class="empty text-center fw-bold">
                                        <div class="my-5 py-5">
                                            <img alt="empty" src="assets/img/empty-notification.svg"
                                                class="d-block mx-auto">
                                            <p>You have no notification yet</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- account details -->
                    <div data-id="7" id="accountDetails">
                        <div class="border rounded-3 d-flex flex-wrap gap-2 align-items-center justify-content-between p-3">
                            <div class="text-warning d-flex align-items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                    class="bi bi-info-circle-fill flex-shrink-0" viewBox="0 0 16 16">
                                    <path
                                        d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16zm.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2z" />
                                </svg>
                                <small class="fw-bold">By verifying your identity, you can increase the security of your
                                    account and use the possibility of "credit purchase".</small>
                            </div>
                            <a class="d-flex align-items-center gap-1 fw-bold">
                                Identity Verifying
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                    class="bi bi-chevron-right" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd"
                                        d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z" />
                                </svg>
                            </a>
                        </div>
                        <div class="border rounded-3 mt-3 row mx-2">
                            <div
                                class="col-lg-6 border-bottom py-3 border-end d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted fw-bold">First Name & Last Name</p>
                                    <p class="fw-bold mt-1">Yakoob Khedri</p>
                                </div>
                                <svg data-bs-toggle="modal" data-bs-target="#changeNameModal"
                                    xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor"
                                    class="bi bi-pencil-square cursor" viewBox="0 0 16 16">
                                    <path
                                        d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                    </path>
                                    <path fill-rule="evenodd"
                                        d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z">
                                    </path>
                                </svg>
                            </div>
                            <div class="col-lg-6 border-bottom py-3 d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted fw-bold">National Code</p>
                                    <p class="fw-bold mt-1">2840172429</p>
                                </div>
                                <svg data-bs-toggle="modal" data-bs-target="#changeNameModal"
                                    xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor"
                                    class="bi bi-pencil-square cursor" viewBox="0 0 16 16">
                                    <path
                                        d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                    </path>
                                    <path fill-rule="evenodd"
                                        d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z">
                                    </path>
                                </svg>
                            </div>
                            <div
                                class="col-lg-6 border-bottom py-3 border-end d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted fw-bold">Phone Number <span
                                            class="bg-success rounded-pill px-2 py-1 text-white fs-7">confirmed</span>
                                    </p>
                                    <p class="fw-bold mt-1">09149492490</p>
                                </div>
                                <svg data-bs-toggle="modal" data-bs-target="#changePhoneModal"
                                    xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor"
                                    class="bi bi-pencil-square cursor" viewBox="0 0 16 16">
                                    <path
                                        d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                    </path>
                                    <path fill-rule="evenodd"
                                        d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z">
                                    </path>
                                </svg>
                            </div>
                            <div class="col-lg-6 border-bottom py-3 d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted fw-bold">Email</p>
                                    <p class="fw-bold mt-1">yakkobkhedrii@gmail.com</p>
                                </div>
                                <svg data-bs-toggle="modal" data-bs-target="#changeEmailModal"
                                    xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor"
                                    class="bi bi-pencil-square cursor" viewBox="0 0 16 16">
                                    <path
                                        d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                    </path>
                                    <path fill-rule="evenodd"
                                        d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z">
                                    </path>
                                </svg>
                            </div>
                            <div
                                class="col-lg-6 border-bottom py-3 border-end d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted fw-bold">Password</p>
                                    <p class="fw-bold mt-1">25487648</p>
                                </div>
                                <svg data-bs-toggle="modal" data-bs-target="#changePasswordModal"
                                    xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor"
                                    class="bi bi-pencil-square cursor" viewBox="0 0 16 16">
                                    <path
                                        d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                    </path>
                                    <path fill-rule="evenodd"
                                        d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z">
                                    </path>
                                </svg>
                            </div>
                            <div class="col-lg-6 border-bottom py-3 d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted fw-bold">Return Money Type <span
                                            class="bg-success rounded-pill px-2 py-1 text-white fs-7">confirmed</span>
                                    </p>
                                    <p class="fw-bold mt-1">Card bank</p>
                                </div>
                                <svg data-bs-toggle="modal" data-bs-target="#returnMoneyModal"
                                    xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor"
                                    class="bi bi-pencil-square cursor" viewBox="0 0 16 16">
                                    <path
                                        d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                    </path>
                                    <path fill-rule="evenodd"
                                        d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z">
                                    </path>
                                </svg>
                            </div>
                            <div class="col-lg-6 py-3 border-end d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted fw-bold">BirthDay</p>
                                    <p class="fw-bold mt-1">2003/03/07</p>
                                </div>birthdayModal
                                <svg data-bs-toggle="modal" data-bs-target="#birthdayModal"
                                    xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor"
                                    class="bi bi-pencil-square cursor" viewBox="0 0 16 16">
                                    <path
                                        d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                    </path>
                                    <path fill-rule="evenodd"
                                        d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z">
                                    </path>
                                </svg>
                            </div>
                            <div class="col-lg-6 py-3 d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted fw-bold">Job</p>
                                    <p class="fw-bold mt-1">Programmer</p>
                                </div>
                                <svg data-bs-toggle="modal" data-bs-target="#jobModal"
                                    xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor"
                                    class="bi bi-pencil-square cursor" viewBox="0 0 16 16">
                                    <path
                                        d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                    </path>
                                    <path fill-rule="evenodd"
                                        d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z">
                                    </path>
                                </svg>
                            </div>
                        </div>
                        <div class="border rounded-3 mt-3 p-3">
                            <h5 class="font-bold d-table after">Legal Information</h5>
                            <p class="text-muted fw-bold mt-5">This option is for those who need institutional purchase
                                (with official invoice and value-added certificate).</p>
                            <a class="d-flex align-items-center mt-2 gap-1 fw-bold" data-bs-toggle="modal"
                                data-bs-target="#legalModal">
                                Registration of legal information
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                    class="bi bi-chevron-right" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd"
                                        d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
@endsection