<header>
    <!-- overlay -->
    <div id="overlay" class="position-fixed"></div>
    <div class="secondary-bg py-2 py-md-0">
        <div class="container">
            <div class="row">
                <div class="d-flex align-items-center gap-sm-3 gap-1 col-4">
                    <!-- hamIcon -->
                    <svg id="hamIcon" xmlns="http://www.w3.org/2000/svg" width="36" height="36" fill="currentColor"
                         class="bi bi-list cursor flex-shrink-0" viewBox="0 0 16 16">
                        <path fill-rule="evenodd"
                              d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5z"/>
                    </svg>
                    <!-- user -->
                    <div class="header-icon cursor">
                        <img alt="header-icon" src="<?php echo e(url('assets/img/user (1).svg')); ?>" class="nav-link dropdown-toggle"
                             id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <ul class="bg-white p-3 shadow-md m-0 list-unstyled fw-bold ul-drop dropdown-menu"
                            aria-labelledby="navbarDropdown">
                            <?php if(auth()->check()): ?>
                                <li class="pb-3">
                                    <a href="<?php echo e(route('front.profile.index')); ?>"
                                       class="d-flex align-items-center gap-2 text-dark">
                                        <img alt="profile" class="rounded-circle w-26"
                                             src="<?php echo e(url('assets/img/fd4840b2.svg')); ?>">
                                        <p><?php echo e(auth()->user()->first_name.' '.auth()->user()->last_name); ?></p>
                                    </a>
                                </li>
                                <li class="border-top py-3">
                                    <a href="<?php echo e(route('front.profile.index')); ?>#order"
                                       class="d-flex align-items-center gap-2 cursor text-dark">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                             fill="currentColor" class="bi bi-bag" viewBox="0 0 16 16">
                                            <path d="M8 1a2.5 2.5 0 0 1 2.5 2.5V4h-5v-.5A2.5 2.5 0 0 1 8 1zm3.5 3v-.5a3.5 3.5 0 1 0-7 0V4H1v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4h-3.5zM2 5h12v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V5z"></path>
                                        </svg>
                                        Orders
                                    </a>
                                </li>
                                <li class="border-top py-3">
                                    <a href="<?php echo e(route('front.profile.index')); ?>#list"
                                       class="d-flex align-items-center gap-2 cursor text-dark">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                             fill="currentColor" class="bi bi-heart" viewBox="0 0 16 16">
                                            <path d="m8 2.748-.717-.737C5.6.281 2.514.878 1.4 3.053c-.523 1.023-.641 2.5.314 4.385.92 1.815 2.834 3.989 6.286 6.357 3.452-2.368 5.365-4.542 6.286-6.357.955-1.886.838-3.362.314-4.385C13.486.878 10.4.28 8.717 2.01L8 2.748zM8 15C-7.333 4.868 3.279-3.04 7.824 1.143c.06.055.119.112.176.171a3.12 3.12 0 0 1 .176-.17C12.72-3.042 23.333 4.867 8 15z"></path>
                                        </svg>
                                        Lists
                                    </a>
                                </li>
                                <li class="border-top py-3">
                                    <a href="<?php echo e(route('front.profile.index')); ?>#comment"
                                       class="d-flex align-items-center gap-2 cursor text-dark">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                             fill="currentColor" class="bi bi-chat" viewBox="0 0 16 16">
                                            <path d="M2.678 11.894a1 1 0 0 1 .287.801 10.97 10.97 0 0 1-.398 2c1.395-.323 2.247-.697 2.634-.893a1 1 0 0 1 .71-.074A8.06 8.06 0 0 0 8 14c3.996 0 7-2.807 7-6 0-3.192-3.004-6-7-6S1 4.808 1 8c0 1.468.617 2.83 1.678 3.894zm-.493 3.905a21.682 21.682 0 0 1-.713.129c-.2.032-.352-.176-.273-.362a9.68 9.68 0 0 0 .244-.637l.003-.01c.248-.72.45-1.548.524-2.319C.743 11.37 0 9.76 0 8c0-3.866 3.582-7 8-7s8 3.134 8 7-3.582 7-8 7a9.06 9.06 0 0 1-2.347-.306c-.52.263-1.639.742-3.468 1.105z"></path>
                                        </svg>
                                        Comments
                                    </a>
                                </li>
                                <li class="border-top pt-3">
                                    <form action="<?php echo e(route('logout')); ?>" class="d-none" id="logout"
                                          method="post"><?php echo e(csrf_field()); ?></form>
                                    <a href="javascript:void(0)" onclick="$('#logout').submit()"
                                       class="d-flex align-items-center gap-2 cursor text-dark">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                             fill="currentColor" class="bi bi-box-arrow-left" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd"
                                                  d="M6 12.5a.5.5 0 0 0 .5.5h8a.5.5 0 0 0 .5-.5v-9a.5.5 0 0 0-.5-.5h-8a.5.5 0 0 0-.5.5v2a.5.5 0 0 1-1 0v-2A1.5 1.5 0 0 1 6.5 2h8A1.5 1.5 0 0 1 16 3.5v9a1.5 1.5 0 0 1-1.5 1.5h-8A1.5 1.5 0 0 1 5 12.5v-2a.5.5 0 0 1 1 0v2z"></path>
                                            <path fill-rule="evenodd"
                                                  d="M.146 8.354a.5.5 0 0 1 0-.708l3-3a.5.5 0 1 1 .708.708L1.707 7.5H10.5a.5.5 0 0 1 0 1H1.707l2.147 2.146a.5.5 0 0 1-.708.708l-3-3z"></path>
                                        </svg>
                                        Logout
                                    </a>
                                </li>
                            <?php else: ?>
                                <li><a class="d-block mb-3 text-dark transition" href="<?php echo e(route('login')); ?>">Sign In</a>
                                </li>
                                <li><a class="d-block text-dark transition" href="<?php echo e(route('register')); ?>">Register</a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <!-- search -->
                    <div>
                        <svg xmlns="http://www.w3.org/2000/svg" width="24"
                             height="24" fill="currentColor"
                             class="bi bi-search cursor dropdown-toggle" id="navbarDropdown" role="button"
                             data-bs-toggle="dropdown" aria-expanded="false" viewBox="0 0 16 16">
                            <path
                                    d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                        </svg>
                        <ul class="bg-white p-3 shadow-md m-0 list-unstyled ul-drop dropdown-menu"
                            aria-labelledby="navbarDropdown">
                            <div class="position-relative">
                                <input placeholder="Search" class="form-control border-2 border-dark bg-transparent">
                                <svg style="right: 12px;top: 11px;" xmlns="http://www.w3.org/2000/svg" width="20"
                                     height="20"
                                     fill="currentColor" class="bi bi-search position-absolute cursor text-secondary"
                                     viewBox="0 0 16 16">
                                    <path
                                            d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                                </svg>
                            </div>
                        </ul>
                    </div>
                </div>
                <!-- logo -->
                <a class="<?php echo e(panel_logo()[0] == 1?'d-block':'d-flex'); ?> col-4" href="<?php echo e(route('front.index')); ?>">
                    <?php if(panel_logo()[0] == 1): ?>
                        <img alt="logo" src="<?php echo e(panel_logo()[1]); ?>"
                             class="img-fluid d-block mx-auto max-h-75px">
                    <?php else: ?>
                        <img alt="logo" src="<?php echo e(panel_logo()[1]); ?>"
                             class="img-fluid logo1_2">
                        <img alt="logo" src="<?php echo e(panel_logo()[2]); ?>"
                             class="img-fluid logo2_2">
                    <?php endif; ?>
                </a>
                <!-- cart && user -->
                <div class="d-flex align-items-center justify-content-end gap-sm-4 gap-2 col-4">
                    <div class="d-block position-relative header-icon cursor">
                        <img alt="header-icon" <?php if($basket_count > 0): ?> onclick="window.location.href='<?php echo e(route('front.cart.index')); ?>'" <?php endif; ?> src="<?php echo e(url('assets/img/cart.svg')); ?>" class="nav-link dropdown-toggle"
                             id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <?php if($basket_count > 0): ?>
                            <span class="basket_count badge bg-danger"><?php echo e($basket_count); ?></span>
                        <?php else: ?>
                            <div
                                    class="position-absolute text-center bg-white p-3 shadow-md m-0 list-unstyled ul-drop cart-drop dropdown-menu"
                                    aria-labelledby="navbarDropdown">
                                <div>
                                    <img alt="header-icon" src="<?php echo e(url('assets/img/cart.svg')); ?>">
                                    <p class="fw-bold primary-color">Shopping cart is Empty</p>
                                    <p class="mt-2">
                                        Welcome back! if you had items in your shopping cart, we save them for you <a
                                                class="fw-bold primary-color" href="<?php echo e(route('login')); ?>">Sign In</a> now
                                        to see them or whenever you're
                                        ready to check out.
                                    </p>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="d-block position-relative header-icon cursor">
                        <img alt="header-icon" src="<?php echo e(url('assets/img/love.svg')); ?>">
                        <?php if($basket_count > 0): ?>
                            <span class="basket_count badge bg-danger"><?php echo e($favorite_count); ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="d-block position-relative header-icon cursor">
                        <img alt="header-icon" src="<?php echo e(url('assets/img/language.svg')); ?>" class="nav-link dropdown-toggle"
                             id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <div class="position-absolute bg-white p-3 shadow-md m-0 list-unstyled ul-drop cart-drop dropdown-menu"
                             aria-labelledby="navbarDropdown">
                            <form action="<?php echo e(route('front.price.type.set')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <label class="fw-bold form-label">Currency</label>
                                <select class="form-control" name="price_type_id" onchange="return this.form.submit()">
                                    <?php $__currentLoopData = $price_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option class="text-secondary"
                                                value="<?php echo e($price_type->id); ?>" <?php echo e(session()->has('price_set') && session('price_set')==$price_type->id || $price_type->id==1 ? 'selected' : ''); ?>><?php echo e($price_type->short); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </form>
                            <div class="mt-3">
                                <label class="fw-bold form-label border-bottom w-100 pb-2">Language</label>
                                <div class="d-flex gap-3 align-items-center flex-wrap language">
                                    <a class="cursor fw-bold text-dark transition">English</a>
                                    <a class="cursor fw-bold text-dark transition">Arabic</a>
                                </div>
                            </div>
                            <a class="text-center d-block fw-bold mt-3">International Site</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if(count($categories)): ?>
        <div class="swiper menuSwiper container py-3 text-center">
            <div class="swiper-wrapper">
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('front.product.index',[$category->id,read_lang($category,'slug')])); ?>"
                       class="swiper-slide px-2 text-dark fw-bold"><?php echo e(read_lang($category,'name')); ?></a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
<?php endif; ?>
<!-- nav -->
    <nav class="p-3">
        <ul
                class="list-unstyled mb-0 d-flex pt-5 ps-4 ps-lg-0 pt-lg-0 flex-column align-items-start justify-content-lg-between justify-content-start gap-4">
            <li>
                <a href="<?php echo e(route('front.index')); ?>" class="d-block text-dark h6 fw-bold transition mb-0">Home</a>
            </li>
            <li>
                <a href="<?php echo e(route('front.about')); ?>" class="d-block text-dark h6 fw-bold transition mb-0">About Us</a>
            </li>
            <li>
                <a href="<?php echo e(route('front.contact')); ?>" class="d-block text-dark h6 fw-bold transition mb-0">Contact Us</a>
            </li>
            <li>
                <a href="<?php echo e(route('front.product.index')); ?>"
                   class="d-block text-dark h6 fw-bold transition mb-0">products</a>
            </li>
            <li>
                <a href="<?php echo e(route('front.blog.index')); ?>" class="d-block text-dark h6 fw-bold transition mb-0">Blog</a>
            </li>
            <li>
                <a href="<?php echo e(route('front.how.order')); ?>" class="d-block text-dark h6 fw-bold transition mb-0">Guide</a>
            </li>
        </ul>
    </nav>

</header><?php /**PATH /home/mohsen/Desktop/sloppy-Desktop/adib-gostar/rozgol/back/source/resources/views/en/layouts/includes_front/header.blade.php ENDPATH**/ ?>